/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.SearchField;
import com.dlsc.gemsfx.skins.SearchFieldPopup;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Consumer;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.scene.input.MouseButton;
import javafx.util.StringConverter;

public class SearchFieldPopupSkin<T>
implements Skin<SearchFieldPopup<T>> {
    private final SearchFieldPopup<T> control;
    private final ListView<T> listView;
    private final SearchField<T> searchField;

    public SearchFieldPopupSkin(SearchFieldPopup<T> control) {
        this.control = control;
        this.searchField = control.getSearchField();
        SortedList sortedList = new SortedList(this.searchField.getSuggestions(), this.createInnerComparator());
        this.listView = new ListView<T>((ObservableList)sortedList){

            public String getUserAgentStylesheet() {
                return Objects.requireNonNull(SearchField.class.getResource("search-field.css")).toExternalForm();
            }
        };
        this.listView.getStyleClass().add((Object)"search-field-list-view");
        this.listView.cellFactoryProperty().bind(this.searchField.cellFactoryProperty());
        this.listView.prefWidthProperty().bind((ObservableValue)control.prefWidthProperty());
        this.listView.maxWidthProperty().bind((ObservableValue)control.maxWidthProperty());
        this.listView.minWidthProperty().bind((ObservableValue)control.minWidthProperty());
        this.listView.placeholderProperty().bind(this.searchField.placeholderProperty());
        this.listView.getSelectionModel().selectedItemProperty().addListener(it -> control.getSearchField().setSelectedItem(this.listView.getSelectionModel().getSelectedItem()));
        this.registerEventListener();
    }

    private Comparator<T> createInnerComparator() {
        return (o1, o2) -> {
            Comparator<Object> comparator = this.searchField.getComparator();
            int result = comparator.compare(o1, o2);
            T selectedItem = this.searchField.getSelectedItem();
            if (selectedItem != null) {
                if (o1.equals(selectedItem)) {
                    result = -1;
                }
                if (selectedItem.equals(o2)) {
                    result = 1;
                }
            }
            StringConverter<T> converter = this.searchField.getConverter();
            String searchText = this.searchField.getText().toLowerCase();
            String text1 = converter.toString(o1).toLowerCase();
            String text2 = converter.toString(o2).toLowerCase();
            if (text1.startsWith(searchText) && text2.startsWith(searchText)) {
                return text1.compareTo(text2);
            }
            if (text1.startsWith(searchText)) {
                result = -1;
            }
            if (text2.startsWith(searchText)) {
                result = 1;
            }
            return result;
        };
    }

    private void registerEventListener() {
        this.listView.setOnMouseClicked(me -> {
            if (me.getButton() == MouseButton.PRIMARY && me.getClickCount() == 1) {
                this.selectItem();
            }
        });
    }

    private void selectItem() {
        Object selectedItem = this.listView.getSelectionModel().getSelectedItem();
        if (selectedItem != null) {
            this.searchField.select(selectedItem);
            this.searchField.commit();
            Consumer<Object> onCommit = this.searchField.getOnCommit();
            if (onCommit != null) {
                onCommit.accept(selectedItem);
            }
        }
    }

    public Node getNode() {
        return this.listView;
    }

    public SearchFieldPopup<T> getSkinnable() {
        return this.control;
    }

    public void dispose() {
    }
}

