/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.treeview.link;

import com.dlsc.gemsfx.treeview.TreeNodeView;
import com.dlsc.gemsfx.treeview.link.AbstractLinkStrategy;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;

public class LogarithmicLink<T>
extends AbstractLinkStrategy<T> {
    @Override
    protected ArrayList<Node> drawLink(TreeNodeView.LayoutDirection direction, double maxDimensionInLine, double startX, double startY, double endX, double endY, double vgap, double hgap) {
        Path path = new Path();
        path.getStyleClass().add((Object)"link-path");
        path.getElements().add((Object)new MoveTo(startX, startY));
        if (direction == TreeNodeView.LayoutDirection.TOP_TO_BOTTOM || direction == TreeNodeView.LayoutDirection.BOTTOM_TO_TOP) {
            for (i = 1; i <= 10; ++i) {
                double fraction = (double)i * 1.0 / 10.0;
                double x = startX + fraction * (endX - startX);
                double y = startY + Math.log(1.0 + fraction) / Math.log(2.0) * (endY - startY);
                path.getElements().add((Object)new LineTo(x, y));
            }
        } else {
            for (i = 1; i <= 10; ++i) {
                double fraction = (double)i * 1.0 / 10.0;
                double x = startX + Math.log(1.0 + fraction) / Math.log(2.0) * (endX - startX);
                double y = startY + fraction * (endY - startY);
                path.getElements().add((Object)new LineTo(x, y));
            }
        }
        Node arrow = this.createSimpleArrow();
        arrow.setRotate(this.calculateAngle(startX, startY, endX, endY));
        return new ArrayList<Node>(List.of(path, arrow));
    }
}

