/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.treeview.link;

import com.dlsc.gemsfx.treeview.TreeNodeView;
import com.dlsc.gemsfx.treeview.link.AbstractLinkStrategy;
import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.shape.QuadCurve;

public class QuadCurveLink<T>
extends AbstractLinkStrategy<T> {
    @Override
    protected ArrayList<Node> drawLink(TreeNodeView.LayoutDirection direction, double maxDimensionInLine, double startX, double startY, double endX, double endY, double vgap, double hgap) {
        QuadCurve quad = new QuadCurve();
        quad.getStyleClass().add((Object)"link-curve");
        Node arrow = this.createSimpleArrow();
        switch (direction) {
            case TOP_TO_BOTTOM: {
                quad.setStartX(startX);
                quad.setStartY(startY);
                quad.setControlX((startX + endX) / 2.0);
                quad.setControlY(startY + vgap / 2.0);
                quad.setEndX(endX);
                quad.setEndY(endY);
                arrow.setRotate(this.getTangentAngle(quad, 0.95));
                break;
            }
            case BOTTOM_TO_TOP: {
                quad.setStartX(startX);
                quad.setStartY(startY);
                quad.setControlX((startX + endX) / 2.0);
                quad.setControlY(startY - vgap / 2.0);
                quad.setEndX(endX);
                quad.setEndY(endY);
                arrow.setRotate(this.getTangentAngle(quad, 0.05));
                break;
            }
            case LEFT_TO_RIGHT: {
                quad.setStartX(startX);
                quad.setStartY(startY);
                quad.setControlX(startX + hgap);
                quad.setControlY((startY + endY) / 2.0);
                quad.setEndX(endX);
                quad.setEndY(endY);
                arrow.setRotate(this.getTangentAngle(quad, 0.95));
                break;
            }
            case RIGHT_TO_LEFT: {
                quad.setStartX(startX);
                quad.setStartY(startY);
                quad.setControlX(startX - hgap);
                quad.setControlY((startY + endY) / 2.0);
                quad.setEndX(endX);
                quad.setEndY(endY);
                if (startY == endY) {
                    arrow.setRotate(180.0);
                    break;
                }
                double rtlAngle = this.getTangentAngle(quad, 0.05);
                arrow.setRotate(rtlAngle > 0.0 ? rtlAngle - 180.0 : rtlAngle + 180.0);
            }
        }
        return new ArrayList<Node>(List.of(quad, arrow));
    }

    private Point2D getPointOnQuadCurve(QuadCurve curve, double t) {
        double x = (1.0 - t) * (1.0 - t) * curve.getStartX() + 2.0 * (1.0 - t) * t * curve.getControlX() + t * t * curve.getEndX();
        double y = (1.0 - t) * (1.0 - t) * curve.getStartY() + 2.0 * (1.0 - t) * t * curve.getControlY() + t * t * curve.getEndY();
        return new Point2D(x, y);
    }
}

