/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.unitfx.util;

import javax.measure.Quantity;
import javax.measure.Unit;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.quantity.Quantities;

public final class QuantitiesUtil {
    private QuantitiesUtil() {
    }

    public static <Q extends Quantity<Q>> Quantity<Q> createQuantity(Number value, Unit<Q> unit) {
        ComparableQuantity valueQuantity = null;
        if (value != null && unit != null) {
            valueQuantity = Quantities.getQuantity((Number)value, unit);
        }
        return valueQuantity;
    }

    public static <Q extends Quantity<Q>> Quantity<Q> truncateQuantity(Quantity<Q> value, Quantity<Q> precision) {
        Quantity valueInSystemUnit = value.toSystemUnit();
        Quantity precisionInSystemUnit = precision.toSystemUnit();
        Quantity divideResult = valueInSystemUnit.divide(precisionInSystemUnit);
        Quantity truncatedValueInPrecisionUnits = precision.multiply((Number)divideResult.getValue().intValue());
        Quantity truncatedValueInValueUnits = truncatedValueInPrecisionUnits.to(value.getUnit());
        return truncatedValueInValueUnits;
    }

    public static <Q extends Quantity<Q>> Quantity<Q> roundQuantity(Quantity<Q> value, Quantity<Q> precision) {
        Quantity valueInSystemUnit = value.toSystemUnit();
        Quantity precisionInSystemUnit = precision.toSystemUnit();
        Quantity divideResult = valueInSystemUnit.divide(precisionInSystemUnit);
        long multiplier = Math.round(divideResult.getValue().doubleValue());
        Quantity truncatedValueInPrecisionUnits = precision.multiply((Number)multiplier);
        Quantity truncatedValueInValueUnits = truncatedValueInPrecisionUnits.to(value.getUnit());
        return truncatedValueInValueUnits;
    }
}

