/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.ast.type;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.javamodularity.moduleplugin.shadow.javaparser.TokenRange;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.AllFieldsConstructor;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Node;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.NodeList;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.VariableDeclarator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.AnnotationExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.Expression;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.VariableDeclarationExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.stmt.ForEachStmt;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.type.Type;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.visitor.CloneVisitor;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.visitor.GenericVisitor;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.visitor.VoidVisitor;
import org.javamodularity.moduleplugin.shadow.javaparser.metamodel.JavaParserMetaModel;
import org.javamodularity.moduleplugin.shadow.javaparser.metamodel.VarTypeMetaModel;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.Context;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedArrayType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedReferenceType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedType;

public class VarType
extends Type {
    private static final String JAVA_LANG_OBJECT = Object.class.getCanonicalName();

    @AllFieldsConstructor
    public VarType() {
        this((TokenRange)null);
    }

    public VarType(TokenRange tokenRange) {
        super(tokenRange);
        this.customInitialization();
    }

    @Override
    public VarType setAnnotations(NodeList<AnnotationExpr> annotations) {
        return (VarType)super.setAnnotations(annotations);
    }

    @Override
    public String asString() {
        return "var";
    }

    @Override
    public VarType clone() {
        return (VarType)this.accept(new CloneVisitor(), null);
    }

    @Override
    public VarTypeMetaModel getMetaModel() {
        return JavaParserMetaModel.varTypeMetaModel;
    }

    @Override
    public ResolvedType resolve() {
        return this.getSymbolResolver().toResolvedType(this, ResolvedType.class);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public boolean isVarType() {
        return true;
    }

    @Override
    public VarType asVarType() {
        return this;
    }

    @Override
    public Optional<VarType> toVarType() {
        return Optional.of(this);
    }

    @Override
    public void ifVarType(Consumer<VarType> action) {
        action.accept(this);
    }

    @Override
    public ResolvedType convertToUsage(Context context) {
        Optional<ForEachStmt> forEachStmt;
        Node parent = this.getParentNode().get();
        if (!(parent instanceof VariableDeclarator)) {
            throw new IllegalStateException("Trying to resolve a `var` which is not in a variable declaration.");
        }
        VariableDeclarator variableDeclarator = (VariableDeclarator)parent;
        Optional<Expression> initializer = variableDeclarator.getInitializer();
        if (!initializer.isPresent() && (forEachStmt = this.forEachStmtWithVariableDeclarator(variableDeclarator)).isPresent()) {
            Expression iterable = forEachStmt.get().getIterable();
            ResolvedType iterType = iterable.calculateResolvedType();
            if (iterType instanceof ResolvedArrayType) {
                return ((ResolvedArrayType)iterType).getComponentType();
            }
            if (iterType.isReferenceType()) {
                List<ResolvedType> parametersType = iterType.asReferenceType().typeParametersMap().getTypes();
                if (parametersType.isEmpty()) {
                    Optional<ResolvedTypeDeclaration> oObjectDeclaration = context.solveType(JAVA_LANG_OBJECT).getDeclaration();
                    return (ResolvedType)oObjectDeclaration.map((Function<ResolvedTypeDeclaration, ResolvedReferenceType> & Serializable)decl -> ReferenceTypeImpl.undeterminedParameters(decl.asReferenceType())).orElseThrow((Supplier<UnsupportedOperationException> & Serializable)() -> new UnsupportedOperationException());
                }
                return parametersType.get(0);
            }
        }
        return (ResolvedType)initializer.map(Expression::calculateResolvedType).orElseThrow((Supplier<IllegalStateException> & Serializable)() -> new IllegalStateException("Cannot resolve `var` which has no initializer."));
    }

    private Optional<ForEachStmt> forEachStmtWithVariableDeclarator(VariableDeclarator variableDeclarator) {
        Optional<Node> node = variableDeclarator.getParentNode();
        if (!node.isPresent() || !(node.get() instanceof VariableDeclarationExpr)) {
            return Optional.empty();
        }
        if (!(node = node.get().getParentNode()).isPresent() || !(node.get() instanceof ForEachStmt)) {
            return Optional.empty();
        }
        return Optional.of((ForEachStmt)node.get());
    }
}

