/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.converter;

import java.util.Iterator;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import net.sourceforge.jeuclid.converter.ConverterDetector;
import net.sourceforge.jeuclid.converter.ConverterRegistry;
import net.sourceforge.jeuclid.converter.ImageIOConverter;

public final class ImageIODetector
implements ConverterDetector {
    @Override
    public void detectConversionPlugins(ConverterRegistry converterRegistry) {
        String[] stringArray = ImageIO.getWriterMIMETypes();
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("image/jpeg");
        treeSet.add("image/bmp");
        for (String string : stringArray) {
            Iterator<ImageWriter> iterator = ImageIO.getImageWritersByMIMEType(string);
            if (iterator == null) continue;
            while (iterator.hasNext()) {
                ImageWriter imageWriter = iterator.next();
                String[] stringArray2 = imageWriter.getOriginatingProvider().getFileSuffixes();
                if (stringArray2 != null) {
                    for (String string2 : stringArray2) {
                        converterRegistry.registerMimeTypeAndSuffix(string, string2, false);
                    }
                }
                converterRegistry.registerConverter(string, new ImageIOConverter(imageWriter, treeSet.contains(string)), false);
            }
        }
    }
}

