/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin;

import java.io.File;
import java.util.Optional;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.util.GradleVersion;
import org.javamodularity.moduleplugin.extensions.ModularityExtension;

public final class JavaProjectHelper {
    public static final String COMPILE_TEST_FIXTURES_JAVA_TASK_NAME = "compileTestFixturesJava";
    public static final String COMPILE_TEST_FIXTURES_KOTLIN_TASK_NAME = "compileTestFixturesKotlin";
    public static final String COMPILE_TEST_FIXTURES_GROOVY_TASK_NAME = "compileTestFixturesGroovy";
    public static final String TEST_FIXTURES_SOURCE_SET_NAME = "testFixtures";
    private final Project project;

    public JavaProjectHelper(Project project) {
        this.project = project;
    }

    public Project project() {
        return this.project;
    }

    public <T> T extension(Class<T> extensionType) {
        return (T)this.project.getExtensions().getByType(extensionType);
    }

    public <T> T extension(String name, Class<T> extensionType) {
        return extensionType.cast(this.project.getExtensions().getByName(name));
    }

    public ModularityExtension modularityExtension() {
        return this.extension(ModularityExtension.class);
    }

    public String moduleName() {
        return this.extension("moduleName", String.class);
    }

    public boolean shouldFixEffectiveArguments() {
        return GradleVersion.current().compareTo(GradleVersion.version((String)"6.4")) < 0 && this.modularityExtension().optionContainer().isEffectiveArgumentsAdjustmentEnabled();
    }

    public SourceSetContainer sourceSets() {
        return this.extension(SourceSetContainer.class);
    }

    public SourceSet sourceSet(String sourceSetName) {
        return (SourceSet)this.sourceSets().getByName(sourceSetName);
    }

    public SourceSet mainSourceSet() {
        return this.sourceSet("main");
    }

    public SourceSet testSourceSet() {
        return this.sourceSet("test");
    }

    public Optional<SourceSet> findSourceSet(String sourceSetName) {
        return Optional.ofNullable((SourceSet)this.sourceSets().findByName(sourceSetName));
    }

    public Optional<SourceSet> findTestFixturesSourceSet() {
        return this.findSourceSet(TEST_FIXTURES_SOURCE_SET_NAME);
    }

    public Task task(String taskName) {
        return this.project.getTasks().getByName(taskName);
    }

    public Optional<Task> findTask(String taskName) {
        return Optional.ofNullable((Task)this.project.getTasks().findByName(taskName));
    }

    public <T extends Task> T task(String taskName, Class<T> taskType) {
        return (T)((Task)taskType.cast(this.task(taskName)));
    }

    public <T extends Task> Optional<T> findTask(String taskName, Class<T> taskType) {
        return this.findTask(taskName).map(taskType::cast);
    }

    public JavaCompile compileJavaTask(String taskName) {
        return this.task(taskName, JavaCompile.class);
    }

    public File getMergedDir() {
        return new File(this.project.getBuildDir(), "classes/merged");
    }

    public File getModuleInfoDir() {
        return new File(this.project.getBuildDir(), "classes/module-info");
    }
}

