/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.AccessSpecifier;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.Context;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.MethodUsage;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.TypeSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedParameterDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedType;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.core.resolution.TypeVariableResolutionCapability;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.declarations.common.MethodDeclarationCommonLogic;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionClassDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionEnumDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionFactory;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionInterfaceDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionParameterDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionTypeParameter;
import org.javamodularity.moduleplugin.shadow.javaparser.utils.TypeUtils;

public class ReflectionMethodDeclaration
implements ResolvedMethodDeclaration,
TypeVariableResolutionCapability {
    private Method method;
    private TypeSolver typeSolver;

    public ReflectionMethodDeclaration(Method method, TypeSolver typeSolver) {
        this.method = method;
        if (method.isSynthetic() || method.isBridge()) {
            throw new IllegalArgumentException();
        }
        this.typeSolver = typeSolver;
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    @Override
    public boolean isField() {
        return false;
    }

    @Override
    public boolean isParameter() {
        return false;
    }

    public String toString() {
        return "ReflectionMethodDeclaration{method=" + this.method + '}';
    }

    @Override
    public boolean isType() {
        return false;
    }

    @Override
    public ResolvedReferenceTypeDeclaration declaringType() {
        if (this.method.getDeclaringClass().isInterface()) {
            return new ReflectionInterfaceDeclaration(this.method.getDeclaringClass(), this.typeSolver);
        }
        if (this.method.getDeclaringClass().isEnum()) {
            return new ReflectionEnumDeclaration(this.method.getDeclaringClass(), this.typeSolver);
        }
        return new ReflectionClassDeclaration(this.method.getDeclaringClass(), this.typeSolver);
    }

    @Override
    public ResolvedType getReturnType() {
        return ReflectionFactory.typeUsageFor(this.method.getGenericReturnType(), this.typeSolver);
    }

    @Override
    public int getNumberOfParams() {
        return this.method.getParameterTypes().length;
    }

    @Override
    public ResolvedParameterDeclaration getParam(int i) {
        boolean variadic = false;
        if (this.method.isVarArgs()) {
            variadic = i == this.method.getParameterCount() - 1;
        }
        return new ReflectionParameterDeclaration(this.method.getParameterTypes()[i], this.method.getGenericParameterTypes()[i], this.typeSolver, variadic, this.method.getParameters()[i].getName());
    }

    @Override
    public List<ResolvedTypeParameterDeclaration> getTypeParameters() {
        return Arrays.stream(this.method.getTypeParameters()).map(refTp -> new ReflectionTypeParameter((TypeVariable)refTp, false, this.typeSolver)).collect(Collectors.toList());
    }

    @Override
    public MethodUsage resolveTypeVariables(Context context, List<ResolvedType> parameterTypes) {
        return new MethodDeclarationCommonLogic(this, this.typeSolver).resolveTypeVariables(context, parameterTypes);
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.method.getModifiers());
    }

    @Override
    public boolean isDefaultMethod() {
        return this.method.isDefault();
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    @Override
    public AccessSpecifier accessSpecifier() {
        return ReflectionFactory.modifiersToAccessLevel(this.method.getModifiers());
    }

    @Override
    public int getNumberOfSpecifiedExceptions() {
        return this.method.getExceptionTypes().length;
    }

    @Override
    public ResolvedType getSpecifiedException(int index) {
        if (index < 0 || index >= this.getNumberOfSpecifiedExceptions()) {
            throw new IllegalArgumentException();
        }
        return ReflectionFactory.typeUsageFor(this.method.getExceptionTypes()[index], this.typeSolver);
    }

    @Override
    public String toDescriptor() {
        return TypeUtils.getMethodDescriptor(this.method);
    }
}

