/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.tinylog.Level;
import org.tinylog.Supplier;
import org.tinylog.configuration.Configuration;
import org.tinylog.format.AdvancedMessageFormatter;
import org.tinylog.format.MessageFormatter;
import org.tinylog.provider.LoggingProvider;
import org.tinylog.provider.ProviderRegistry;

public final class TaggedLogger {
    private static final int STACKTRACE_DEPTH = 2;
    private static final MessageFormatter formatter = new AdvancedMessageFormatter(Configuration.getLocale(), Configuration.isEscapingEnabled());
    private static final LoggingProvider provider = ProviderRegistry.getLoggingProvider();
    private final Set<String> traceTags;
    private final Set<String> debugTags;
    private final Set<String> infoTags;
    private final Set<String> warnTags;
    private final Set<String> errorTags;
    private final boolean minimumLevelCoversTrace;
    private final boolean minimumLevelCoversDebug;
    private final boolean minimumLevelCoversInfo;
    private final boolean minimumLevelCoversWarn;
    private final boolean minimumLevelCoversError;
    private final Set<String> tags;

    TaggedLogger(String tag) {
        this(Collections.singleton(tag));
    }

    TaggedLogger(Set<String> tags) {
        this.tags = Collections.unmodifiableSet(tags);
        this.traceTags = TaggedLogger.getCoveredTags(tags, Level.TRACE);
        this.debugTags = TaggedLogger.getCoveredTags(tags, Level.DEBUG);
        this.infoTags = TaggedLogger.getCoveredTags(tags, Level.INFO);
        this.warnTags = TaggedLogger.getCoveredTags(tags, Level.WARN);
        this.errorTags = TaggedLogger.getCoveredTags(tags, Level.ERROR);
        this.minimumLevelCoversTrace = !this.traceTags.isEmpty();
        this.minimumLevelCoversDebug = !this.debugTags.isEmpty();
        this.minimumLevelCoversInfo = !this.infoTags.isEmpty();
        this.minimumLevelCoversWarn = !this.warnTags.isEmpty();
        this.minimumLevelCoversError = !this.errorTags.isEmpty();
    }

    public boolean isTraceEnabled() {
        return this.minimumLevelCoversTrace && TaggedLogger.anyEnabled(this.traceTags, Level.TRACE);
    }

    public void trace(Object message) {
        if (this.minimumLevelCoversTrace) {
            for (String tag : this.traceTags) {
                provider.log(2, tag, Level.TRACE, null, null, message, (Object[])null);
            }
        }
    }

    public void trace(Supplier<?> message) {
        if (this.minimumLevelCoversTrace) {
            for (String tag : this.traceTags) {
                provider.log(2, tag, Level.TRACE, null, null, message, (Object[])null);
            }
        }
    }

    public void trace(String message, Object ... arguments) {
        if (this.minimumLevelCoversTrace) {
            for (String tag : this.traceTags) {
                provider.log(2, tag, Level.TRACE, null, formatter, (Object)message, arguments);
            }
        }
    }

    public void trace(String message, Supplier<?> ... arguments) {
        if (this.minimumLevelCoversTrace) {
            for (String tag : this.traceTags) {
                provider.log(2, tag, Level.TRACE, null, formatter, (Object)message, (Object[])arguments);
            }
        }
    }

    public void trace(Throwable exception) {
        if (this.minimumLevelCoversTrace) {
            for (String tag : this.traceTags) {
                provider.log(2, tag, Level.TRACE, exception, null, null, (Object[])null);
            }
        }
    }

    public void trace(Throwable exception, String message) {
        if (this.minimumLevelCoversTrace) {
            for (String tag : this.traceTags) {
                provider.log(2, tag, Level.TRACE, exception, null, (Object)message, (Object[])null);
            }
        }
    }

    public void trace(Throwable exception, Supplier<String> message) {
        if (this.minimumLevelCoversTrace) {
            for (String tag : this.traceTags) {
                provider.log(2, tag, Level.TRACE, exception, null, message, (Object[])null);
            }
        }
    }

    public void trace(Throwable exception, String message, Object ... arguments) {
        if (this.minimumLevelCoversTrace) {
            for (String tag : this.traceTags) {
                provider.log(2, tag, Level.TRACE, exception, formatter, (Object)message, arguments);
            }
        }
    }

    public void trace(Throwable exception, String message, Supplier<?> ... arguments) {
        if (this.minimumLevelCoversTrace) {
            for (String tag : this.traceTags) {
                provider.log(2, tag, Level.TRACE, exception, formatter, (Object)message, (Object[])arguments);
            }
        }
    }

    public boolean isDebugEnabled() {
        return this.minimumLevelCoversDebug && TaggedLogger.anyEnabled(this.debugTags, Level.DEBUG);
    }

    public void debug(Object message) {
        if (this.minimumLevelCoversDebug) {
            for (String tag : this.debugTags) {
                provider.log(2, tag, Level.DEBUG, null, null, message, (Object[])null);
            }
        }
    }

    public void debug(Supplier<?> message) {
        if (this.minimumLevelCoversDebug) {
            for (String tag : this.debugTags) {
                provider.log(2, tag, Level.DEBUG, null, null, message, (Object[])null);
            }
        }
    }

    public void debug(String message, Object ... arguments) {
        if (this.minimumLevelCoversDebug) {
            for (String tag : this.debugTags) {
                provider.log(2, tag, Level.DEBUG, null, formatter, (Object)message, arguments);
            }
        }
    }

    public void debug(String message, Supplier<?> ... arguments) {
        if (this.minimumLevelCoversDebug) {
            for (String tag : this.debugTags) {
                provider.log(2, tag, Level.DEBUG, null, formatter, (Object)message, (Object[])arguments);
            }
        }
    }

    public void debug(Throwable exception) {
        if (this.minimumLevelCoversDebug) {
            for (String tag : this.debugTags) {
                provider.log(2, tag, Level.DEBUG, exception, null, null, (Object[])null);
            }
        }
    }

    public void debug(Throwable exception, String message) {
        if (this.minimumLevelCoversDebug) {
            for (String tag : this.debugTags) {
                provider.log(2, tag, Level.DEBUG, exception, null, (Object)message, (Object[])null);
            }
        }
    }

    public void debug(Throwable exception, Supplier<String> message) {
        if (this.minimumLevelCoversDebug) {
            for (String tag : this.debugTags) {
                provider.log(2, tag, Level.DEBUG, exception, null, message, (Object[])null);
            }
        }
    }

    public void debug(Throwable exception, String message, Object ... arguments) {
        if (this.minimumLevelCoversDebug) {
            for (String tag : this.debugTags) {
                provider.log(2, tag, Level.DEBUG, exception, formatter, (Object)message, arguments);
            }
        }
    }

    public void debug(Throwable exception, String message, Supplier<?> ... arguments) {
        if (this.minimumLevelCoversDebug) {
            for (String tag : this.debugTags) {
                provider.log(2, tag, Level.DEBUG, exception, formatter, (Object)message, (Object[])arguments);
            }
        }
    }

    public boolean isInfoEnabled() {
        return this.minimumLevelCoversInfo && TaggedLogger.anyEnabled(this.infoTags, Level.INFO);
    }

    public void info(Object message) {
        if (this.minimumLevelCoversInfo) {
            for (String tag : this.infoTags) {
                provider.log(2, tag, Level.INFO, null, null, message, (Object[])null);
            }
        }
    }

    public void info(Supplier<?> message) {
        if (this.minimumLevelCoversInfo) {
            for (String tag : this.infoTags) {
                provider.log(2, tag, Level.INFO, null, null, message, (Object[])null);
            }
        }
    }

    public void info(String message, Object ... arguments) {
        if (this.minimumLevelCoversInfo) {
            for (String tag : this.infoTags) {
                provider.log(2, tag, Level.INFO, null, formatter, (Object)message, arguments);
            }
        }
    }

    public void info(String message, Supplier<?> ... arguments) {
        if (this.minimumLevelCoversInfo) {
            for (String tag : this.infoTags) {
                provider.log(2, tag, Level.INFO, null, formatter, (Object)message, (Object[])arguments);
            }
        }
    }

    public void info(Throwable exception) {
        if (this.minimumLevelCoversInfo) {
            for (String tag : this.infoTags) {
                provider.log(2, tag, Level.INFO, exception, null, null, (Object[])null);
            }
        }
    }

    public void info(Throwable exception, String message) {
        if (this.minimumLevelCoversInfo) {
            for (String tag : this.infoTags) {
                provider.log(2, tag, Level.INFO, exception, null, (Object)message, (Object[])null);
            }
        }
    }

    public void info(Throwable exception, Supplier<String> message) {
        if (this.minimumLevelCoversInfo) {
            for (String tag : this.infoTags) {
                provider.log(2, tag, Level.INFO, exception, null, message, (Object[])null);
            }
        }
    }

    public void info(Throwable exception, String message, Object ... arguments) {
        if (this.minimumLevelCoversInfo) {
            for (String tag : this.infoTags) {
                provider.log(2, tag, Level.INFO, exception, formatter, (Object)message, arguments);
            }
        }
    }

    public void info(Throwable exception, String message, Supplier<?> ... arguments) {
        if (this.minimumLevelCoversInfo) {
            for (String tag : this.infoTags) {
                provider.log(2, tag, Level.INFO, exception, formatter, (Object)message, (Object[])arguments);
            }
        }
    }

    public boolean isWarnEnabled() {
        return this.minimumLevelCoversWarn && TaggedLogger.anyEnabled(this.warnTags, Level.WARN);
    }

    public void warn(Object message) {
        if (this.minimumLevelCoversWarn) {
            for (String tag : this.warnTags) {
                provider.log(2, tag, Level.WARN, null, null, message, (Object[])null);
            }
        }
    }

    public void warn(Supplier<?> message) {
        if (this.minimumLevelCoversWarn) {
            for (String tag : this.warnTags) {
                provider.log(2, tag, Level.WARN, null, null, message, (Object[])null);
            }
        }
    }

    public void warn(String message, Object ... arguments) {
        if (this.minimumLevelCoversWarn) {
            for (String tag : this.warnTags) {
                provider.log(2, tag, Level.WARN, null, formatter, (Object)message, arguments);
            }
        }
    }

    public void warn(String message, Supplier<?> ... arguments) {
        if (this.minimumLevelCoversWarn) {
            for (String tag : this.warnTags) {
                provider.log(2, tag, Level.WARN, null, formatter, (Object)message, (Object[])arguments);
            }
        }
    }

    public void warn(Throwable exception) {
        if (this.minimumLevelCoversWarn) {
            for (String tag : this.warnTags) {
                provider.log(2, tag, Level.WARN, exception, null, null, (Object[])null);
            }
        }
    }

    public void warn(Throwable exception, String message) {
        if (this.minimumLevelCoversWarn) {
            for (String tag : this.warnTags) {
                provider.log(2, tag, Level.WARN, exception, null, (Object)message, (Object[])null);
            }
        }
    }

    public void warn(Throwable exception, Supplier<String> message) {
        if (this.minimumLevelCoversWarn) {
            for (String tag : this.warnTags) {
                provider.log(2, tag, Level.WARN, exception, null, message, (Object[])null);
            }
        }
    }

    public void warn(Throwable exception, String message, Object ... arguments) {
        if (this.minimumLevelCoversWarn) {
            for (String tag : this.warnTags) {
                provider.log(2, tag, Level.WARN, exception, formatter, (Object)message, arguments);
            }
        }
    }

    public void warn(Throwable exception, String message, Supplier<?> ... arguments) {
        if (this.minimumLevelCoversWarn) {
            for (String tag : this.warnTags) {
                provider.log(2, tag, Level.WARN, exception, formatter, (Object)message, (Object[])arguments);
            }
        }
    }

    public boolean isErrorEnabled() {
        return this.minimumLevelCoversError && TaggedLogger.anyEnabled(this.errorTags, Level.ERROR);
    }

    public void error(Object message) {
        if (this.minimumLevelCoversError) {
            for (String tag : this.errorTags) {
                provider.log(2, tag, Level.ERROR, null, null, message, (Object[])null);
            }
        }
    }

    public void error(Supplier<?> message) {
        if (this.minimumLevelCoversError) {
            for (String tag : this.errorTags) {
                provider.log(2, tag, Level.ERROR, null, null, message, (Object[])null);
            }
        }
    }

    public void error(String message, Object ... arguments) {
        if (this.minimumLevelCoversError) {
            for (String tag : this.errorTags) {
                provider.log(2, tag, Level.ERROR, null, formatter, (Object)message, arguments);
            }
        }
    }

    public void error(String message, Supplier<?> ... arguments) {
        if (this.minimumLevelCoversError) {
            for (String tag : this.errorTags) {
                provider.log(2, tag, Level.ERROR, null, formatter, (Object)message, (Object[])arguments);
            }
        }
    }

    public void error(Throwable exception) {
        if (this.minimumLevelCoversError) {
            for (String tag : this.errorTags) {
                provider.log(2, tag, Level.ERROR, exception, null, null, (Object[])null);
            }
        }
    }

    public void error(Throwable exception, String message) {
        if (this.minimumLevelCoversError) {
            for (String tag : this.errorTags) {
                provider.log(2, tag, Level.ERROR, exception, null, (Object)message, (Object[])null);
            }
        }
    }

    public void error(Throwable exception, Supplier<String> message) {
        if (this.minimumLevelCoversError) {
            for (String tag : this.errorTags) {
                provider.log(2, tag, Level.ERROR, exception, null, message, (Object[])null);
            }
        }
    }

    public void error(Throwable exception, String message, Object ... arguments) {
        if (this.minimumLevelCoversError) {
            for (String tag : this.errorTags) {
                provider.log(2, tag, Level.ERROR, exception, formatter, (Object)message, arguments);
            }
        }
    }

    public void error(Throwable exception, String message, Supplier<?> ... arguments) {
        if (this.minimumLevelCoversError) {
            for (String tag : this.errorTags) {
                provider.log(2, tag, Level.ERROR, exception, formatter, (Object)message, (Object[])arguments);
            }
        }
    }

    private static boolean anyEnabled(Set<String> tags, Level level) {
        for (String tag : tags) {
            if (!provider.isEnabled(3, tag, level)) continue;
            return true;
        }
        return false;
    }

    private static Set<String> getCoveredTags(Set<String> tags, Level level) {
        HashSet<String> filtered = new HashSet<String>();
        for (String tag : tags) {
            if (!TaggedLogger.isCoveredByMinimumLevel(tag, level)) continue;
            filtered.add(tag);
        }
        return Collections.unmodifiableSet(filtered);
    }

    private static boolean isCoveredByMinimumLevel(String tag, Level level) {
        return provider.getMinimumLevel(tag).ordinal() <= level.ordinal();
    }
}

