/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.slf4j;

import java.util.List;
import org.slf4j.Marker;
import org.slf4j.event.LoggingEvent;
import org.slf4j.spi.LoggingEventAware;
import org.slf4j.spi.LoggingEventBuilder;
import org.slf4j.spi.NOPLoggingEventBuilder;
import org.tinylog.Level;
import org.tinylog.format.MessageFormatter;
import org.tinylog.slf4j.AbstractTinylogLogger;

public final class ModernTinylogLogger
extends AbstractTinylogLogger
implements LoggingEventAware {
    public ModernTinylogLogger(String name) {
        super(name);
    }

    public LoggingEventBuilder atTrace() {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_TRACE && provider.isEnabled(2, null, Level.TRACE)) {
            return this.makeLoggingEventBuilder(org.slf4j.event.Level.TRACE);
        }
        return NOPLoggingEventBuilder.singleton();
    }

    public LoggingEventBuilder atDebug() {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_DEBUG && provider.isEnabled(2, null, Level.DEBUG)) {
            return this.makeLoggingEventBuilder(org.slf4j.event.Level.DEBUG);
        }
        return NOPLoggingEventBuilder.singleton();
    }

    public LoggingEventBuilder atInfo() {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_INFO && provider.isEnabled(2, null, Level.INFO)) {
            return this.makeLoggingEventBuilder(org.slf4j.event.Level.INFO);
        }
        return NOPLoggingEventBuilder.singleton();
    }

    public LoggingEventBuilder atWarn() {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_WARN && provider.isEnabled(2, null, Level.WARN)) {
            return this.makeLoggingEventBuilder(org.slf4j.event.Level.WARN);
        }
        return NOPLoggingEventBuilder.singleton();
    }

    public LoggingEventBuilder atError() {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_ERROR && provider.isEnabled(2, null, Level.ERROR)) {
            return this.makeLoggingEventBuilder(org.slf4j.event.Level.ERROR);
        }
        return NOPLoggingEventBuilder.singleton();
    }

    public void log(LoggingEvent event) {
        String tag;
        Level severityLevel = ModernTinylogLogger.translateLevel(event.getLevel().toInt());
        List markers = event.getMarkers();
        Marker marker = markers == null || markers.isEmpty() ? null : (Marker)markers.get(0);
        String string = tag = marker == null ? null : marker.getName();
        if (provider.getMinimumLevel(tag).ordinal() <= severityLevel.ordinal()) {
            Object[] arguments = event.getArgumentArray();
            MessageFormatter formatter = arguments == null ? null : AbstractTinylogLogger.formatter;
            provider.log(event.getCallerBoundary(), tag, severityLevel, event.getThrowable(), formatter, (Object)event.getMessage(), arguments);
        }
    }
}

