/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.filter;

import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.WritableRaster;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBlendComposite
implements Composite {
    @NotNull
    protected abstract Blender blender();

    private static boolean isColorModelInvalid(ColorModel cm) {
        if (cm instanceof DirectColorModel && cm.getTransferType() == 3) {
            DirectColorModel directCM = (DirectColorModel)cm;
            return directCM.getRedMask() != 0xFF0000 || directCM.getGreenMask() != 65280 || directCM.getBlueMask() != 255 || directCM.getNumComponents() == 4 && directCM.getAlphaMask() != -16777216;
        }
        return true;
    }

    @Override
    public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
        if (AbstractBlendComposite.isColorModelInvalid(srcColorModel) || AbstractBlendComposite.isColorModelInvalid(dstColorModel)) {
            throw new RasterFormatException("Incompatible color models");
        }
        return new BlendingContext(this.blender());
    }

    private static final class BlendingContext
    implements CompositeContext {
        @NotNull
        private final Blender blender;

        private BlendingContext(@NotNull Blender blender) {
            this.blender = blender;
        }

        @Override
        public void dispose() {
        }

        @Override
        public void compose(@NotNull Raster src, @NotNull Raster dstIn, @NotNull WritableRaster dstOut) {
            int width = Math.min(src.getWidth(), dstIn.getWidth());
            int height = Math.min(src.getHeight(), dstIn.getHeight());
            int[] result = new int[4];
            int[] srcPixel = new int[4];
            int[] dstPixel = new int[4];
            int[] srcPixels = new int[width];
            int[] dstPixels = new int[width];
            for (int y = 0; y < height; ++y) {
                src.getDataElements(0, y, width, 1, srcPixels);
                dstIn.getDataElements(0, y, width, 1, dstPixels);
                for (int x = 0; x < width; ++x) {
                    int pixel = srcPixels[x];
                    srcPixel[0] = pixel >> 16 & 0xFF;
                    srcPixel[1] = pixel >> 8 & 0xFF;
                    srcPixel[2] = pixel & 0xFF;
                    srcPixel[3] = pixel >> 24 & 0xFF;
                    pixel = dstPixels[x];
                    dstPixel[0] = pixel >> 16 & 0xFF;
                    dstPixel[1] = pixel >> 8 & 0xFF;
                    dstPixel[2] = pixel & 0xFF;
                    dstPixel[3] = pixel >> 24 & 0xFF;
                    this.blender.blend(srcPixel, dstPixel, result);
                    dstPixels[x] = (result[3] & 0xFF) << 24 | (result[0] & 0xFF) << 16 | (result[1] & 0xFF) << 8 | result[2] & 0xFF;
                }
                dstOut.setDataElements(0, y, width, 1, dstPixels);
            }
        }
    }

    @FunctionalInterface
    static interface Blender {
        public void blend(int[] var1, int[] var2, int[] var3);
    }
}

