/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.filter;

import com.github.weisj.jsvg.nodes.filter.PixelProvider;
import com.github.weisj.jsvg.renderer.RenderContext;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageFilter;
import java.awt.image.ImageProducer;
import org.jetbrains.annotations.NotNull;

public interface Channel {
    @NotNull
    public ImageProducer producer();

    @NotNull
    default public Image toImage(@NotNull RenderContext context) {
        return context.createImage(this.producer());
    }

    @NotNull
    default public BufferedImage toBufferedImageNonAliased(@NotNull RenderContext context) {
        return Channel.makeNonAliased(this.toImage(context));
    }

    @NotNull
    public static BufferedImage makeNonAliased(@NotNull Image img) {
        BufferedImage bufferedImage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics imageGraphics = bufferedImage.getGraphics();
        imageGraphics.drawImage(img, 0, 0, null);
        imageGraphics.dispose();
        return bufferedImage;
    }

    @NotNull
    public Channel applyFilter(@NotNull ImageFilter var1);

    @NotNull
    public PixelProvider pixels(@NotNull RenderContext var1);
}

