/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.proxy;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import oracle.ucp.proxy.AnnotationsRegistry;
import oracle.ucp.proxy.ClassGenerator;
import oracle.ucp.proxy.ExtractDelegatePermission;
import oracle.ucp.proxy.GeneratedProxiesRegistry;
import oracle.ucp.proxy.NullProxy;
import oracle.ucp.proxy.WeakIdentityHashMap;
import oracle.ucp.proxy._Proxy_;

public class ProxyFactory {
    public static final String DEFAULT_PROXY_PACKAGE = "oracle.ucp.proxy";
    final AnnotationsRegistry annotationsRegistry = new AnnotationsRegistry();
    private final GeneratedProxiesRegistry generatedRegistry = new GeneratedProxiesRegistry();
    private final Map<Class, Constructor> delegateClassToProxyConstructor = new ConcurrentHashMap<Class, Constructor>();
    private final Map<Object, WeakReference<Object>> delegateToProxy = Collections.synchronizedMap(new WeakIdentityHashMap());
    private final Map<Class, Class> delegateToMostSuitableIface = new ConcurrentHashMap<Class, Class>();
    private static final Object STALE_DELEGATE;
    private static final Class EMPTY_VALUE;
    private ClassLoader classLoader = null;
    private final String proxyPackage;
    private static final ExtractDelegatePermission EXTRACT_DELEGATE_PERMISSION;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;

    private ProxyFactory(String proxyPackage) {
        this.proxyPackage = proxyPackage;
    }

    public static ProxyFactory createProxyFactory(String proxyPackage, Class ... classes) {
        ProxyFactory proxyFactory = new ProxyFactory(proxyPackage);
        proxyFactory.annotationsRegistry.register(classes);
        return proxyFactory;
    }

    public static ProxyFactory createProxyFactory(Class ... classes) {
        ProxyFactory proxyFactory = new ProxyFactory(DEFAULT_PROXY_PACKAGE);
        proxyFactory.annotationsRegistry.register(classes);
        return proxyFactory;
    }

    public static ProxyFactory createJDBCProxyFactory(String proxyPackage, Class ... classes) {
        ProxyFactory proxyFactory = new ProxyFactory(proxyPackage);
        proxyFactory.annotationsRegistry.register(NullProxy.class);
        proxyFactory.annotationsRegistry.register(classes);
        return proxyFactory;
    }

    public static ProxyFactory createJDBCProxyFactory(Class ... classes) {
        ProxyFactory proxyFactory = new ProxyFactory(DEFAULT_PROXY_PACKAGE);
        proxyFactory.annotationsRegistry.register(NullProxy.class);
        proxyFactory.annotationsRegistry.register(classes);
        return proxyFactory;
    }

    public final boolean isProxied(Class iface) {
        return this.annotationsRegistry.containsKey(iface);
    }

    public final <T> T proxyFor(T delegate) {
        return this.proxyFor(delegate, this);
    }

    public final <T> T proxyFor(T delegate, Object creator) {
        return this.proxyForCache(delegate, creator, null, null);
    }

    public final <T> T proxyForCreate(T delegate, Object creator, Map<Object, WeakReference<Object>> proxyCache, Method methodObject) {
        Constructor proxyConstructor;
        if (null == delegate) {
            return null;
        }
        Class<?> delegateClass = delegate.getClass();
        Class mostSuitableIface = this.findMostSuitableIface(delegateClass);
        if (null != methodObject && null != mostSuitableIface && !methodObject.getReturnType().isAssignableFrom(mostSuitableIface)) {
            return delegate;
        }
        AnnotationsRegistry.Value value = this.annotationsRegistry.get(mostSuitableIface);
        if (null == value) {
            return delegate;
        }
        if (null == proxyCache) {
            Map<Object, Object> map = proxyCache = value.isProxyLocale() ? new WeakIdentityHashMap() : this.delegateToProxy;
        }
        if (null == (proxyConstructor = this.getProxyConstructor(mostSuitableIface, delegateClass))) {
            return this.createProxy(mostSuitableIface, delegate, creator, proxyCache);
        }
        try {
            return proxyConstructor.newInstance(delegate, creator, this, proxyCache);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public final <T> T proxyForCache(T delegate, Object creator, Map<Object, WeakReference<Object>> proxyCache, Method methodObject) {
        if (null == delegate) {
            return null;
        }
        if (delegate instanceof _Proxy_) {
            return delegate;
        }
        Class<?> delegateClass = delegate.getClass();
        Class mostSuitableIface = this.findMostSuitableIface(delegateClass);
        if (null != methodObject && null != mostSuitableIface && !methodObject.getReturnType().isAssignableFrom(mostSuitableIface)) {
            return delegate;
        }
        AnnotationsRegistry.Value value = this.annotationsRegistry.get(mostSuitableIface);
        if (null == value) {
            return delegate;
        }
        Method getter = value.getProxyAccessGetter();
        Method setter = value.getProxyAccessSetter();
        if (null == proxyCache) {
            proxyCache = value.isProxyLocale() ? new WeakIdentityHashMap() : this.delegateToProxy;
        }
        try {
            Constructor proxyConstructor;
            Object proxy;
            if (null != getter) {
                Object proxy2 = getter.invoke(delegate, new Object[0]);
                if (null != proxy2) {
                    return (T)proxy2;
                }
            } else {
                WeakReference<Object> proxyRef = proxyCache.get(delegate);
                if (null != proxyRef && null != (proxy = proxyRef.get())) {
                    if (STALE_DELEGATE == proxy) {
                        throw new RuntimeException("stale delegate");
                    }
                    return proxy;
                }
            }
            if (null == (proxyConstructor = this.getProxyConstructor(mostSuitableIface, delegateClass))) {
                proxy = this.createProxy(mostSuitableIface, delegate, creator, proxyCache);
                if (null != setter) {
                    setter.invoke(delegate, proxy);
                } else {
                    proxyCache.put(delegate, new WeakReference(proxy));
                }
                return proxy;
            }
            proxy = proxyConstructor.newInstance(delegate, creator, this, proxyCache);
            if (null != setter) {
                setter.invoke(delegate, proxy);
            } else {
                proxyCache.put(delegate, new WeakReference(proxy));
            }
            return proxy;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public final <T> T proxyForCreateCache(T delegate, Object creator, Map<Object, WeakReference<Object>> proxyCache, Method methodObject) {
        if (null == delegate) {
            return null;
        }
        if (delegate instanceof _Proxy_) {
            return delegate;
        }
        Class<?> delegateClass = delegate.getClass();
        Class mostSuitableIface = this.findMostSuitableIface(delegateClass);
        if (null != methodObject && null != mostSuitableIface && !methodObject.getReturnType().isAssignableFrom(mostSuitableIface)) {
            return delegate;
        }
        AnnotationsRegistry.Value value = this.annotationsRegistry.get(mostSuitableIface);
        if (null == value) {
            return delegate;
        }
        if (null == proxyCache) {
            proxyCache = value.isProxyLocale() ? new WeakIdentityHashMap() : this.delegateToProxy;
        }
        Method setter = value.getProxyAccessSetter();
        Constructor proxyConstructor = this.getProxyConstructor(mostSuitableIface, delegateClass);
        try {
            if (null == proxyConstructor) {
                T proxy = this.createProxy(mostSuitableIface, delegate, creator, proxyCache);
                if (null != setter) {
                    setter.invoke(delegate, proxy);
                } else {
                    proxyCache.put(delegate, new WeakReference<T>(proxy));
                }
                return proxy;
            }
            Object proxy = proxyConstructor.newInstance(delegate, creator, this, proxyCache);
            if (null != setter) {
                setter.invoke(delegate, proxy);
            } else {
                proxyCache.put(delegate, new WeakReference(proxy));
            }
            return proxy;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> void updateDelegate(Object proxy, T oldDelegate, T newDelegate) {
        this.delegateToProxy.put(oldDelegate, new WeakReference<Object>(STALE_DELEGATE));
        this.delegateToProxy.put(newDelegate, new WeakReference<Object>(proxy));
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public static final Object extractDelegate(_Proxy_ proxy) {
        SecurityManager security = System.getSecurityManager();
        if (null != security) {
            security.checkPermission(EXTRACT_DELEGATE_PERMISSION);
        }
        return proxy._getDelegate_();
    }

    private <T> T createProxy(Class mostSuitableIface, T delegate, Object creator, Map<Object, WeakReference<Object>> proxyCache) {
        if (null == mostSuitableIface) {
            return delegate;
        }
        AnnotationsRegistry.Value value = this.annotationsRegistry.get(mostSuitableIface);
        Class superclass = value.getSuperclass();
        GeneratedProxiesRegistry.Value v = this.generatedRegistry.get(this.proxyPackage, mostSuitableIface, superclass);
        Constructor c = null == v ? this.prepareProxy(mostSuitableIface, superclass) : v.getConstructor();
        try {
            return c.newInstance(delegate, creator, this, proxyCache);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private Constructor prepareProxy(Class iface, Class superclass) {
        Constructor<?> constructor;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(new GeneratedProxiesRegistry.Key(this.proxyPackage, iface, superclass).toString(), true, null == this.classLoader ? superclass.getClassLoader() : this.classLoader);
        }
        catch (ClassNotFoundException e) {
            clazz = ClassGenerator.generate(this.proxyPackage, iface, superclass, this.annotationsRegistry, this.classLoader);
        }
        try {
            constructor = clazz.getConstructor(iface, Object.class, ProxyFactory.class, Map.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        this.generatedRegistry.put(this.proxyPackage, iface, superclass, new GeneratedProxiesRegistry.Value(null, null, clazz, constructor));
        return constructor;
    }

    private Constructor getProxyConstructor(Class mostSuitableIface, Class delegateClass) {
        if (null == delegateClass) {
            return null;
        }
        Constructor proxyConstructor = this.delegateClassToProxyConstructor.get(delegateClass);
        if (null != proxyConstructor) {
            return proxyConstructor;
        }
        if (null == mostSuitableIface) {
            return null;
        }
        GeneratedProxiesRegistry.Value value = this.generatedRegistry.get(this.proxyPackage, mostSuitableIface, this.annotationsRegistry.get(mostSuitableIface).getSuperclass());
        if (null == value) {
            return null;
        }
        Constructor proxyConstructor2 = value.getConstructor();
        if (null != proxyConstructor2) {
            this.delegateClassToProxyConstructor.put(delegateClass, proxyConstructor2);
        }
        return proxyConstructor2;
    }

    private Class findMostSuitableIface(Class delegateClass) {
        if (null == delegateClass) {
            return null;
        }
        Class c = this.delegateToMostSuitableIface.get(delegateClass);
        if (null != c) {
            return EMPTY_VALUE != c ? c : null;
        }
        int max = -1;
        Class iface = null;
        for (Class i : this.annotationsRegistry.keySet()) {
            int c2 = this.intersectionCardinality(delegateClass, i);
            if (c2 < 1 || c2 <= max) continue;
            max = c2;
            iface = i;
        }
        this.delegateToMostSuitableIface.put(delegateClass, null != iface ? iface : EMPTY_VALUE);
        return iface;
    }

    private int intersectionCardinality(Class delegateClass, Class iface) {
        HashSet<Class> iSet = new HashSet<Class>();
        this.collectIfaces(iface, iSet);
        HashSet<Class> dSet = new HashSet<Class>();
        this.collectIfaces(delegateClass, dSet);
        int iCard = iSet.size();
        iSet.removeAll(dSet);
        if (iSet.size() > 0) {
            return -1;
        }
        return iCard;
    }

    private void collectIfaces(Class c, Set<Class> set) {
        if (c.isInterface()) {
            set.add(c);
        }
        for (Class<?> iface : c.getInterfaces()) {
            this.collectIfaces(iface, set);
        }
        Class superclass = c.getSuperclass();
        if (null != superclass) {
            this.collectIfaces(superclass, set);
        }
    }

    static {
        try {
            $$$methodRef$$$20 = ProxyFactory.class.getDeclaredConstructor(String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$19 = ProxyFactory.class.getDeclaredMethod("collectIfaces", Class.class, Set.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$18 = ProxyFactory.class.getDeclaredMethod("intersectionCardinality", Class.class, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$17 = ProxyFactory.class.getDeclaredMethod("findMostSuitableIface", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$16 = ProxyFactory.class.getDeclaredMethod("getProxyConstructor", Class.class, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$15 = ProxyFactory.class.getDeclaredMethod("prepareProxy", Class.class, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$14 = ProxyFactory.class.getDeclaredMethod("createProxy", Class.class, Object.class, Object.class, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$13 = ProxyFactory.class.getDeclaredMethod("extractDelegate", _Proxy_.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$12 = ProxyFactory.class.getDeclaredMethod("getClassLoader", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$11 = ProxyFactory.class.getDeclaredMethod("setClassLoader", ClassLoader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = ProxyFactory.class.getDeclaredMethod("updateDelegate", Object.class, Object.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = ProxyFactory.class.getDeclaredMethod("proxyForCreateCache", Object.class, Object.class, Map.class, Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = ProxyFactory.class.getDeclaredMethod("proxyForCache", Object.class, Object.class, Map.class, Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = ProxyFactory.class.getDeclaredMethod("proxyForCreate", Object.class, Object.class, Map.class, Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = ProxyFactory.class.getDeclaredMethod("proxyFor", Object.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = ProxyFactory.class.getDeclaredMethod("proxyFor", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = ProxyFactory.class.getDeclaredMethod("isProxied", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = ProxyFactory.class.getDeclaredMethod("createJDBCProxyFactory", Class[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = ProxyFactory.class.getDeclaredMethod("createJDBCProxyFactory", String.class, Class[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = ProxyFactory.class.getDeclaredMethod("createProxyFactory", Class[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = ProxyFactory.class.getDeclaredMethod("createProxyFactory", String.class, Class[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        STALE_DELEGATE = new Object();
        EMPTY_VALUE = EMPTY_CLASS.class;
        EXTRACT_DELEGATE_PERMISSION = new ExtractDelegatePermission();
    }

    private static final class EMPTY_CLASS {
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;

        private EMPTY_CLASS() {
        }

        static {
            try {
                $$$methodRef$$$0 = EMPTY_CLASS.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }
}

