/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.annotation;

import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationMarkup;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDBorderEffectDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.handlers.PDAppearanceHandler;
import org.apache.pdfbox.pdmodel.interactive.annotation.handlers.PDPolygonAppearanceHandler;

public class PDAnnotationPolygon
extends PDAnnotationMarkup {
    public static final String SUB_TYPE = "Polygon";
    private PDAppearanceHandler customAppearanceHandler;

    public PDAnnotationPolygon() {
        this.getCOSObject().setName(COSName.SUBTYPE, SUB_TYPE);
    }

    public PDAnnotationPolygon(COSDictionary dict) {
        super(dict);
    }

    public void setInteriorColor(PDColor ic) {
        this.getCOSObject().setItem(COSName.IC, (COSBase)ic.toCOSArray());
    }

    public PDColor getInteriorColor() {
        return this.getColor(COSName.IC);
    }

    public void setBorderEffect(PDBorderEffectDictionary be) {
        this.getCOSObject().setItem(COSName.BE, (COSObjectable)be);
    }

    public PDBorderEffectDictionary getBorderEffect() {
        COSDictionary be = this.getCOSObject().getCOSDictionary(COSName.BE);
        return be != null ? new PDBorderEffectDictionary(be) : null;
    }

    public float[] getVertices() {
        COSArray array = this.getCOSObject().getCOSArray(COSName.VERTICES);
        return array != null ? array.toFloatArray() : null;
    }

    public void setVertices(float[] points) {
        COSArray ar = new COSArray();
        ar.setFloatArray(points);
        this.getCOSObject().setItem(COSName.VERTICES, (COSBase)ar);
    }

    public float[][] getPath() {
        COSArray array = this.getCOSObject().getCOSArray(COSName.PATH);
        if (array != null) {
            float[][] pathArray = new float[array.size()][];
            for (int i = 0; i < array.size(); ++i) {
                COSBase base2 = array.getObject(i);
                pathArray[i] = base2 instanceof COSArray ? ((COSArray)base2).toFloatArray() : new float[0];
            }
            return pathArray;
        }
        return null;
    }

    public void setCustomAppearanceHandler(PDAppearanceHandler appearanceHandler) {
        this.customAppearanceHandler = appearanceHandler;
    }

    @Override
    public void constructAppearances() {
        this.constructAppearances(null);
    }

    @Override
    public void constructAppearances(PDDocument document) {
        if (this.customAppearanceHandler == null) {
            PDPolygonAppearanceHandler appearanceHandler = new PDPolygonAppearanceHandler(this, document);
            appearanceHandler.generateAppearanceStreams();
        } else {
            this.customAppearanceHandler.generateAppearanceStreams();
        }
    }
}

