/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.pickerfx;

import com.dlsc.pickerfx.Picker;
import com.dlsc.pickerfx.Segment;
import com.dlsc.pickerfx.SegmentCell;
import com.dlsc.pickerfx.skins.IntegerPickerSkin;
import java.util.Objects;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.Skin;
import javafx.util.Callback;

public class IntegerPicker
extends Picker<Integer> {
    private final IntegerProperty numberOfDigits = new SimpleIntegerProperty((Object)this, "numberOfDigits", 3);
    private final ObjectProperty<Callback<Segment<Integer, Integer>, SegmentCell<Integer>>> cellFactory = new SimpleObjectProperty((Object)this, "cellFactory", segment -> new SegmentCell());

    public IntegerPicker(int numberOfDigits) {
        this.getStyleClass().add((Object)"integer-picker");
        this.setNumberOfDigits(numberOfDigits);
    }

    public IntegerPicker() {
        this(3);
    }

    protected Skin<?> createDefaultSkin() {
        return new IntegerPickerSkin(this);
    }

    public String getUserAgentStylesheet() {
        return Objects.requireNonNull(((Object)((Object)this)).getClass().getResource("integer-picker.css")).toExternalForm();
    }

    public final int getNumberOfDigits() {
        return this.numberOfDigits.get();
    }

    public final IntegerProperty numberOfDigitsProperty() {
        return this.numberOfDigits;
    }

    public final void setNumberOfDigits(int numberOfDigits) {
        this.numberOfDigits.set(numberOfDigits);
    }

    public final Callback<Segment<Integer, Integer>, SegmentCell<Integer>> getCellFactory() {
        return (Callback)this.cellFactory.get();
    }

    public final ObjectProperty<Callback<Segment<Integer, Integer>, SegmentCell<Integer>>> cellFactoryProperty() {
        return this.cellFactory;
    }

    public final void setCellFactory(Callback<Segment<Integer, Integer>, SegmentCell<Integer>> cellFactory) {
        this.cellFactory.set(cellFactory);
    }
}

