/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.util.lines;

class Armor {
    static final String DICT = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";

    Armor() {
    }

    private static void encodeStep(int[] ibuf, int[] obuf) {
        obuf[0] = ibuf[0] & 0x3F;
        obuf[1] = ((ibuf[0] & 0xFF) >> 6) + ((ibuf[1] & 0xF) << 2);
        obuf[2] = ((ibuf[1] & 0xFF) >> 4) + ((ibuf[2] & 3) << 4);
        obuf[3] = (ibuf[2] & 0xFF) >> 2;
        obuf[4] = ibuf[3] & 0x3F;
        obuf[5] = ((ibuf[3] & 0xFF) >> 6) + ((ibuf[4] & 0xF) << 2);
        obuf[6] = ((ibuf[4] & 0xFF) >> 4) + ((ibuf[5] & 3) << 4);
        obuf[7] = (ibuf[5] & 0xFF) >> 2;
    }

    private static void decodeStep(int[] ibuf, int[] obuf) {
        obuf[0] = (ibuf[0] & 0xFF) + ((ibuf[1] & 3) << 6);
        obuf[1] = ((ibuf[1] & 0xFF) >> 2) + ((ibuf[2] & 0xF) << 4);
        obuf[2] = ((ibuf[2] & 0xFF) >> 4) + ((ibuf[3] & 0x3F) << 2);
        obuf[3] = (ibuf[4] & 0xFF) + ((ibuf[5] & 3) << 6);
        obuf[4] = ((ibuf[5] & 0xFF) >> 2) + ((ibuf[6] & 0xF) << 4);
        obuf[5] = ((ibuf[6] & 0xFF) >> 4) + ((ibuf[7] & 0x3F) << 2);
    }

    public static String encode(String src) {
        StringBuilder sb = new StringBuilder();
        char[] chars = src.toCharArray();
        int[] ibuf = new int[6];
        int[] obuf = new int[8];
        for (int c = 0; c < chars.length / 3; ++c) {
            int i;
            for (i = 0; i < 3; ++i) {
                ibuf[i * 2 + 0] = chars[c * 3 + i] & 0xFF;
                ibuf[i * 2 + 1] = chars[c * 3 + i] >> 8 & 0xFF;
            }
            Armor.encodeStep(ibuf, obuf);
            for (i = 0; i < 8; ++i) {
                sb.append(DICT.charAt(obuf[i]));
            }
        }
        int tail = chars.length % 3;
        if (tail != 0) {
            int i;
            int tailStart = chars.length / 3 * 3;
            char PAD = DICT.charAt(DICT.length() - 1);
            for (i = 0; i < tail; ++i) {
                ibuf[i * 2 + 0] = chars[tailStart + i] & 0xFF;
                ibuf[i * 2 + 1] = chars[tailStart + i] >> 8 & 0xFF;
            }
            for (i = tail; i < 3; ++i) {
                ibuf[i * 2 + 0] = 0;
                ibuf[i * 2 + 1] = 0;
            }
            Armor.encodeStep(ibuf, obuf);
            for (i = 0; i < tail * 3; ++i) {
                sb.append(DICT.charAt(obuf[i]));
            }
            for (i = tail * 3; i < 8; ++i) {
                sb.append(PAD);
            }
        }
        return sb.toString();
    }

    public static String decode(String encoded) {
        char[] encChars = encoded.toCharArray();
        char[] decChars = new char[encChars.length / 8 * 3];
        if (encChars.length % 8 != 0) {
            throw new IllegalArgumentException("The length should be multiple of 8");
        }
        int PAD_IDX = DICT.length() - 1;
        int[] ibuf = new int[8];
        int[] obuf = new int[6];
        int oLen = 0;
        int cut = 0;
        for (int c = 0; c < encChars.length / 8; ++c) {
            int i;
            for (i = 0; i < 8; ++i) {
                ibuf[i] = DICT.indexOf(encChars[c * 8 + i]);
            }
            if (ibuf[3] == PAD_IDX) {
                for (i = 3; i < 8; ++i) {
                    ibuf[i] = 0;
                }
                cut = 2;
            } else if (ibuf[6] == PAD_IDX) {
                for (i = 6; i < 8; ++i) {
                    ibuf[i] = 0;
                }
                cut = 1;
            }
            Armor.decodeStep(ibuf, obuf);
            decChars[oLen++] = (char)(obuf[0] + (obuf[1] << 8));
            decChars[oLen++] = (char)(obuf[2] + (obuf[3] << 8));
            decChars[oLen++] = (char)(obuf[4] + (obuf[5] << 8));
        }
        return new String(decChars, 0, decChars.length - cut);
    }
}

