/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections;

import com.sun.security.auth.module.UnixSystem;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.NetworkChannel;
import java.nio.channels.SocketChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.freedesktop.dbus.connections.config.SaslConfig;
import org.freedesktop.dbus.connections.transports.AbstractTransport;
import org.freedesktop.dbus.connections.transports.AbstractUnixTransport;
import org.freedesktop.dbus.exceptions.AuthenticationException;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.utils.Hexdump;
import org.freedesktop.dbus.utils.LoggingHelper;
import org.freedesktop.dbus.utils.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SASL {
    public static final int AUTH_NONE = 0;
    public static final int AUTH_EXTERNAL = 1;
    public static final int AUTH_SHA = 2;
    public static final int AUTH_ANON = 4;
    public static final int LOCK_TIMEOUT = 1000;
    public static final int NEW_KEY_TIMEOUT_SECONDS = 300;
    public static final int EXPIRE_KEYS_TIMEOUT_SECONDS = 420;
    public static final int MAX_TIME_TRAVEL_SECONDS = 300;
    public static final int COOKIE_TIMEOUT = 240;
    public static final String COOKIE_CONTEXT = "org_freedesktop_java";
    private static final Collator col = Collator.getInstance();
    private String challenge = "";
    private String cookie = "";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final boolean hasFileDescriptorSupport;
    private boolean fileDescriptorSupported;

    public SASL() {
        this(false);
    }

    public SASL(boolean _hasFileDescriptorSupport) {
        this.hasFileDescriptorSupport = _hasFileDescriptorSupport;
    }

    private String findCookie(String _context, String _id) throws IOException {
        String homedir = System.getProperty("user.home");
        File f = new File(homedir + "/.dbus-keyrings/" + _context);
        BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
        String s = null;
        String lCookie = null;
        long now = System.currentTimeMillis() / 1000L;
        while (null != (s = r.readLine())) {
            String[] line = s.split(" ");
            long timestamp = Long.parseLong(line[1]);
            if (!line[0].equals(_id) || timestamp < 0L || now + 300L < timestamp || now - 420L > timestamp) continue;
            lCookie = line[2];
            break;
        }
        r.close();
        return lCookie;
    }

    private void addCookie(String _context, String _id, long _timestamp, String _cookie) throws IOException {
        String homedir = System.getProperty("user.home");
        File keydir = new File(homedir + "/.dbus-keyrings/");
        File cookiefile = new File(homedir + "/.dbus-keyrings/" + _context);
        File lock = new File(homedir + "/.dbus-keyrings/" + _context + ".lock");
        File temp = new File(homedir + "/.dbus-keyrings/" + _context + ".temp");
        if (!keydir.exists()) {
            keydir.mkdirs();
        }
        long start = System.currentTimeMillis();
        while (!lock.createNewFile() && 1000L > System.currentTimeMillis() - start) {
        }
        ArrayList<Object> lines = new ArrayList<Object>();
        if (cookiefile.exists()) {
            BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(cookiefile)));
            String s = null;
            while (null != (s = r.readLine())) {
                String[] stringArray = s.split(" ");
                long time = Long.parseLong(stringArray[1]);
                if (_timestamp - time >= 240L) continue;
                lines.add(s);
            }
            r.close();
        }
        lines.add(_id + " " + _timestamp + " " + _cookie);
        PrintWriter w = new PrintWriter(new FileOutputStream(temp));
        for (String string : lines) {
            w.println(string);
        }
        w.close();
        if (!temp.renameTo(cookiefile)) {
            cookiefile.delete();
            temp.renameTo(cookiefile);
        }
        lock.delete();
    }

    private String stupidlyEncode(String _data) {
        return Hexdump.toHex(_data.getBytes(), false);
    }

    private String stupidlyEncode(byte[] _data) {
        return Hexdump.toHex(_data, false);
    }

    private byte getNibble(char _c) {
        switch (_c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return (byte)(_c - 48);
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return (byte)(_c - 65 + 10);
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return (byte)(_c - 97 + 10);
            }
        }
        return 0;
    }

    private String stupidlyDecode(String _data) {
        char[] cs = new char[_data.length()];
        char[] res = new char[cs.length / 2];
        _data.getChars(0, _data.length(), cs, 0);
        int i = 0;
        for (int j = 0; j < res.length; ++j) {
            int b = 0;
            b |= this.getNibble(cs[i]) << 4;
            res[j] = (char)(b |= this.getNibble(cs[i + 1]));
            i += 2;
        }
        return new String(res);
    }

    public Command receive(SocketChannel _sock) throws IOException {
        StringBuffer sb = new StringBuffer();
        ByteBuffer buf = ByteBuffer.allocate(64);
        boolean runLoop = true;
        while (runLoop) {
            int read = _sock.read(buf);
            buf.position(0);
            if (read == -1) {
                throw new IOException("Stream unexpectedly short (broken pipe)");
            }
            block7: for (int i = buf.position(); i < read; ++i) {
                byte c = buf.get();
                switch (c) {
                    case 0: 
                    case 13: {
                        continue block7;
                    }
                    case 10: {
                        runLoop = false;
                        continue block7;
                    }
                    default: {
                        sb.append((char)c);
                    }
                }
            }
            buf.clear();
        }
        this.logger.trace("received: {}", (Object)sb);
        try {
            return new Command(sb.toString());
        }
        catch (Exception e) {
            this.logger.error("Cannot create command.", (Throwable)e);
            throw new AuthenticationException("Failed to authenticate.", e);
        }
    }

    public void send(SocketChannel _sock, SaslCommand _command, String ... _data) throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append(_command.name());
        for (String s : _data) {
            sb.append(' ');
            sb.append(s);
        }
        sb.append('\r');
        sb.append('\n');
        this.logger.trace("sending: {}", (Object)sb);
        _sock.write(ByteBuffer.wrap(sb.toString().getBytes()));
    }

    SaslResult doChallenge(int _auth, Command _c) throws IOException {
        switch (_auth) {
            case 2: {
                Object[] reply = this.stupidlyDecode(_c.getData()).split(" ");
                this.logger.trace(Arrays.toString(reply));
                if (3 != reply.length) {
                    this.logger.debug("Reply is not length 3");
                    return SaslResult.ERROR;
                }
                Object context = reply[0];
                Object id = reply[1];
                Object serverchallenge = reply[2];
                MessageDigest md = null;
                try {
                    md = MessageDigest.getInstance("SHA");
                }
                catch (NoSuchAlgorithmException nsae) {
                    this.logger.debug("", (Throwable)nsae);
                    return SaslResult.ERROR;
                }
                byte[] buf = new byte[8];
                Message.marshallintBig(System.currentTimeMillis(), buf, 0, 8);
                String clientchallenge = this.stupidlyEncode(md.digest(buf));
                md.reset();
                long start = System.currentTimeMillis();
                String lCookie = null;
                while (null == lCookie && System.currentTimeMillis() - start < 1000L) {
                    lCookie = this.findCookie((String)context, (String)id);
                }
                if (null == lCookie) {
                    this.logger.debug("Did not find a cookie in context {}  with ID {}", context, id);
                    return SaslResult.ERROR;
                }
                Object response = (String)serverchallenge + ":" + clientchallenge + ":" + lCookie;
                buf = md.digest(((String)response).getBytes());
                this.logger.trace("Response: {} hash: {}", response, (Object)Hexdump.format(buf));
                response = this.stupidlyEncode(buf);
                _c.setResponse(this.stupidlyEncode(clientchallenge + " " + (String)response));
                return SaslResult.OK;
            }
        }
        this.logger.debug("Not DBUS_COOKIE_SHA1 authtype.");
        return SaslResult.ERROR;
    }

    SaslResult doResponse(int _auth, String _uid, String _kernelUid, Command _c) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException nsae) {
            this.logger.error("", (Throwable)nsae);
            return SaslResult.ERROR;
        }
        switch (_auth) {
            case 0: {
                switch (_c.getMechs()) {
                    case 4: {
                        return SaslResult.OK;
                    }
                    case 1: {
                        if (0 == col.compare(_uid, _c.getData()) && (null == _kernelUid || 0 == col.compare(_uid, _kernelUid))) {
                            return SaslResult.OK;
                        }
                        return SaslResult.REJECT;
                    }
                    case 2: {
                        String context = COOKIE_CONTEXT;
                        long id = System.currentTimeMillis();
                        byte[] buf = new byte[8];
                        Message.marshallintBig(id, buf, 0, 8);
                        this.challenge = this.stupidlyEncode(md.digest(buf));
                        Random r = new Random();
                        r.nextBytes(buf);
                        this.cookie = this.stupidlyEncode(md.digest(buf));
                        try {
                            this.addCookie(context, "" + id, id / 1000L, this.cookie);
                        }
                        catch (IOException ioe) {
                            this.logger.debug("", (Throwable)ioe);
                        }
                        this.logger.debug("Sending challenge: {} {} {}", new Object[]{context, id, this.challenge});
                        _c.setResponse(this.stupidlyEncode(context + " " + id + " " + this.challenge));
                        return SaslResult.OK;
                    }
                }
                return SaslResult.ERROR;
            }
            case 2: {
                String[] response = this.stupidlyDecode(_c.getData()).split(" ");
                if (response.length < 2) {
                    return SaslResult.ERROR;
                }
                String cchal = response[0];
                String hash = response[1];
                String prehash = this.challenge + ":" + cchal + ":" + this.cookie;
                byte[] buf = md.digest(prehash.getBytes());
                String posthash = this.stupidlyEncode(buf);
                this.logger.debug("Authenticating Hash; data={} remote-hash={} local-hash={}", new Object[]{prehash, hash, posthash});
                if (0 == col.compare(posthash, hash)) {
                    return SaslResult.OK;
                }
                return SaslResult.ERROR;
            }
        }
        return SaslResult.ERROR;
    }

    public String[] convertAuthTypes(int _types) {
        switch (_types) {
            case 1: {
                return new String[]{"EXTERNAL"};
            }
            case 2: {
                return new String[]{"DBUS_COOKIE_SHA1"};
            }
            case 4: {
                return new String[]{"ANONYMOUS"};
            }
            case 3: {
                return new String[]{"EXTERNAL", "DBUS_COOKIE_SHA1"};
            }
            case 6: {
                return new String[]{"ANONYMOUS", "DBUS_COOKIE_SHA1"};
            }
            case 5: {
                return new String[]{"ANONYMOUS", "EXTERNAL"};
            }
            case 7: {
                return new String[]{"ANONYMOUS", "EXTERNAL", "DBUS_COOKIE_SHA1"};
            }
        }
        return new String[0];
    }

    public boolean auth(SaslConfig _config, SocketChannel _sock, AbstractTransport _transport) throws IOException {
        String luid = null;
        String kernelUid = null;
        long uid = _config.getSaslUid().orElse(this.getUserId());
        luid = this.stupidlyEncode("" + uid);
        int failed = 0;
        int current = 0;
        SaslAuthState state = SaslAuthState.INITIAL_STATE;
        block60: while (state != SaslAuthState.FINISHED && state != SaslAuthState.FAILED) {
            this.logger.trace("Mode: {} AUTH state: {}", (Object)_config.getMode(), (Object)state);
            switch (_config.getMode()) {
                case CLIENT: {
                    Command c;
                    switch (state) {
                        case INITIAL_STATE: {
                            _sock.write(ByteBuffer.wrap(new byte[]{0}));
                            this.send(_sock, SaslCommand.AUTH, new String[0]);
                            state = SaslAuthState.WAIT_DATA;
                            continue block60;
                        }
                        case WAIT_DATA: {
                            c = this.receive(_sock);
                            switch (c.getCommand()) {
                                case DATA: {
                                    switch (this.doChallenge(current, c)) {
                                        case CONTINUE: {
                                            this.send(_sock, SaslCommand.DATA, c.getResponse());
                                            continue block60;
                                        }
                                        case OK: {
                                            this.send(_sock, SaslCommand.DATA, c.getResponse());
                                            state = SaslAuthState.WAIT_OK;
                                            continue block60;
                                        }
                                    }
                                    this.send(_sock, SaslCommand.ERROR, c.getResponse());
                                    continue block60;
                                }
                                case REJECTED: {
                                    int available = c.getMechs() & ~(failed |= current);
                                    int retVal = this.handleReject(available, luid, _sock);
                                    if (retVal == -1) {
                                        state = SaslAuthState.FAILED;
                                        continue block60;
                                    }
                                    current = retVal;
                                    continue block60;
                                }
                                case ERROR: {
                                    if (state == SaslAuthState.NEGOTIATE_UNIX_FD) {
                                        state = SaslAuthState.FINISHED;
                                        this.logger.trace("File descriptors NOT supported by server");
                                        this.fileDescriptorSupported = false;
                                        this.send(_sock, SaslCommand.BEGIN, new String[0]);
                                        continue block60;
                                    }
                                    this.send(_sock, SaslCommand.CANCEL, new String[0]);
                                    state = SaslAuthState.WAIT_REJECT;
                                    continue block60;
                                }
                                case OK: {
                                    this.logger.trace("Authenticated");
                                    state = SaslAuthState.AUTHENTICATED;
                                    if (this.hasFileDescriptorSupport) {
                                        state = SaslAuthState.WAIT_DATA;
                                        this.logger.trace("Asking for file descriptor support");
                                        this.send(_sock, SaslCommand.NEGOTIATE_UNIX_FD, new String[0]);
                                        continue block60;
                                    }
                                    state = SaslAuthState.FINISHED;
                                    this.send(_sock, SaslCommand.BEGIN, new String[0]);
                                    continue block60;
                                }
                                case AGREE_UNIX_FD: {
                                    if (!this.hasFileDescriptorSupport) continue block60;
                                    state = SaslAuthState.FINISHED;
                                    this.logger.trace("File descriptors supported by server");
                                    this.fileDescriptorSupported = true;
                                    this.send(_sock, SaslCommand.BEGIN, new String[0]);
                                    continue block60;
                                }
                            }
                            this.send(_sock, SaslCommand.ERROR, "Got invalid command");
                            continue block60;
                        }
                        case WAIT_OK: {
                            c = this.receive(_sock);
                            switch (c.getCommand()) {
                                case OK: {
                                    this.send(_sock, SaslCommand.BEGIN, new String[0]);
                                    state = SaslAuthState.AUTHENTICATED;
                                    continue block60;
                                }
                                case DATA: 
                                case ERROR: {
                                    this.send(_sock, SaslCommand.CANCEL, new String[0]);
                                    state = SaslAuthState.WAIT_REJECT;
                                    continue block60;
                                }
                                case REJECTED: {
                                    int available = c.getMechs() & ~(failed |= current);
                                    state = SaslAuthState.WAIT_DATA;
                                    if (0 != (available & 1)) {
                                        this.send(_sock, SaslCommand.AUTH, "EXTERNAL", luid);
                                        current = 1;
                                        continue block60;
                                    }
                                    if (0 != (available & 2)) {
                                        this.send(_sock, SaslCommand.AUTH, "DBUS_COOKIE_SHA1", luid);
                                        current = 2;
                                        continue block60;
                                    }
                                    if (0 != (available & 4)) {
                                        this.send(_sock, SaslCommand.AUTH, "ANONYMOUS");
                                        current = 4;
                                        continue block60;
                                    }
                                    state = SaslAuthState.FAILED;
                                    continue block60;
                                }
                            }
                            this.send(_sock, SaslCommand.ERROR, "Got invalid command");
                            continue block60;
                        }
                        case WAIT_REJECT: {
                            c = this.receive(_sock);
                            switch (c.getCommand()) {
                                case REJECTED: {
                                    int available = c.getMechs() & ~(failed |= current);
                                    int retVal = this.handleReject(available, luid, _sock);
                                    if (retVal == -1) {
                                        state = SaslAuthState.FAILED;
                                        continue block60;
                                    }
                                    current = retVal;
                                    continue block60;
                                }
                            }
                            state = SaslAuthState.FAILED;
                            continue block60;
                        }
                    }
                    state = SaslAuthState.FAILED;
                    continue block60;
                }
                case SERVER: {
                    Command c;
                    switch (state) {
                        case INITIAL_STATE: {
                            ByteBuffer buf = ByteBuffer.allocate(1);
                            if (_sock instanceof NetworkChannel) {
                                _sock.read(buf);
                                state = SaslAuthState.WAIT_AUTH;
                                continue block60;
                            }
                            try {
                                int kuid = -1;
                                if (_transport instanceof AbstractUnixTransport) {
                                    kuid = ((AbstractUnixTransport)_transport).getUid(_sock);
                                }
                                if (kuid >= 0) {
                                    kernelUid = this.stupidlyEncode("" + kuid);
                                }
                                state = SaslAuthState.WAIT_AUTH;
                            }
                            catch (SocketException _ex) {
                                state = SaslAuthState.FAILED;
                            }
                            continue block60;
                        }
                        case WAIT_AUTH: {
                            c = this.receive(_sock);
                            switch (c.getCommand()) {
                                case AUTH: {
                                    switch (this.doResponse(current, luid, kernelUid, c)) {
                                        case CONTINUE: {
                                            this.send(_sock, SaslCommand.DATA, c.getResponse());
                                            current = c.getMechs();
                                            state = SaslAuthState.WAIT_DATA;
                                            continue block60;
                                        }
                                        case OK: {
                                            this.send(_sock, SaslCommand.OK, _config.getGuid());
                                            state = SaslAuthState.WAIT_BEGIN;
                                            current = 0;
                                            continue block60;
                                        }
                                    }
                                    this.send(_sock, SaslCommand.REJECTED, this.convertAuthTypes(_config.getAuthMode()));
                                    current = 0;
                                    continue block60;
                                }
                                case ERROR: {
                                    this.send(_sock, SaslCommand.REJECTED, this.convertAuthTypes(_config.getAuthMode()));
                                    continue block60;
                                }
                                case BEGIN: {
                                    state = SaslAuthState.FAILED;
                                    continue block60;
                                }
                            }
                            this.send(_sock, SaslCommand.ERROR, "Got invalid command");
                            continue block60;
                        }
                        case WAIT_DATA: {
                            c = this.receive(_sock);
                            switch (c.getCommand()) {
                                case DATA: {
                                    switch (this.doResponse(current, luid, kernelUid, c)) {
                                        case CONTINUE: {
                                            this.send(_sock, SaslCommand.DATA, c.getResponse());
                                            state = SaslAuthState.WAIT_DATA;
                                            continue block60;
                                        }
                                        case OK: {
                                            this.send(_sock, SaslCommand.OK, _config.getGuid());
                                            state = SaslAuthState.WAIT_BEGIN;
                                            current = 0;
                                            continue block60;
                                        }
                                    }
                                    this.send(_sock, SaslCommand.REJECTED, this.convertAuthTypes(_config.getAuthMode()));
                                    current = 0;
                                    continue block60;
                                }
                                case ERROR: 
                                case CANCEL: {
                                    this.send(_sock, SaslCommand.REJECTED, this.convertAuthTypes(_config.getAuthMode()));
                                    state = SaslAuthState.WAIT_AUTH;
                                    continue block60;
                                }
                                case BEGIN: {
                                    state = SaslAuthState.FAILED;
                                    continue block60;
                                }
                            }
                            this.send(_sock, SaslCommand.ERROR, "Got invalid command");
                            continue block60;
                        }
                        case WAIT_BEGIN: {
                            c = this.receive(_sock);
                            switch (c.getCommand()) {
                                case ERROR: 
                                case CANCEL: {
                                    this.send(_sock, SaslCommand.REJECTED, this.convertAuthTypes(_config.getAuthMode()));
                                    state = SaslAuthState.WAIT_AUTH;
                                    continue block60;
                                }
                                case BEGIN: {
                                    state = SaslAuthState.FINISHED;
                                    continue block60;
                                }
                                case NEGOTIATE_UNIX_FD: {
                                    this.logger.debug("File descriptor negotiation requested");
                                    if (!this.hasFileDescriptorSupport) {
                                        this.send(_sock, SaslCommand.ERROR, new String[0]);
                                        continue block60;
                                    }
                                    this.send(_sock, SaslCommand.AGREE_UNIX_FD, new String[0]);
                                    continue block60;
                                }
                            }
                            this.send(_sock, SaslCommand.ERROR, "Got invalid command");
                            continue block60;
                        }
                    }
                    state = SaslAuthState.FAILED;
                    continue block60;
                }
            }
            return false;
        }
        return state == SaslAuthState.FINISHED;
    }

    private int handleReject(int _available, String _luid, SocketChannel _sock) throws IOException {
        int current = -1;
        if (0 != (_available & 1)) {
            this.send(_sock, SaslCommand.AUTH, "EXTERNAL", _luid);
            current = 1;
        } else if (0 != (_available & 2)) {
            this.send(_sock, SaslCommand.AUTH, "DBUS_COOKIE_SHA1", _luid);
            current = 2;
        } else if (0 != (_available & 4)) {
            this.send(_sock, SaslCommand.AUTH, "ANONYMOUS");
            current = 4;
        }
        return current;
    }

    private long getUserId() {
        if (!Util.isWindows()) {
            return new UnixSystem().getUid();
        }
        return 0L;
    }

    public boolean isFileDescriptorSupported() {
        return this.fileDescriptorSupported;
    }

    static {
        col.setDecomposition(2);
        col.setStrength(0);
    }

    public static class Command {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private SaslCommand command;
        private int mechs;
        private String data;
        private String response;

        public Command() {
        }

        public Command(String _s) throws IOException {
            String[] ss = _s.split(" ");
            LoggingHelper.logIf(this.logger.isTraceEnabled(), () -> this.logger.trace("Creating command from: {}", (Object)Arrays.toString(ss)));
            if (0 == col.compare(ss[0], "OK")) {
                this.command = SaslCommand.OK;
                this.data = ss[1];
            } else if (0 == col.compare(ss[0], "AUTH")) {
                this.command = SaslCommand.AUTH;
                if (ss.length > 1) {
                    if (0 == col.compare(ss[1], "EXTERNAL")) {
                        this.mechs = 1;
                    } else if (0 == col.compare(ss[1], "DBUS_COOKIE_SHA1")) {
                        this.mechs = 2;
                    } else if (0 == col.compare(ss[1], "ANONYMOUS")) {
                        this.mechs = 4;
                    }
                }
                if (ss.length > 2) {
                    this.data = ss[2];
                }
            } else if (0 == col.compare(ss[0], "DATA")) {
                this.command = SaslCommand.DATA;
                this.data = ss[1];
            } else if (0 == col.compare(ss[0], "REJECTED")) {
                this.command = SaslCommand.REJECTED;
                for (int i = 1; i < ss.length; ++i) {
                    if (0 == col.compare(ss[i], "EXTERNAL")) {
                        this.mechs |= 1;
                        continue;
                    }
                    if (0 == col.compare(ss[i], "DBUS_COOKIE_SHA1")) {
                        this.mechs |= 2;
                        continue;
                    }
                    if (0 != col.compare(ss[i], "ANONYMOUS")) continue;
                    this.mechs |= 4;
                }
            } else if (0 == col.compare(ss[0], "BEGIN")) {
                this.command = SaslCommand.BEGIN;
            } else if (0 == col.compare(ss[0], "CANCEL")) {
                this.command = SaslCommand.CANCEL;
            } else if (0 == col.compare(ss[0], "ERROR")) {
                this.command = SaslCommand.ERROR;
                this.data = ss[1];
            } else if (0 == col.compare(ss[0], "NEGOTIATE_UNIX_FD")) {
                this.command = SaslCommand.NEGOTIATE_UNIX_FD;
            } else if (0 == col.compare(ss[0], "AGREE_UNIX_FD")) {
                this.command = SaslCommand.AGREE_UNIX_FD;
            } else {
                throw new IOException("Invalid Command " + ss[0]);
            }
            this.logger.trace("Created command: {}", (Object)this);
        }

        public SaslCommand getCommand() {
            return this.command;
        }

        public int getMechs() {
            return this.mechs;
        }

        public String getData() {
            return this.data;
        }

        public String getResponse() {
            return this.response;
        }

        public void setResponse(String _s) {
            this.response = _s;
        }

        public String toString() {
            return "Command(" + this.command + ", " + this.mechs + ", " + this.data + ")";
        }
    }

    public static enum SaslCommand {
        AUTH,
        DATA,
        REJECTED,
        OK,
        BEGIN,
        CANCEL,
        ERROR,
        NEGOTIATE_UNIX_FD,
        AGREE_UNIX_FD;

    }

    public static enum SaslResult {
        OK,
        CONTINUE,
        ERROR,
        REJECT;

    }

    static enum SaslAuthState {
        INITIAL_STATE,
        WAIT_DATA,
        WAIT_OK,
        WAIT_REJECT,
        WAIT_AUTH,
        WAIT_BEGIN,
        AUTHENTICATED,
        NEGOTIATE_UNIX_FD,
        FINISHED,
        FAILED;

    }

    public static enum SaslMode {
        SERVER,
        CLIENT;

    }
}

