/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.utils;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.exceptions.AddressResolvingException;
import org.freedesktop.dbus.utils.Util;

public class AddressBuilder {
    public static final String DBUS_SYSTEM_BUS_ADDRESS = "DBUS_SYSTEM_BUS_ADDRESS";
    public static final String DEFAULT_SYSTEM_BUS_ADDRESS = "unix:path=/var/run/dbus/system_bus_socket";
    public static final String DBUS_SESSION_BUS_ADDRESS = "DBUS_SESSION_BUS_ADDRESS";
    private static final String DBUS_MACHINE_ID_SYS_VAR = "DBUS_MACHINE_ID_LOCATION";
    private static final String DBUS_SESSION_BUS_ADDRESS_MACOS = "DBUS_LAUNCHD_SESSION_BUS_SOCKET";

    public static BusAddress getSystemConnection() {
        String bus = System.getenv(DBUS_SYSTEM_BUS_ADDRESS);
        if (bus == null) {
            bus = DEFAULT_SYSTEM_BUS_ADDRESS;
        }
        return BusAddress.of(bus);
    }

    public static BusAddress getSessionConnection(String _dbusMachineIdFile) {
        Object s = System.getProperty(DBUS_SESSION_BUS_ADDRESS);
        if (s == null) {
            s = Util.isMacOs() ? "unix:path=" + System.getenv(DBUS_SESSION_BUS_ADDRESS_MACOS) : System.getenv(DBUS_SESSION_BUS_ADDRESS);
        }
        if (s == null) {
            String display = System.getenv("DISPLAY");
            if (display == null) {
                throw new AddressResolvingException("Cannot Resolve Session Bus Address: DISPLAY variable not set");
            }
            if (display.charAt(0) != ':' && display.contains(":")) {
                display = display.substring(display.indexOf(58));
            }
            String uuid = AddressBuilder.getDbusMachineId(_dbusMachineIdFile);
            String homedir = System.getProperty("user.home");
            File addressfile = new File(homedir + "/.dbus/session-bus", uuid + "-" + display.replaceAll(":([0-9]*)\\..*", "$1"));
            if (!addressfile.exists()) {
                throw new AddressResolvingException("Cannot Resolve Session Bus Address: " + addressfile + " not found");
            }
            Properties readProperties = Util.readProperties(addressfile);
            if (readProperties == null) {
                throw new AddressResolvingException("Cannot Resolve Session Bus Address: Unable to read " + addressfile);
            }
            String sessionAddress = readProperties.getProperty(DBUS_SESSION_BUS_ADDRESS);
            if (Util.isEmpty(sessionAddress)) {
                throw new AddressResolvingException("Cannot Resolve Session Bus Address: No session information found in " + addressfile);
            }
            if (sessionAddress.matches("^'[^']+'$")) {
                sessionAddress = sessionAddress.replaceFirst("^'([^']+)'$", "$1");
            }
            return BusAddress.of(sessionAddress);
        }
        return BusAddress.of((String)s);
    }

    public static String getDbusMachineId(String _dbusMachineIdFile) {
        File uuidfile = AddressBuilder.determineMachineIdFile(_dbusMachineIdFile);
        if (uuidfile != null) {
            String uuid = Util.readFileToString(uuidfile);
            if (uuid.length() > 0) {
                return uuid;
            }
            throw new AddressResolvingException("Cannot Resolve Session Bus Address: MachineId file is empty.");
        }
        if (Util.isWindows() || Util.isMacOs()) {
            return AddressBuilder.getFakeDbusMachineId();
        }
        throw new AddressResolvingException("Cannot Resolve Session Bus Address: MachineId file can not be found");
    }

    private static File determineMachineIdFile(String _dbusMachineIdFile) {
        List<String> locationPriorityList = Arrays.asList(System.getenv(DBUS_MACHINE_ID_SYS_VAR), _dbusMachineIdFile, "/var/lib/dbus/machine-id", "/usr/local/var/lib/dbus/machine-id", "/etc/machine-id");
        return locationPriorityList.stream().filter(s -> s != null).map(s -> new File((String)s)).filter(f -> f.exists() && f.length() > 0L).findFirst().orElse(null);
    }

    private static String getFakeDbusMachineId() {
        return String.format("%s@%s", Util.getCurrentUser(), Util.getHostName());
    }
}

