/*
 * Decompiled with CFR 0.152.
 */
package joptsimple.util;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.gradle.internal.classpath.declarations.NioFileInterceptors;

public enum PathProperties {
    FILE_EXISTING("file.existing"){

        @Override
        boolean accept(Path path) {
            return NioFileInterceptors.intercept_isRegularFile((Path)path, (LinkOption[])new LinkOption[0], (String)"joptsimple.util.PathProperties$1");
        }
    }
    ,
    DIRECTORY_EXISTING("directory.existing"){

        @Override
        boolean accept(Path path) {
            return NioFileInterceptors.intercept_isDirectory((Path)path, (LinkOption[])new LinkOption[0], (String)"joptsimple.util.PathProperties$2");
        }
    }
    ,
    NOT_EXISTING("file.not.existing"){

        @Override
        boolean accept(Path path) {
            return NioFileInterceptors.intercept_notExists((Path)path, (LinkOption[])new LinkOption[0], (String)"joptsimple.util.PathProperties$3");
        }
    }
    ,
    FILE_OVERWRITABLE("file.overwritable"){

        @Override
        boolean accept(Path path) {
            return FILE_EXISTING.accept(path) && WRITABLE.accept(path);
        }
    }
    ,
    READABLE("file.readable"){

        @Override
        boolean accept(Path path) {
            return Files.isReadable(path);
        }
    }
    ,
    WRITABLE("file.writable"){

        @Override
        boolean accept(Path path) {
            return Files.isWritable(path);
        }
    };

    private final String messageKey;

    private PathProperties(String messageKey) {
        this.messageKey = messageKey;
    }

    abstract boolean accept(Path var1);

    String getMessageKey() {
        return this.messageKey;
    }
}

