//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "dispatch2")]
use dispatch2::*;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;
#[cfg(feature = "objc2-security")]
use objc2_security::*;

use crate::*;

/// This is the handle to an open preferences session for
/// accessing system configuration preferences.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/scpreferences?language=objc)
#[doc(alias = "SCPreferencesRef")]
#[repr(C)]
pub struct SCPreferences {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl SCPreferences {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__SCPreferences"> for SCPreferences {}
);

/// Used with the SCPreferencesCallBack callback
/// to describe the type of notification.
///
/// preferences have been saved.
///
/// request has been made to apply the currently saved
/// preferences to the active system configuration.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/scpreferencesnotification?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct SCPreferencesNotification(pub u32);
bitflags::bitflags! {
    impl SCPreferencesNotification: u32 {
        #[doc(alias = "kSCPreferencesNotificationCommit")]
        const Commit = 1<<0;
        #[doc(alias = "kSCPreferencesNotificationApply")]
        const Apply = 1<<1;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for SCPreferencesNotification {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for SCPreferencesNotification {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Structure containing user-specified data and callbacks for SCPreferences.
/// Field: version The version number of the structure type being passed
/// in as a parameter to the SCPreferencesSetCallback function.
/// This structure is version 0.
/// Field: info A C pointer to a user-specified block of data.
/// Field: retain The callback used to add a retain for the info field.
/// If this parameter is not a pointer to a function of the correct
/// prototype, the behavior is undefined.
/// The value may be NULL.
/// Field: release The calllback used to remove a retain previously added
/// for the info field.
/// If this parameter is not a pointer to a function of the
/// correct prototype, the behavior is undefined.
/// The value may be NULL.
/// Field: copyDescription The callback used to provide a description of
/// the info field.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/scpreferencescontext?language=objc)
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct SCPreferencesContext {
    pub version: CFIndex,
    pub info: *mut c_void,
    pub retain: Option<unsafe extern "C-unwind" fn(NonNull<c_void>) -> NonNull<c_void>>,
    pub release: Option<unsafe extern "C-unwind" fn(NonNull<c_void>)>,
    pub copyDescription: Option<unsafe extern "C-unwind" fn(NonNull<c_void>) -> NonNull<CFString>>,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for SCPreferencesContext {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <CFIndex>::ENCODING,
            <*mut c_void>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(NonNull<c_void>) -> NonNull<c_void>>>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(NonNull<c_void>)>>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(NonNull<c_void>) -> NonNull<CFString>>>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for SCPreferencesContext {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Type of the callback function used when the
/// preferences have been updated and/or applied.
///
/// Parameter `prefs`: The preferences session.
///
/// Parameter `notificationType`: The type of notification, such as changes
/// committed, changes applied, etc.
///
/// Parameter `info`: A C pointer to a user-specified block of data.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/scpreferencescallback?language=objc)
pub type SCPreferencesCallBack = Option<
    unsafe extern "C-unwind" fn(NonNull<SCPreferences>, SCPreferencesNotification, *mut c_void),
>;

unsafe impl ConcreteType for SCPreferences {
    /// Returns the type identifier of all SCPreferences instances.
    #[doc(alias = "SCPreferencesGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn SCPreferencesGetTypeID() -> CFTypeID;
        }
        unsafe { SCPreferencesGetTypeID() }
    }
}

impl SCPreferences {
    /// Initiates access to the per-system set of configuration
    /// preferences.
    ///
    /// Parameter `allocator`: The CFAllocator that should be used to allocate
    /// memory for this preferences session.
    /// This parameter may be NULL in which case the current
    /// default CFAllocator is used.
    /// If this reference is not a valid CFAllocator, the behavior
    /// is undefined.
    ///
    /// Parameter `name`: A string that describes the name of the calling
    /// process.
    ///
    /// Parameter `prefsID`: A string that identifies the name of the
    /// group of preferences to be accessed or updated.
    ///
    /// Returns: Returns a reference to the new SCPreferences.
    /// You must release the returned value.
    #[doc(alias = "SCPreferencesCreate")]
    #[inline]
    pub fn new(
        allocator: Option<&CFAllocator>,
        name: &CFString,
        prefs_id: Option<&CFString>,
    ) -> Option<CFRetained<SCPreferences>> {
        extern "C-unwind" {
            fn SCPreferencesCreate(
                allocator: Option<&CFAllocator>,
                name: &CFString,
                prefs_id: Option<&CFString>,
            ) -> Option<NonNull<SCPreferences>>;
        }
        let ret = unsafe { SCPreferencesCreate(allocator, name, prefs_id) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Initiates access to the per-system set of configuration
    /// preferences.
    ///
    /// Parameter `allocator`: The CFAllocator that should be used to allocate
    /// memory for this preferences session.
    /// This parameter may be NULL in which case the current
    /// default CFAllocator is used.
    /// If this reference is not a valid CFAllocator, the behavior
    /// is undefined.
    ///
    /// Parameter `name`: A string that describes the name of the calling
    /// process.
    ///
    /// Parameter `prefsID`: A string that identifies the name of the
    /// group of preferences to be accessed or updated.
    ///
    /// Parameter `authorization`: An authorization reference that is used to
    /// authorize any access to the enhanced privileges needed
    /// to manage the preferences session.
    ///
    /// Returns: Returns a reference to the new SCPreferences.
    /// You must release the returned value.
    ///
    /// # Safety
    ///
    /// `authorization` must be a valid pointer or null.
    #[doc(alias = "SCPreferencesCreateWithAuthorization")]
    #[cfg(feature = "objc2-security")]
    #[inline]
    pub unsafe fn with_authorization(
        allocator: Option<&CFAllocator>,
        name: &CFString,
        prefs_id: Option<&CFString>,
        authorization: AuthorizationRef,
    ) -> Option<CFRetained<SCPreferences>> {
        extern "C-unwind" {
            fn SCPreferencesCreateWithAuthorization(
                allocator: Option<&CFAllocator>,
                name: &CFString,
                prefs_id: Option<&CFString>,
                authorization: AuthorizationRef,
            ) -> Option<NonNull<SCPreferences>>;
        }
        let ret = unsafe {
            SCPreferencesCreateWithAuthorization(allocator, name, prefs_id, authorization)
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Locks access to the configuration preferences.
    ///
    /// This function obtains exclusive access to the configuration
    /// preferences.  Clients attempting to obtain exclusive access
    /// to the preferences will either receive a kSCStatusPrefsBusy
    /// error or block waiting for the lock to be released.
    ///
    /// Parameter `prefs`: The preferences session.
    ///
    /// Parameter `wait`: A boolean flag indicating whether the calling process
    /// should block waiting for another process to complete its update
    /// operation and release its lock.
    ///
    /// Returns: Returns TRUE if the lock was obtained;
    /// FALSE if an error occurred.
    #[doc(alias = "SCPreferencesLock")]
    #[inline]
    pub fn lock(&self, wait: bool) -> bool {
        extern "C-unwind" {
            fn SCPreferencesLock(prefs: &SCPreferences, wait: Boolean) -> Boolean;
        }
        let ret = unsafe { SCPreferencesLock(self, wait as _) };
        ret != 0
    }

    /// Commits changes made to the configuration preferences to
    /// persistent storage.
    ///
    /// This function commits any changes to permanent storage.
    /// Implicit calls to the SCPreferencesLock and SCPreferencesUnlock
    /// functions will be made if exclusive access has not already been
    /// established.
    ///
    /// Note: This routine commits changes to persistent storage.
    /// Call the SCPreferencesApplyChanges function to apply the
    /// changes to the running system.
    ///
    /// Parameter `prefs`: The preferences session.
    ///
    /// Returns: Returns TRUE if the lock was obtained;
    /// FALSE if an error occurred.
    #[doc(alias = "SCPreferencesCommitChanges")]
    #[inline]
    pub fn commit_changes(&self) -> bool {
        extern "C-unwind" {
            fn SCPreferencesCommitChanges(prefs: &SCPreferences) -> Boolean;
        }
        let ret = unsafe { SCPreferencesCommitChanges(self) };
        ret != 0
    }

    /// Requests that the currently stored configuration
    /// preferences be applied to the active configuration.
    ///
    /// Parameter `prefs`: The preferences session.
    ///
    /// Returns: Returns TRUE if the lock was obtained;
    /// FALSE if an error occurred.
    #[doc(alias = "SCPreferencesApplyChanges")]
    #[inline]
    pub fn apply_changes(&self) -> bool {
        extern "C-unwind" {
            fn SCPreferencesApplyChanges(prefs: &SCPreferences) -> Boolean;
        }
        let ret = unsafe { SCPreferencesApplyChanges(self) };
        ret != 0
    }

    /// Releases exclusive access to the configuration preferences.
    ///
    /// This function releases the exclusive access lock to the
    /// preferences.  Other clients will be now be able to establish
    /// exclusive access to the preferences.
    ///
    /// Parameter `prefs`: The preferences session.
    ///
    /// Returns: Returns TRUE if the lock was obtained;
    /// FALSE if an error occurred.
    #[doc(alias = "SCPreferencesUnlock")]
    #[inline]
    pub fn unlock(&self) -> bool {
        extern "C-unwind" {
            fn SCPreferencesUnlock(prefs: &SCPreferences) -> Boolean;
        }
        let ret = unsafe { SCPreferencesUnlock(self) };
        ret != 0
    }

    /// Returns a sequence of bytes that can be used to determine
    /// if the saved configuration preferences have changed.
    ///
    /// Parameter `prefs`: The preferences session.
    ///
    /// Returns: Returns a CFDataRef that reflects the signature of the configuration
    /// preferences at the time of the call to the SCPreferencesCreate function.
    #[doc(alias = "SCPreferencesGetSignature")]
    #[inline]
    pub fn signature(&self) -> Option<CFRetained<CFData>> {
        extern "C-unwind" {
            fn SCPreferencesGetSignature(prefs: &SCPreferences) -> Option<NonNull<CFData>>;
        }
        let ret = unsafe { SCPreferencesGetSignature(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// Returns an array of currently defined preference keys.
    ///
    /// Parameter `prefs`: The preferences session.
    ///
    /// Returns: Returns the list of keys.
    /// You must release the returned value.
    #[doc(alias = "SCPreferencesCopyKeyList")]
    #[inline]
    pub fn key_list(&self) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn SCPreferencesCopyKeyList(prefs: &SCPreferences) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { SCPreferencesCopyKeyList(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Returns the data associated with a preference key.
    ///
    /// This function retrieves data associated with the specified
    /// key.
    ///
    /// Note: To avoid inadvertantly reading stale data, first call
    /// the SCPreferencesLock function.
    ///
    /// Parameter `prefs`: The preferences session.
    ///
    /// Parameter `key`: The preference key to be returned.
    ///
    /// Returns: Returns the value associated with the specified preference key;
    /// NULL if no value was located.
    #[doc(alias = "SCPreferencesGetValue")]
    #[inline]
    pub fn value(&self, key: &CFString) -> Option<CFRetained<CFPropertyList>> {
        extern "C-unwind" {
            fn SCPreferencesGetValue(
                prefs: &SCPreferences,
                key: &CFString,
            ) -> Option<NonNull<CFPropertyList>>;
        }
        let ret = unsafe { SCPreferencesGetValue(self, key) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// Adds data for a preference key.
    ///
    /// This function associates new data with the specified key.
    /// To commit these changes to permanent storage, a call must
    /// be made to the SCPreferencesCommitChanges function.
    ///
    /// Parameter `prefs`: The preferences session.
    ///
    /// Parameter `key`: The preference key to be updated.
    ///
    /// Parameter `value`: The CFPropertyListRef object containing the
    /// value to be associated with the specified preference key.
    ///
    /// Returns: Returns TRUE if the value was added;
    /// FALSE if the key already exists or
    /// if an error occurred.
    ///
    /// # Safety
    ///
    /// `value` should be of the correct type.
    #[doc(alias = "SCPreferencesAddValue")]
    #[inline]
    pub unsafe fn add_value(&self, key: &CFString, value: &CFPropertyList) -> bool {
        extern "C-unwind" {
            fn SCPreferencesAddValue(
                prefs: &SCPreferences,
                key: &CFString,
                value: &CFPropertyList,
            ) -> Boolean;
        }
        let ret = unsafe { SCPreferencesAddValue(self, key, value) };
        ret != 0
    }

    /// Updates the data associated with a preference key.
    ///
    /// This function adds or replaces the value associated with the
    /// specified key.  To commit these changes to permanent storage
    /// a call must be made to the SCPreferencesCommitChanges function.
    ///
    /// Parameter `prefs`: The preferences session.
    ///
    /// Parameter `key`: The preference key to be updated.
    ///
    /// Parameter `value`: The CFPropertyListRef object containing the
    /// data to be associated with the specified preference key.
    ///
    /// Returns: Returns TRUE if the value was set;
    /// FALSE if an error occurred.
    ///
    /// # Safety
    ///
    /// `value` should be of the correct type.
    #[doc(alias = "SCPreferencesSetValue")]
    #[inline]
    pub unsafe fn set_value(&self, key: &CFString, value: &CFPropertyList) -> bool {
        extern "C-unwind" {
            fn SCPreferencesSetValue(
                prefs: &SCPreferences,
                key: &CFString,
                value: &CFPropertyList,
            ) -> Boolean;
        }
        let ret = unsafe { SCPreferencesSetValue(self, key, value) };
        ret != 0
    }

    /// Removes the data associated with a preference key.
    ///
    /// This function removes the data associated with the specified
    /// key.  To commit these changes to permanent storage a call must
    /// be made to the SCPreferencesCommitChanges function.
    ///
    /// Parameter `prefs`: The preferences session.
    ///
    /// Parameter `key`: The preference key to be removed.
    ///
    /// Returns: Returns TRUE if the value was removed;
    /// FALSE if the key did not exist or if an error occurred.
    #[doc(alias = "SCPreferencesRemoveValue")]
    #[inline]
    pub fn remove_value(&self, key: &CFString) -> bool {
        extern "C-unwind" {
            fn SCPreferencesRemoveValue(prefs: &SCPreferences, key: &CFString) -> Boolean;
        }
        let ret = unsafe { SCPreferencesRemoveValue(self, key) };
        ret != 0
    }

    /// Assigns a callback to a preferences session.  The function
    /// is called when the changes to the preferences have been
    /// committed or applied.
    ///
    /// Parameter `prefs`: The preferences session.
    ///
    /// Parameter `callout`: The function to be called when the preferences have
    /// been changed or applied.
    /// If NULL, the current callback is removed.
    ///
    /// Parameter `context`: The SCPreferencesContext associated with
    /// the callout.
    ///
    /// Returns: Returns TRUE if the notification client was successfully set.
    ///
    /// # Safety
    ///
    /// - `callout` must be implemented correctly.
    /// - `context` must be a valid pointer or null.
    #[doc(alias = "SCPreferencesSetCallback")]
    #[inline]
    pub unsafe fn set_callback(
        &self,
        callout: SCPreferencesCallBack,
        context: *mut SCPreferencesContext,
    ) -> bool {
        extern "C-unwind" {
            fn SCPreferencesSetCallback(
                prefs: &SCPreferences,
                callout: SCPreferencesCallBack,
                context: *mut SCPreferencesContext,
            ) -> Boolean;
        }
        let ret = unsafe { SCPreferencesSetCallback(self, callout, context) };
        ret != 0
    }

    /// Schedule commit and apply notifications for the specified
    /// preferences session using the specified run loop and mode.
    ///
    /// Parameter `prefs`: The preferences session.
    ///
    /// Parameter `runLoop`: A reference to a run loop on which the notification
    /// should be scheduled.
    /// Must be non-NULL.
    ///
    /// Parameter `runLoopMode`: The mode on which to schedule the notification.
    /// Must be non-NULL.
    ///
    /// Returns: Returns TRUE if the notifications are successfully scheduled;
    /// FALSE otherwise.
    #[doc(alias = "SCPreferencesScheduleWithRunLoop")]
    #[inline]
    pub fn schedule_with_run_loop(&self, run_loop: &CFRunLoop, run_loop_mode: &CFString) -> bool {
        extern "C-unwind" {
            fn SCPreferencesScheduleWithRunLoop(
                prefs: &SCPreferences,
                run_loop: &CFRunLoop,
                run_loop_mode: &CFString,
            ) -> Boolean;
        }
        let ret = unsafe { SCPreferencesScheduleWithRunLoop(self, run_loop, run_loop_mode) };
        ret != 0
    }

    /// Unschedule commit and apply notifications for the specified
    /// preferences session from the specified run loop and mode.
    ///
    /// Parameter `prefs`: The preferences session.
    ///
    /// Parameter `runLoop`: A reference to a run loop from which the notification
    /// should be unscheduled.
    /// Must be non-NULL.
    ///
    /// Parameter `runLoopMode`: The mode on which to unschedule the notification.
    /// Must be non-NULL.
    ///
    /// Returns: Returns TRUE if the notifications are successfully unscheduled;
    /// FALSE otherwise.
    #[doc(alias = "SCPreferencesUnscheduleFromRunLoop")]
    #[inline]
    pub fn unschedule_from_run_loop(&self, run_loop: &CFRunLoop, run_loop_mode: &CFString) -> bool {
        extern "C-unwind" {
            fn SCPreferencesUnscheduleFromRunLoop(
                prefs: &SCPreferences,
                run_loop: &CFRunLoop,
                run_loop_mode: &CFString,
            ) -> Boolean;
        }
        let ret = unsafe { SCPreferencesUnscheduleFromRunLoop(self, run_loop, run_loop_mode) };
        ret != 0
    }

    /// Schedule commit and apply notifications for the specified
    /// preferences session.
    ///
    /// Parameter `prefs`: The preferences session.
    ///
    /// Parameter `queue`: The dispatch queue to run the callback function on.
    ///
    /// Returns: Returns TRUE if the notifications are successfully scheduled;
    /// FALSE otherwise.
    ///
    /// # Safety
    ///
    /// `queue` possibly has additional threading requirements.
    #[doc(alias = "SCPreferencesSetDispatchQueue")]
    #[cfg(feature = "dispatch2")]
    #[inline]
    pub unsafe fn set_dispatch_queue(&self, queue: Option<&DispatchQueue>) -> bool {
        extern "C-unwind" {
            fn SCPreferencesSetDispatchQueue(
                prefs: &SCPreferences,
                queue: Option<&DispatchQueue>,
            ) -> Boolean;
        }
        let ret = unsafe { SCPreferencesSetDispatchQueue(self, queue) };
        ret != 0
    }

    /// Synchronizes accessed preferences with committed changes.
    ///
    /// Any references to preference values returned by calls to the
    /// SCPreferencesGetValue function are no longer valid unless they
    /// were explicitly retained or copied.  Any preference values
    /// that were updated (add, set, remove) but not committed will
    /// be discarded.
    ///
    /// Parameter `prefs`: The preferences session.
    #[doc(alias = "SCPreferencesSynchronize")]
    #[inline]
    pub fn synchronize(&self) {
        extern "C-unwind" {
            fn SCPreferencesSynchronize(prefs: &SCPreferences);
        }
        unsafe { SCPreferencesSynchronize(self) }
    }
}

#[deprecated = "renamed to `SCPreferences::new`"]
#[inline]
pub extern "C-unwind" fn SCPreferencesCreate(
    allocator: Option<&CFAllocator>,
    name: &CFString,
    prefs_id: Option<&CFString>,
) -> Option<CFRetained<SCPreferences>> {
    extern "C-unwind" {
        fn SCPreferencesCreate(
            allocator: Option<&CFAllocator>,
            name: &CFString,
            prefs_id: Option<&CFString>,
        ) -> Option<NonNull<SCPreferences>>;
    }
    let ret = unsafe { SCPreferencesCreate(allocator, name, prefs_id) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "objc2-security")]
#[deprecated = "renamed to `SCPreferences::with_authorization`"]
#[inline]
pub unsafe extern "C-unwind" fn SCPreferencesCreateWithAuthorization(
    allocator: Option<&CFAllocator>,
    name: &CFString,
    prefs_id: Option<&CFString>,
    authorization: AuthorizationRef,
) -> Option<CFRetained<SCPreferences>> {
    extern "C-unwind" {
        fn SCPreferencesCreateWithAuthorization(
            allocator: Option<&CFAllocator>,
            name: &CFString,
            prefs_id: Option<&CFString>,
            authorization: AuthorizationRef,
        ) -> Option<NonNull<SCPreferences>>;
    }
    let ret =
        unsafe { SCPreferencesCreateWithAuthorization(allocator, name, prefs_id, authorization) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `SCPreferences::lock`"]
#[inline]
pub extern "C-unwind" fn SCPreferencesLock(prefs: &SCPreferences, wait: bool) -> bool {
    extern "C-unwind" {
        fn SCPreferencesLock(prefs: &SCPreferences, wait: Boolean) -> Boolean;
    }
    let ret = unsafe { SCPreferencesLock(prefs, wait as _) };
    ret != 0
}

#[deprecated = "renamed to `SCPreferences::commit_changes`"]
#[inline]
pub extern "C-unwind" fn SCPreferencesCommitChanges(prefs: &SCPreferences) -> bool {
    extern "C-unwind" {
        fn SCPreferencesCommitChanges(prefs: &SCPreferences) -> Boolean;
    }
    let ret = unsafe { SCPreferencesCommitChanges(prefs) };
    ret != 0
}

#[deprecated = "renamed to `SCPreferences::apply_changes`"]
#[inline]
pub extern "C-unwind" fn SCPreferencesApplyChanges(prefs: &SCPreferences) -> bool {
    extern "C-unwind" {
        fn SCPreferencesApplyChanges(prefs: &SCPreferences) -> Boolean;
    }
    let ret = unsafe { SCPreferencesApplyChanges(prefs) };
    ret != 0
}

#[deprecated = "renamed to `SCPreferences::unlock`"]
#[inline]
pub extern "C-unwind" fn SCPreferencesUnlock(prefs: &SCPreferences) -> bool {
    extern "C-unwind" {
        fn SCPreferencesUnlock(prefs: &SCPreferences) -> Boolean;
    }
    let ret = unsafe { SCPreferencesUnlock(prefs) };
    ret != 0
}

#[deprecated = "renamed to `SCPreferences::signature`"]
#[inline]
pub extern "C-unwind" fn SCPreferencesGetSignature(
    prefs: &SCPreferences,
) -> Option<CFRetained<CFData>> {
    extern "C-unwind" {
        fn SCPreferencesGetSignature(prefs: &SCPreferences) -> Option<NonNull<CFData>>;
    }
    let ret = unsafe { SCPreferencesGetSignature(prefs) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `SCPreferences::key_list`"]
#[inline]
pub extern "C-unwind" fn SCPreferencesCopyKeyList(
    prefs: &SCPreferences,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn SCPreferencesCopyKeyList(prefs: &SCPreferences) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { SCPreferencesCopyKeyList(prefs) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `SCPreferences::value`"]
#[inline]
pub extern "C-unwind" fn SCPreferencesGetValue(
    prefs: &SCPreferences,
    key: &CFString,
) -> Option<CFRetained<CFPropertyList>> {
    extern "C-unwind" {
        fn SCPreferencesGetValue(
            prefs: &SCPreferences,
            key: &CFString,
        ) -> Option<NonNull<CFPropertyList>>;
    }
    let ret = unsafe { SCPreferencesGetValue(prefs, key) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `SCPreferences::add_value`"]
#[inline]
pub unsafe extern "C-unwind" fn SCPreferencesAddValue(
    prefs: &SCPreferences,
    key: &CFString,
    value: &CFPropertyList,
) -> bool {
    extern "C-unwind" {
        fn SCPreferencesAddValue(
            prefs: &SCPreferences,
            key: &CFString,
            value: &CFPropertyList,
        ) -> Boolean;
    }
    let ret = unsafe { SCPreferencesAddValue(prefs, key, value) };
    ret != 0
}

#[deprecated = "renamed to `SCPreferences::set_value`"]
#[inline]
pub unsafe extern "C-unwind" fn SCPreferencesSetValue(
    prefs: &SCPreferences,
    key: &CFString,
    value: &CFPropertyList,
) -> bool {
    extern "C-unwind" {
        fn SCPreferencesSetValue(
            prefs: &SCPreferences,
            key: &CFString,
            value: &CFPropertyList,
        ) -> Boolean;
    }
    let ret = unsafe { SCPreferencesSetValue(prefs, key, value) };
    ret != 0
}

#[deprecated = "renamed to `SCPreferences::remove_value`"]
#[inline]
pub extern "C-unwind" fn SCPreferencesRemoveValue(prefs: &SCPreferences, key: &CFString) -> bool {
    extern "C-unwind" {
        fn SCPreferencesRemoveValue(prefs: &SCPreferences, key: &CFString) -> Boolean;
    }
    let ret = unsafe { SCPreferencesRemoveValue(prefs, key) };
    ret != 0
}

#[deprecated = "renamed to `SCPreferences::set_callback`"]
#[inline]
pub unsafe extern "C-unwind" fn SCPreferencesSetCallback(
    prefs: &SCPreferences,
    callout: SCPreferencesCallBack,
    context: *mut SCPreferencesContext,
) -> bool {
    extern "C-unwind" {
        fn SCPreferencesSetCallback(
            prefs: &SCPreferences,
            callout: SCPreferencesCallBack,
            context: *mut SCPreferencesContext,
        ) -> Boolean;
    }
    let ret = unsafe { SCPreferencesSetCallback(prefs, callout, context) };
    ret != 0
}

#[deprecated = "renamed to `SCPreferences::schedule_with_run_loop`"]
#[inline]
pub extern "C-unwind" fn SCPreferencesScheduleWithRunLoop(
    prefs: &SCPreferences,
    run_loop: &CFRunLoop,
    run_loop_mode: &CFString,
) -> bool {
    extern "C-unwind" {
        fn SCPreferencesScheduleWithRunLoop(
            prefs: &SCPreferences,
            run_loop: &CFRunLoop,
            run_loop_mode: &CFString,
        ) -> Boolean;
    }
    let ret = unsafe { SCPreferencesScheduleWithRunLoop(prefs, run_loop, run_loop_mode) };
    ret != 0
}

#[deprecated = "renamed to `SCPreferences::unschedule_from_run_loop`"]
#[inline]
pub extern "C-unwind" fn SCPreferencesUnscheduleFromRunLoop(
    prefs: &SCPreferences,
    run_loop: &CFRunLoop,
    run_loop_mode: &CFString,
) -> bool {
    extern "C-unwind" {
        fn SCPreferencesUnscheduleFromRunLoop(
            prefs: &SCPreferences,
            run_loop: &CFRunLoop,
            run_loop_mode: &CFString,
        ) -> Boolean;
    }
    let ret = unsafe { SCPreferencesUnscheduleFromRunLoop(prefs, run_loop, run_loop_mode) };
    ret != 0
}

#[cfg(feature = "dispatch2")]
#[deprecated = "renamed to `SCPreferences::set_dispatch_queue`"]
#[inline]
pub unsafe extern "C-unwind" fn SCPreferencesSetDispatchQueue(
    prefs: &SCPreferences,
    queue: Option<&DispatchQueue>,
) -> bool {
    extern "C-unwind" {
        fn SCPreferencesSetDispatchQueue(
            prefs: &SCPreferences,
            queue: Option<&DispatchQueue>,
        ) -> Boolean;
    }
    let ret = unsafe { SCPreferencesSetDispatchQueue(prefs, queue) };
    ret != 0
}

#[deprecated = "renamed to `SCPreferences::synchronize`"]
#[inline]
pub extern "C-unwind" fn SCPreferencesSynchronize(prefs: &SCPreferences) {
    extern "C-unwind" {
        fn SCPreferencesSynchronize(prefs: &SCPreferences);
    }
    unsafe { SCPreferencesSynchronize(prefs) }
}
