/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	context "context"

	autoscalingv1 "k8s.io/api/autoscaling/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	gentype "k8s.io/client-go/gentype"
	testing "k8s.io/client-go/testing"
	v1 "k8s.io/code-generator/examples/MixedCase/apis/example/v1"
	examplev1 "k8s.io/code-generator/examples/MixedCase/applyconfiguration/example/v1"
	typedexamplev1 "k8s.io/code-generator/examples/MixedCase/clientset/versioned/typed/example/v1"
)

// fakeClusterTestTypes implements ClusterTestTypeInterface
type fakeClusterTestTypes struct {
	*gentype.FakeClientWithListAndApply[*v1.ClusterTestType, *v1.ClusterTestTypeList, *examplev1.ClusterTestTypeApplyConfiguration]
	Fake *FakeExampleV1
}

func newFakeClusterTestTypes(fake *FakeExampleV1) typedexamplev1.ClusterTestTypeInterface {
	return &fakeClusterTestTypes{
		gentype.NewFakeClientWithListAndApply[*v1.ClusterTestType, *v1.ClusterTestTypeList, *examplev1.ClusterTestTypeApplyConfiguration](
			fake.Fake,
			"",
			v1.SchemeGroupVersion.WithResource("clustertesttypes"),
			v1.SchemeGroupVersion.WithKind("ClusterTestType"),
			func() *v1.ClusterTestType { return &v1.ClusterTestType{} },
			func() *v1.ClusterTestTypeList { return &v1.ClusterTestTypeList{} },
			func(dst, src *v1.ClusterTestTypeList) { dst.ListMeta = src.ListMeta },
			func(list *v1.ClusterTestTypeList) []*v1.ClusterTestType { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.ClusterTestTypeList, items []*v1.ClusterTestType) {
				list.Items = gentype.FromPointerSlice(items)
			},
		),
		fake,
	}
}

// GetScale takes name of the clusterTestType, and returns the corresponding scale object, and an error if there is any.
func (c *fakeClusterTestTypes) GetScale(ctx context.Context, clusterTestTypeName string, options metav1.GetOptions) (result *autoscalingv1.Scale, err error) {
	emptyResult := &autoscalingv1.Scale{}
	obj, err := c.Fake.
		Invokes(testing.NewRootGetSubresourceActionWithOptions(c.Resource(), "scale", clusterTestTypeName, options), emptyResult)
	if obj == nil {
		return emptyResult, err
	}
	return obj.(*autoscalingv1.Scale), err
}

// UpdateScale takes the representation of a scale and updates it. Returns the server's representation of the scale, and an error, if there is any.
func (c *fakeClusterTestTypes) UpdateScale(ctx context.Context, clusterTestTypeName string, scale *autoscalingv1.Scale, opts metav1.UpdateOptions) (result *autoscalingv1.Scale, err error) {
	emptyResult := &autoscalingv1.Scale{}
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateSubresourceActionWithOptions(c.Resource(), "scale", scale, opts), emptyResult)
	if obj == nil {
		return emptyResult, err
	}
	return obj.(*autoscalingv1.Scale), err
}

// CreateScale takes the representation of a scale and creates it.  Returns the server's representation of the scale, and an error, if there is any.
func (c *fakeClusterTestTypes) CreateScale(ctx context.Context, clusterTestTypeName string, scale *autoscalingv1.Scale, opts metav1.CreateOptions) (result *autoscalingv1.Scale, err error) {
	emptyResult := &autoscalingv1.Scale{}
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateSubresourceActionWithOptions(c.Resource(), clusterTestTypeName, "scale", scale, opts), emptyResult)
	if obj == nil {
		return emptyResult, err
	}
	return obj.(*autoscalingv1.Scale), err
}
