/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.cloudExplorer.CloudConnectionData;
import com.intellij.database.dataSource.AbstractDataSourceConfigurable;
import com.intellij.database.dataSource.AbstractDatabaseConfigurable;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.DdlMapping;
import com.intellij.database.dataSource.DdlMappingConfigurable;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DataSourceProblemsProvider;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DataSourceManagerUi;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.view.ui.ActualConfigInfoProvider;
import com.intellij.database.view.ui.CloudConfigurable;
import com.intellij.database.view.ui.DataSourceErrorsConfigurable;
import com.intellij.database.view.ui.DatabaseConfigEditorImpl;
import com.intellij.database.view.ui.DatabaseDriverConfigurable;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.navigation.Place;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import java.awt.event.ActionEvent;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class SidePanelItem<Represented, RepConfigurable extends Configurable> {
    private static final String ELEMENT = "element";
    private Place myPlace;
    private final Represented myRepresented;
    private RepConfigurable myConfigurable;
    private JComponent myComponent;
    private JComponent myResetComponent;
    private Boolean myModifiedCache;
    protected DatabaseConfigEditorImpl myEditor;
    private DataSourceProblem myDataSourceProblem;

    SidePanelItem(@NotNull DatabaseConfigEditorImpl editor2, @NotNull Represented represented) {
        if (editor2 == null) {
            SidePanelItem.$$$reportNull$$$0(0);
        }
        if (represented == null) {
            SidePanelItem.$$$reportNull$$$0(1);
        }
        this.myEditor = editor2;
        this.myRepresented = represented;
    }

    public void onDepActivity() {
        if (this.myConfigurable instanceof AbstractDatabaseConfigurable) {
            ((AbstractDatabaseConfigurable)this.myConfigurable).onDepActivity();
        }
    }

    private static Place createPlaceFor(@NotNull SidePanelItem<?, ?> item) {
        if (item == null) {
            SidePanelItem.$$$reportNull$$$0(2);
        }
        return SidePanelItem.setItem(new Place(), item);
    }

    @NotNull
    public static Place setItem(@NotNull Place place, @Nullable SidePanelItem<?, ?> item) {
        if (place == null) {
            SidePanelItem.$$$reportNull$$$0(3);
        }
        Place place2 = place.putPath(ELEMENT, item);
        if (place2 == null) {
            SidePanelItem.$$$reportNull$$$0(4);
        }
        return place2;
    }

    @Nullable
    public static SidePanelItem<?, ?> getItem(@Nullable Place place) {
        return place == null ? null : (SidePanelItem)place.getPath(ELEMENT);
    }

    @Nullable
    public static <R> R getObject(@Nullable SidePanelItem<R, ?> item) {
        return item == null ? null : (R)item.getObject();
    }

    @NotNull
    public JComponent getResetComponent() {
        if (this.myResetComponent == null) {
            this.myResetComponent = new ActionLink((Action)new AbstractAction(DatabaseBundle.message((String)"SidePanelItem.reset", (Object[])new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SidePanelItem.this.reset();
                }
            });
        }
        JComponent jComponent = this.myResetComponent;
        if (jComponent == null) {
            SidePanelItem.$$$reportNull$$$0(5);
        }
        return jComponent;
    }

    protected void preReset() {
    }

    protected void reset() {
        if (this.getConfigurable() != null) {
            this.preReset();
            this.getConfigurable().reset();
        }
    }

    protected boolean isResetEnabled() {
        return this.isModified();
    }

    public void updateResetComponent() {
        if (this.myResetComponent != null) {
            DbUIUtil.invokeLater(() -> this.myResetComponent.setVisible(this.isResetEnabled()));
        }
    }

    @Nullable
    public Place getPlace() {
        return this.myPlace;
    }

    @NotNull
    public Place createPlace() {
        if (this.myPlace == null) {
            this.myPlace = SidePanelItem.createPlaceFor(this);
        }
        Place place = this.myPlace;
        if (place == null) {
            SidePanelItem.$$$reportNull$$$0(6);
        }
        return place;
    }

    @NotNull
    public Represented getObject() {
        Represented Represented = this.myRepresented;
        if (Represented == null) {
            SidePanelItem.$$$reportNull$$$0(7);
        }
        return Represented;
    }

    @Nullable
    public RepConfigurable getConfigurable() {
        return this.myConfigurable;
    }

    @Nullable
    public JComponent getComponent() {
        return this.myComponent;
    }

    @NotNull
    public RepConfigurable createConfigurable() {
        if (this.myConfigurable == null) {
            RepConfigurable configurable = this.createConfigurableImpl();
            this.myComponent = configurable.createComponent();
            this.myConfigurable = configurable;
            if (this.myConfigurable instanceof AbstractDatabaseConfigurable) {
                ((AbstractDatabaseConfigurable)this.myConfigurable).init(this::fireChanged);
            } else {
                this.myConfigurable.reset();
            }
            this.updateResetComponent();
        }
        RepConfigurable RepConfigurable = this.myConfigurable;
        if (RepConfigurable == null) {
            SidePanelItem.$$$reportNull$$$0(8);
        }
        return RepConfigurable;
    }

    protected void fireChanged() {
        this.resetModifiedCache();
        this.myEditor.onUiActivity(this);
    }

    @NotNull
    public abstract RepConfigurable createConfigurableImpl();

    public void removeConfigurable() {
        if (this.myConfigurable == null) {
            return;
        }
        this.myConfigurable.disposeUIResources();
        this.myConfigurable = null;
        this.myComponent = null;
    }

    public void resetModifiedCache() {
        this.myModifiedCache = null;
        this.updateResetComponent();
    }

    public boolean isModified() {
        if (this.myConfigurable == null) {
            return false;
        }
        if (this.myModifiedCache == null) {
            this.myModifiedCache = this.myConfigurable.isModified();
        }
        return this.myModifiedCache;
    }

    public abstract boolean accept(@NotNull ItemsVisitor var1);

    @NlsSafe
    public abstract String getName();

    public DataSourceProblem getDataSourceProblem() {
        return this.myDataSourceProblem;
    }

    public void setDataSourceProblem(DataSourceProblem dataSourceProblem) {
        this.myDataSourceProblem = dataSourceProblem;
    }

    public abstract void apply() throws ConfigurationException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "represented";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/SidePanelItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/SidePanelItem";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "setItem";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getResetComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createPlace";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getObject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createPlaceFor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setItem";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }

    static class ItemsVisitor
    implements Processor<SidePanelItem<?, ?>> {
        ItemsVisitor() {
        }

        boolean visit(DataSourceItem dataSourceItem) {
            return true;
        }

        boolean visit(DriverItem driverItem) {
            return true;
        }

        boolean visit(MappingItem mappingItem) {
            return true;
        }

        boolean visit(ErrorsItem errorItem) {
            return true;
        }

        boolean visit(CloudItem cloudItem) {
            return true;
        }

        public boolean process(SidePanelItem item) {
            return item.accept(this);
        }
    }

    static class ErrorsItem
    extends SidePanelItem<DataSourceErrorsConfigurable, DataSourceErrorsConfigurable> {
        ErrorsItem(@NotNull DatabaseConfigEditorImpl editor2, @NotNull DataSourceErrorsConfigurable source) {
            if (editor2 == null) {
                ErrorsItem.$$$reportNull$$$0(0);
            }
            if (source == null) {
                ErrorsItem.$$$reportNull$$$0(1);
            }
            super(editor2, source);
        }

        @Override
        public boolean accept(@NotNull ItemsVisitor visitor) {
            if (visitor == null) {
                ErrorsItem.$$$reportNull$$$0(2);
            }
            return visitor.visit(this);
        }

        @Override
        public String getName() {
            return this.getConfigurable() == null ? DatabaseBundle.message((String)"SidePanelItem.problems", (Object[])new Object[0]) : ((DataSourceErrorsConfigurable)this.getConfigurable()).getDisplayName();
        }

        @Override
        public void apply() throws ConfigurationException {
        }

        @Override
        @NotNull
        public DataSourceErrorsConfigurable createConfigurableImpl() {
            DataSourceErrorsConfigurable dataSourceErrorsConfigurable = (DataSourceErrorsConfigurable)this.getObject();
            if (dataSourceErrorsConfigurable == null) {
                ErrorsItem.$$$reportNull$$$0(3);
            }
            return dataSourceErrorsConfigurable;
        }

        @Override
        public void removeConfigurable() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/SidePanelItem$ErrorsItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/SidePanelItem$ErrorsItem";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createConfigurableImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    static class CloudItem
    extends SidePanelItem<CloudConnectionData, CloudConfigurable>
    implements DataSourceProblemsProvider {
        CloudItem(@NotNull DatabaseConfigEditorImpl editor2, @NotNull CloudConnectionData data) {
            if (editor2 == null) {
                CloudItem.$$$reportNull$$$0(0);
            }
            if (data == null) {
                CloudItem.$$$reportNull$$$0(1);
            }
            super(editor2, data);
        }

        @Override
        @NotNull
        public CloudConfigurable createConfigurableImpl() {
            Project project = this.myEditor.getSettings().facade.getProject();
            return new CloudConfigurable(project, (CloudConnectionData)this.getObject(), this.myEditor);
        }

        @Override
        public boolean accept(@NotNull ItemsVisitor visitor) {
            if (visitor == null) {
                CloudItem.$$$reportNull$$$0(2);
            }
            return visitor.visit(this);
        }

        @Override
        public String getName() {
            return this.getConfigurable() == null ? ((CloudConnectionData)this.getObject()).getName() : ((CloudConfigurable)((Object)this.getConfigurable())).getDisplayName();
        }

        @Override
        public void apply() throws ConfigurationException {
            if (this.getConfigurable() != null) {
                ((CloudConfigurable)((Object)this.getConfigurable())).apply();
            }
        }

        @Override
        public Object getErrorsTarget() {
            CloudConfigurable configurable = (CloudConfigurable)((Object)this.getConfigurable());
            return configurable == null ? this.getObject() : WriteIntentReadAction.compute(() -> configurable.getTempTarget());
        }

        @Override
        public Set<DataSourceProblem> getErrors(@NotNull String dataSourceName, Object target) {
            if (dataSourceName == null) {
                CloudItem.$$$reportNull$$$0(3);
            }
            return DatabaseConfigValidator.getProblems(this.myEditor.getSettings().facade.getProject(), dataSourceName, target, (ActualConfigInfoProvider)this.myEditor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSourceName";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/view/ui/SidePanelItem$CloudItem";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getErrors";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class MappingItem
    extends SidePanelItem<DdlMapping, DdlMappingConfigurable>
    implements DataSourceProblemsProvider {
        MappingItem(@NotNull DatabaseConfigEditorImpl editor2, @NotNull DdlMapping source) {
            if (editor2 == null) {
                MappingItem.$$$reportNull$$$0(0);
            }
            if (source == null) {
                MappingItem.$$$reportNull$$$0(1);
            }
            super(editor2, source);
        }

        @Override
        public boolean accept(@NotNull ItemsVisitor visitor) {
            if (visitor == null) {
                MappingItem.$$$reportNull$$$0(2);
            }
            return visitor.visit(this);
        }

        @Override
        public String getName() {
            return this.getConfigurable() == null ? ((DdlMapping)this.getObject()).getName() : ((DdlMappingConfigurable)((Object)this.getConfigurable())).getDisplayName();
        }

        @Override
        public void apply() throws ConfigurationException {
            if (this.getConfigurable() != null) {
                ((DdlMappingConfigurable)((Object)this.getConfigurable())).apply();
            }
        }

        @Override
        @NotNull
        public DdlMappingConfigurable createConfigurableImpl() {
            return new DdlMappingConfigurable(this.myEditor.getSettings().facade.getProject(), (DdlMapping)this.getObject(), this.myEditor);
        }

        @Override
        public Object getErrorsTarget() {
            DdlMappingConfigurable configurable = (DdlMappingConfigurable)((Object)this.getConfigurable());
            return configurable == null ? this.getObject() : configurable.getTempTarget();
        }

        @Override
        public Set<DataSourceProblem> getErrors(@NotNull String dataSourceName, Object target) {
            if (dataSourceName == null) {
                MappingItem.$$$reportNull$$$0(3);
            }
            return DatabaseConfigValidator.getProblems(this.myEditor.getSettings().facade.getProject(), dataSourceName, target, (ActualConfigInfoProvider)this.myEditor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSourceName";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/view/ui/SidePanelItem$MappingItem";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getErrors";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class DriverItem
    extends SidePanelItem<DatabaseDriver, DatabaseDriverConfigurable>
    implements DataSourceProblemsProvider {
        DriverItem(@NotNull DatabaseConfigEditorImpl editor2, @NotNull DatabaseDriver source) {
            if (editor2 == null) {
                DriverItem.$$$reportNull$$$0(0);
            }
            if (source == null) {
                DriverItem.$$$reportNull$$$0(1);
            }
            super(editor2, source);
        }

        @Override
        protected void reset() {
            super.reset();
            if (this.getConfigurable() != null) {
                this.myEditor.updateDriverDependants((DatabaseDriver)((DatabaseDriverConfigurable)((Object)this.getConfigurable())).getTempDriver());
            }
        }

        @Override
        public boolean accept(@NotNull ItemsVisitor visitor) {
            if (visitor == null) {
                DriverItem.$$$reportNull$$$0(2);
            }
            return visitor.visit(this);
        }

        @Override
        public String getName() {
            return this.getConfigurable() == null ? ((DatabaseDriver)this.getObject()).getName() : ((DatabaseDriverConfigurable)((Object)this.getConfigurable())).getDisplayName();
        }

        @Override
        public void apply() throws ConfigurationException {
            if (this.getConfigurable() != null) {
                ((DatabaseDriverConfigurable)((Object)this.getConfigurable())).apply();
            } else if (this.isNew()) {
                DatabaseDriverManager.getInstance().updateDriver((DatabaseDriver)this.getObject());
            }
        }

        private boolean isNew() {
            return !DatabaseDriverManager.getInstance().getDrivers().contains(this.getObject());
        }

        @Override
        @NotNull
        public DatabaseDriverConfigurable createConfigurableImpl() {
            return new DatabaseDriverConfigurable(this.myEditor.getSettings().facade.getProject(), (DatabaseDriverImpl)this.getObject(), this.myEditor);
        }

        @Override
        public Object getErrorsTarget() {
            DatabaseDriverConfigurable configurable = (DatabaseDriverConfigurable)((Object)this.getConfigurable());
            return configurable == null ? this.getObject() : configurable.getTempDriver();
        }

        @Override
        public Set<DataSourceProblem> getErrors(@NotNull String dataSourceName, Object target) {
            if (dataSourceName == null) {
                DriverItem.$$$reportNull$$$0(3);
            }
            return DatabaseConfigValidator.getProblems(this.myEditor.getSettings().facade.getProject(), dataSourceName, target, (ActualConfigInfoProvider)this.myEditor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSourceName";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/view/ui/SidePanelItem$DriverItem";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getErrors";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class DataSourceItem
    extends SidePanelItem<DbDataSourceImpl, AbstractDataSourceConfigurable<?, ?>>
    implements DataSourceProblemsProvider {
        final DataSourceManager<RawDataSource> dbManager;
        private boolean isGlobalCache;

        DataSourceItem(@NotNull DatabaseConfigEditorImpl editor2, @NotNull DbDataSourceImpl dataSource) {
            if (editor2 == null) {
                DataSourceItem.$$$reportNull$$$0(0);
            }
            if (dataSource == null) {
                DataSourceItem.$$$reportNull$$$0(1);
            }
            super(editor2, dataSource);
            this.dbManager = editor2.getSettings().facade.getDataSourceManager((DbDataSource)dataSource);
            this.isGlobalCache = this.isGlobal();
        }

        @Override
        protected void preReset() {
            LocalDataSource localDataSource = (LocalDataSource)ObjectUtils.tryCast((Object)((DbDataSourceImpl)this.getObject()).getDelegate(), LocalDataSource.class);
            if (localDataSource != null) {
                this.myEditor.resurrectDriver(localDataSource.getDatabaseDriver());
            }
        }

        @Nullable
        public LocalDataSource extractActualLocalDataSource() {
            LocalDataSource actual = this.getConfigurable() == null ? null : (LocalDataSource)ObjectUtils.tryCast(((AbstractDataSourceConfigurable)((Object)this.getConfigurable())).getTempDataSource(), LocalDataSource.class);
            return actual == null ? (LocalDataSource)ObjectUtils.tryCast((Object)((DbDataSourceImpl)this.getObject()).getDelegate(), LocalDataSource.class) : actual;
        }

        @Override
        public boolean accept(@NotNull ItemsVisitor visitor) {
            if (visitor == null) {
                DataSourceItem.$$$reportNull$$$0(2);
            }
            return visitor.visit(this);
        }

        @Override
        public String getName() {
            return this.getConfigurable() == null ? ((DbDataSourceImpl)this.getObject()).getName() : ((AbstractDataSourceConfigurable)((Object)this.getConfigurable())).getDisplayName();
        }

        @Override
        public void apply() throws ConfigurationException {
            if (this.getConfigurable() != null) {
                ((AbstractDataSourceConfigurable)((Object)this.getConfigurable())).apply();
            } else if (!this.dbManager.getDataSources().contains(((DbDataSourceImpl)this.getObject()).getDelegate())) {
                this.dbManager.addDataSource((RawDataSource)((DbDataSourceImpl)this.getObject()).getDelegate());
            }
            ((DbDataSourceImpl)this.getObject()).clearCaches();
        }

        public boolean isGlobal() {
            DataSourceConfigurable configurable = (DataSourceConfigurable)((Object)ObjectUtils.tryCast(this.getConfigurable(), DataSourceConfigurable.class));
            if (configurable != null) {
                return configurable.isGlobal();
            }
            LocalDataSource localDataSource = this.extractActualLocalDataSource();
            return localDataSource != null && localDataSource.isGlobal();
        }

        public boolean isImported() {
            LocalDataSource localDataSource = this.extractActualLocalDataSource();
            return localDataSource != null && localDataSource.isImported();
        }

        @Override
        protected void fireChanged() {
            super.fireChanged();
            boolean global = this.isGlobal();
            if (this.isGlobalCache != global) {
                this.isGlobalCache = global;
                this.myEditor.refillSidePanel(this.myEditor.getSettings(), true);
            }
        }

        @Override
        @NotNull
        public AbstractDataSourceConfigurable<?, ?> createConfigurableImpl() {
            AbstractDataSourceConfigurable configurable = (AbstractDataSourceConfigurable)((DataSourceManagerUi)this.dbManager).createDataSourceEditor((RawDataSource)((DbDataSourceImpl)this.getObject()).getDelegate());
            configurable.setController(this.myEditor);
            AbstractDataSourceConfigurable abstractDataSourceConfigurable = configurable;
            if (abstractDataSourceConfigurable == null) {
                DataSourceItem.$$$reportNull$$$0(3);
            }
            return abstractDataSourceConfigurable;
        }

        @Override
        public Object getErrorsTarget() {
            AbstractDataSourceConfigurable configurable = (AbstractDataSourceConfigurable)((Object)this.getConfigurable());
            return configurable == null ? ((DbDataSourceImpl)this.getObject()).getDelegate() : configurable.getTempDataSource();
        }

        @Override
        public Set<DataSourceProblem> getErrors(@NotNull String dataSourceName, Object target) {
            if (dataSourceName == null) {
                DataSourceItem.$$$reportNull$$$0(4);
            }
            return DatabaseConfigValidator.getProblems(this.myEditor.getSettings().facade.getProject(), dataSourceName, target, (ActualConfigInfoProvider)this.myEditor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/SidePanelItem$DataSourceItem";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSourceName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/SidePanelItem$DataSourceItem";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createConfigurableImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getErrors";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

