/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aqua.runners.js.core;

import com.intellij.aqua.runners.js.core.JsTestRunConfiguration;
import com.intellij.aqua.runners.js.core.JsTestRunSettings;
import com.intellij.aqua.runners.js.core.JsTestRunSettingsBuilder;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.JsTestElementPath;
import com.intellij.javascript.testing.detection.JsTestFrameworkDetector;
import com.intellij.javascript.testing.detection.JsTestFrameworkPackageDescriptor;
import com.intellij.javascript.testing.runConfiguration.JsTestRunConfigurationProducer;
import com.intellij.javascript.testing.runScope.JsTestRunScope;
import com.intellij.javascript.testing.runScope.JsTestRunScopeKind;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\b\u0012\u0004\u0012\u0002H\u00030\u0005:\u0001\u001eB\u0015\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0002J%\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u0013J\"\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0016H\u0002J\"\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018J\"\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/aqua/runners/js/core/ExtendedJsTestRunConfigurationProducer;", "Settings", "Lcom/intellij/aqua/runners/js/core/JsTestRunSettings;", "Configuration", "Lcom/intellij/aqua/runners/js/core/JsTestRunConfiguration;", "Lcom/intellij/javascript/testing/runConfiguration/JsTestRunConfigurationProducer;", "configFileNames", "", "", "<init>", "(Ljava/util/List;)V", "guessWorkingDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "contextFile", "fixWorkingDir", "settings", "contextFileOrDir", "(Lcom/intellij/aqua/runners/js/core/JsTestRunSettings;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;)Lcom/intellij/aqua/runners/js/core/JsTestRunSettings;", "tryBuildDirectorySettings", "Lkotlin/Pair;", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/aqua/runners/js/core/ExtendedJsTestRunConfigurationProducer$Context;", "findContextSuiteOrTestPath", "Lcom/intellij/javascript/testFramework/JsTestElementPath;", "element", "tryBuildSuiteOrTestSettings", "tryBuildTestFileSettings", "Context", "intellij.aqua.runners.js.core"})
public abstract class ExtendedJsTestRunConfigurationProducer<Settings extends JsTestRunSettings<Settings>, Configuration extends JsTestRunConfiguration<Settings>>
extends JsTestRunConfigurationProducer<Configuration> {
    @NotNull
    private final List<String> configFileNames;

    public ExtendedJsTestRunConfigurationProducer(@NotNull List<String> configFileNames) {
        Intrinsics.checkNotNullParameter(configFileNames, (String)"configFileNames");
        this.configFileNames = configFileNames;
    }

    private final VirtualFile guessWorkingDir(Project project, VirtualFile contextFile) {
        Ref ref2 = Ref.create();
        Intrinsics.checkNotNullExpressionValue((Object)ref2, (String)"create(...)");
        Ref firstPackageJsonDir = ref2;
        AtomicBoolean basedOnDeclaredDependency = new AtomicBoolean(false);
        VirtualFile workingDir = (VirtualFile)JSProjectUtil.processDirectoriesUpToContentRootAndFindFirst(project, contextFile, arg_0 -> ExtendedJsTestRunConfigurationProducer.guessWorkingDir$lambda$1(arg_0 -> ExtendedJsTestRunConfigurationProducer.guessWorkingDir$lambda$0(this, firstPackageJsonDir, basedOnDeclaredDependency, project, arg_0), arg_0));
        VirtualFile firstPackageJson = (VirtualFile)firstPackageJsonDir.get();
        if (firstPackageJson != null && !Intrinsics.areEqual((Object)firstPackageJson, (Object)workingDir) && basedOnDeclaredDependency.get()) {
            return firstPackageJson;
        }
        return workingDir;
    }

    private final Settings fixWorkingDir(Settings settings, VirtualFile contextFileOrDir, Project project) {
        VirtualFile virtualFile;
        if (StringsKt.isBlank((CharSequence)((JsTestRunSettings)settings).getWorkingDir()) && (virtualFile = this.guessWorkingDir(project, contextFileOrDir)) != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            JsTestRunSettingsBuilder jsTestRunSettingsBuilder = ((JsTestRunSettings)settings).builder();
            String string = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            return jsTestRunSettingsBuilder.workingDir(string).build();
        }
        return settings;
    }

    @Nullable
    public final Pair<Settings, PsiElement> tryBuildDirectorySettings(@NotNull Context<Settings> context2) {
        Pair pair;
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        PsiElement psiElement = context2.getElement();
        PsiDirectory psiDirectory = psiElement instanceof PsiDirectory ? (PsiDirectory)psiElement : null;
        if (psiDirectory == null) {
            return null;
        }
        PsiDirectory psiDirectory2 = psiDirectory;
        VirtualFile virtualFile = context2.getFile();
        Project project = psiDirectory2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (Intrinsics.areEqual((Object)virtualFile, (Object)ProjectUtil.guessProjectDir((Project)project))) {
            Object Settings2 = ((JsTestRunSettings)context2.getTemplateRunSettings()).builder().scope((Function1<JsTestRunScope.Builder, Unit>)((Function1)ExtendedJsTestRunConfigurationProducer::tryBuildDirectorySettings$lambda$0)).build();
            VirtualFile virtualFile2 = context2.getFile();
            Project project2 = psiDirectory2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            pair = new Pair(this.fixWorkingDir(Settings2, virtualFile2, project2), (Object)psiDirectory2);
        } else {
            boolean bl;
            JsTestFrameworkDetector jsTestFrameworkDetector = this.getTestFrameworkDetector();
            if (jsTestFrameworkDetector != null) {
                Project project3 = psiDirectory2.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
                bl = jsTestFrameworkDetector.hasTestsUnderDirectory(project3, context2.getFile());
            } else {
                bl = false;
            }
            if (bl) {
                Object Settings3 = ((JsTestRunSettings)context2.getTemplateRunSettings()).builder().scope((Function1<JsTestRunScope.Builder, Unit>)((Function1)arg_0 -> ExtendedJsTestRunConfigurationProducer.tryBuildDirectorySettings$lambda$1(context2, arg_0))).build();
                VirtualFile virtualFile3 = context2.getFile();
                Project project4 = psiDirectory2.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
                pair = new Pair(this.fixWorkingDir(Settings3, virtualFile3, project4), (Object)psiDirectory2);
            } else {
                pair = null;
            }
        }
        return pair;
    }

    private final JsTestElementPath findContextSuiteOrTestPath(PsiElement element2) {
        AbstractTestFileStructure testsStructure;
        if (element2 instanceof PsiFileSystemItem) {
            return null;
        }
        PsiFile psiFile = element2.getContainingFile();
        JSFile jSFile = psiFile instanceof JSFile ? (JSFile)psiFile : null;
        if (jSFile == null) {
            return null;
        }
        JSFile jsFile = jSFile;
        TextRange textRange = element2.getTextRange();
        if (textRange == null) {
            return null;
        }
        TextRange textRange2 = textRange;
        JsTestFrameworkDetector jsTestFrameworkDetector = this.getTestFrameworkDetector();
        AbstractTestFileStructure abstractTestFileStructure = testsStructure = jsTestFrameworkDetector != null ? jsTestFrameworkDetector.findTestsStructure(jsFile) : null;
        return abstractTestFileStructure != null ? abstractTestFileStructure.findTestElementPath(textRange2) : null;
    }

    @Nullable
    public final Pair<Settings, PsiElement> tryBuildSuiteOrTestSettings(@NotNull Context<Settings> context2) {
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        JsTestElementPath jsTestElementPath = this.findContextSuiteOrTestPath(context2.getElement());
        if (jsTestElementPath == null) {
            return null;
        }
        JsTestElementPath testPath = jsTestElementPath;
        JsTestRunSettingsBuilder builder2 = ((JsTestRunSettings)context2.getTemplateRunSettings()).builder();
        JsTestRunScope.Builder builder3 = builder2.getScope().builder();
        String string = context2.getFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        builder2.setScope(builder3.testFilePath(string).build());
        String testName = testPath.getTestName();
        if (testName == null) {
            JsTestRunScope.Builder builder4 = builder2.getScope().builder().kind(JsTestRunScopeKind.SUITE);
            List<String> list = testPath.getSuiteNames();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getSuiteNames(...)");
            builder2.setScope(builder4.testNames(list).build());
        } else {
            JsTestRunScope.Builder builder5 = builder2.getScope().builder().kind(JsTestRunScopeKind.TEST);
            List<String> list = testPath.getSuiteNames();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getSuiteNames(...)");
            builder2.setScope(builder5.testNames(CollectionsKt.plus((Collection)list, (Object)testName)).build());
        }
        Object Settings2 = builder2.build();
        VirtualFile virtualFile = context2.getFile();
        Project project = testPath.getTestElement().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new Pair(this.fixWorkingDir(Settings2, virtualFile, project), (Object)testPath.getTestElement());
    }

    @Nullable
    public final Pair<Settings, PsiElement> tryBuildTestFileSettings(@NotNull Context<Settings> context2) {
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        PsiFile psiFile = context2.getPsiFile();
        JSFile jSFile = psiFile instanceof JSFile ? (JSFile)psiFile : null;
        if (jSFile == null) {
            return null;
        }
        JSFile jsFile = jSFile;
        JsTestFrameworkDetector jsTestFrameworkDetector = this.getTestFrameworkDetector();
        boolean bl = jsTestFrameworkDetector != null ? jsTestFrameworkDetector.hasTestsInFile(jsFile) : false;
        if (bl) {
            JsTestRunSettingsBuilder builder2 = ((JsTestRunSettings)context2.getTemplateRunSettings()).builder();
            JsTestRunScope.Builder builder3 = builder2.getScope().builder().kind(JsTestRunScopeKind.TEST_FILE);
            String string = context2.getFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            builder2.setScope(builder3.testFilePath(string).build());
            Object Settings2 = builder2.build();
            VirtualFile virtualFile = context2.getFile();
            Project project = ((JSFile)context2.getPsiFile()).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return new Pair(this.fixWorkingDir(Settings2, virtualFile, project), (Object)context2.getPsiFile());
        }
        return null;
    }

    private static final VirtualFile guessWorkingDir$lambda$0(ExtendedJsTestRunConfigurationProducer this$0, Ref $firstPackageJsonDir, AtomicBoolean $basedOnDeclaredDependency, Project $project, VirtualFile dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        VirtualFile defaultConfigFile = (VirtualFile)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this$0.configFileNames), arg_0 -> ExtendedJsTestRunConfigurationProducer.guessWorkingDir$lambda$0$0(dir, arg_0)), ExtendedJsTestRunConfigurationProducer::guessWorkingDir$lambda$0$1));
        if (defaultConfigFile != null) {
            return dir;
        }
        VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile(dir);
        if (packageJson != null) {
            $firstPackageJsonDir.setIfNull((Object)dir);
            PackageJsonData packageJsonData = PackageJsonData.getOrCreate(packageJson);
            Intrinsics.checkNotNullExpressionValue((Object)packageJsonData, (String)"getOrCreate(...)");
            PackageJsonData data2 = packageJsonData;
            JsTestFrameworkDetector detector = this$0.getTestFrameworkDetector();
            Object object = detector;
            boolean bl = object != null && (object = object.getPackageDescriptor()) != null ? ((JsTestFrameworkPackageDescriptor)object).isFrameworkDeclaredInPackageJson(data2) : false;
            if (bl) {
                $basedOnDeclaredDependency.set(true);
                return dir;
            }
            if (JsTestRunConfigurationProducer.Companion.hasTestScript($project, packageJson, data2)) {
                return dir;
            }
        }
        return null;
    }

    private static final VirtualFile guessWorkingDir$lambda$0$0(VirtualFile $dir, String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return $dir.findChild(name);
    }

    private static final boolean guessWorkingDir$lambda$0$1(VirtualFile file) {
        return file != null && !file.isDirectory();
    }

    private static final VirtualFile guessWorkingDir$lambda$1(Function1 $tmp0, Object p0) {
        return (VirtualFile)$tmp0.invoke(p0);
    }

    private static final Unit tryBuildDirectorySettings$lambda$0(JsTestRunScope.Builder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.kind(JsTestRunScopeKind.ALL);
        return Unit.INSTANCE;
    }

    private static final Unit tryBuildDirectorySettings$lambda$1(Context $context, JsTestRunScope.Builder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.kind(JsTestRunScopeKind.DIRECTORY);
        String string = $context.getFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        it.testDirectoryPath(string);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u000e\b\u0002\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B)\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00028\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\tH\u00c6\u0003J\u000e\u0010\u0019\u001a\u00028\u0002H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0014J>\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00028\u0002H\u00c6\u0001\u00a2\u0006\u0002\u0010\u001bJ\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\n\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006#"}, d2={"Lcom/intellij/aqua/runners/js/core/ExtendedJsTestRunConfigurationProducer$Context;", "Settings", "Lcom/intellij/aqua/runners/js/core/JsTestRunSettings;", "", "element", "Lcom/intellij/psi/PsiElement;", "psiFile", "Lcom/intellij/psi/PsiFile;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "templateRunSettings", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/aqua/runners/js/core/JsTestRunSettings;)V", "getElement", "()Lcom/intellij/psi/PsiElement;", "getPsiFile", "()Lcom/intellij/psi/PsiFile;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getTemplateRunSettings", "()Lcom/intellij/aqua/runners/js/core/JsTestRunSettings;", "Lcom/intellij/aqua/runners/js/core/JsTestRunSettings;", "component1", "component2", "component3", "component4", "copy", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/aqua/runners/js/core/JsTestRunSettings;)Lcom/intellij/aqua/runners/js/core/ExtendedJsTestRunConfigurationProducer$Context;", "equals", "", "other", "hashCode", "", "toString", "", "intellij.aqua.runners.js.core"})
    public static final class Context<Settings extends JsTestRunSettings<Settings>> {
        @NotNull
        private final PsiElement element;
        @Nullable
        private final PsiFile psiFile;
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final Settings templateRunSettings;

        public Context(@NotNull PsiElement element2, @Nullable PsiFile psiFile, @NotNull VirtualFile file, @NotNull Settings templateRunSettings) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter(templateRunSettings, (String)"templateRunSettings");
            this.element = element2;
            this.psiFile = psiFile;
            this.file = file;
            this.templateRunSettings = templateRunSettings;
        }

        @NotNull
        public final PsiElement getElement() {
            return this.element;
        }

        @Nullable
        public final PsiFile getPsiFile() {
            return this.psiFile;
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        @NotNull
        public final Settings getTemplateRunSettings() {
            return this.templateRunSettings;
        }

        @NotNull
        public final PsiElement component1() {
            return this.element;
        }

        @Nullable
        public final PsiFile component2() {
            return this.psiFile;
        }

        @NotNull
        public final VirtualFile component3() {
            return this.file;
        }

        @NotNull
        public final Settings component4() {
            return this.templateRunSettings;
        }

        @NotNull
        public final Context<Settings> copy(@NotNull PsiElement element2, @Nullable PsiFile psiFile, @NotNull VirtualFile file, @NotNull Settings templateRunSettings) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter(templateRunSettings, (String)"templateRunSettings");
            return new Context<Settings>(element2, psiFile, file, templateRunSettings);
        }

        public static /* synthetic */ Context copy$default(Context context2, PsiElement psiElement, PsiFile psiFile, VirtualFile virtualFile, JsTestRunSettings jsTestRunSettings, int n, Object object) {
            if ((n & 1) != 0) {
                psiElement = context2.element;
            }
            if ((n & 2) != 0) {
                psiFile = context2.psiFile;
            }
            if ((n & 4) != 0) {
                virtualFile = context2.file;
            }
            if ((n & 8) != 0) {
                jsTestRunSettings = context2.templateRunSettings;
            }
            return context2.copy(psiElement, psiFile, virtualFile, jsTestRunSettings);
        }

        @NotNull
        public String toString() {
            return "Context(element=" + this.element + ", psiFile=" + this.psiFile + ", file=" + this.file + ", templateRunSettings=" + this.templateRunSettings + ")";
        }

        public int hashCode() {
            int result2 = this.element.hashCode();
            result2 = result2 * 31 + (this.psiFile == null ? 0 : this.psiFile.hashCode());
            result2 = result2 * 31 + this.file.hashCode();
            result2 = result2 * 31 + this.templateRunSettings.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Context)) {
                return false;
            }
            Context context2 = (Context)other;
            if (!Intrinsics.areEqual((Object)this.element, (Object)context2.element)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.psiFile, (Object)context2.psiFile)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.file, (Object)context2.file)) {
                return false;
            }
            return Intrinsics.areEqual(this.templateRunSettings, context2.templateRunSettings);
        }
    }
}

