/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.types.TypeFromUsageDetector;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSExprTypePredicate
extends MatchPredicate {
    private final List<String> myTypes;
    private final boolean myHierarchy;
    private final boolean myCaseSensitive;

    public JSExprTypePredicate(String type2, boolean hierarchy, boolean caseSensitive) {
        this.myTypes = StringUtil.split((String)type2, (String)"|");
        this.myHierarchy = hierarchy;
        this.myCaseSensitive = caseSensitive;
    }

    public boolean match(@NotNull PsiElement matchedNode, int start, int end, @NotNull MatchContext context2) {
        JSType type2;
        if (matchedNode == null) {
            JSExprTypePredicate.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            JSExprTypePredicate.$$$reportNull$$$0(1);
        }
        if ((matchedNode = StructuralSearchUtil.getParentIfIdentifier((PsiElement)matchedNode)) instanceof JSExpression) {
            type2 = JSResolveUtil.getExpressionJSType((JSExpression)((JSExpression)matchedNode));
        } else if (matchedNode instanceof JSFunction) {
            JSFunction function = (JSFunction)matchedNode;
            JSType returnType2 = function.getReturnType();
            type2 = returnType2 == null ? TypeFromUsageDetector.detectTypeFromUsage((PsiElement)matchedNode) : returnType2;
        } else if (matchedNode instanceof JSVariable) {
            JSVariable variable = (JSVariable)matchedNode;
            JSType varType = variable.getJSType();
            type2 = varType == null ? TypeFromUsageDetector.detectTypeFromUsage((PsiElement)matchedNode) : varType;
        } else {
            return false;
        }
        if (this.myHierarchy && type2 instanceof JSResolvableType) {
            JSClassUtils.JSClassHierarchyProcessor processor = (aClass1, typeSubstitutor, fromImplements, fromStaticContext, depth) -> !this.doMatch(aClass1.getStaticJSType());
            if (DialectDetector.isActionScript((PsiElement)matchedNode)) {
                JSClass aClass = type2.resolveClass();
                return aClass != null && !JSClassUtils.processClassesInHierarchy((JSClass)aClass, (boolean)true, (JSClassUtils.JSClassHierarchyProcessor)processor);
            }
            JSResolvableType resolvableType = (JSResolvableType)type2;
            JSResolvedTypeInfo resolvedTypeInfo = resolvableType.resolveType();
            Collection classes = resolvedTypeInfo.getDeclarationsOfType(JSClass.class);
            for (JSClass aClass : classes) {
                if (JSClassUtils.processClassesInHierarchy((JSClass)aClass, (boolean)true, (JSClassUtils.JSClassHierarchyProcessor)processor)) continue;
                return true;
            }
            return false;
        }
        return this.doMatch(type2);
    }

    private boolean doMatch(JSType type2) {
        if (type2 == null) {
            return false;
        }
        String text = type2.getResolvedTypeText();
        return this.myTypes.stream().anyMatch(t -> this.myCaseSensitive ? t.equals(text) : t.equalsIgnoreCase(text));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "matchedNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "com/intellij/structuralsearch/JSExprTypePredicate";
        objectArray[2] = "match";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

