/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.command.SearchImagesCmd;
import com.github.dockerjava.api.model.SearchItem;
import com.github.dockerjava.core.command.AbstrDockerCmd;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SearchImagesCmdImpl
extends AbstrDockerCmd<SearchImagesCmd, List<SearchItem>>
implements SearchImagesCmd {
    private static final int MIN_LIMIT = 1;
    private static final int MAX_LIMIT = 100;
    private String term;
    private Integer limit;

    public SearchImagesCmdImpl(SearchImagesCmd.Exec exec, String term) {
        super(exec);
        this.withTerm(term);
    }

    public String getTerm() {
        return this.term;
    }

    public SearchImagesCmd withTerm(String term) {
        this.term = Objects.requireNonNull(term, "term was not specified");
        return this;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public SearchImagesCmd withLimit(@Nonnull Integer limit) {
        String errorMessage = String.format("Limit %s is outside the range of [%s, %s]", limit, 1, 100);
        Preconditions.checkArgument((limit <= 100 ? 1 : 0) != 0, (Object)errorMessage);
        Preconditions.checkArgument((limit >= 1 ? 1 : 0) != 0, (Object)errorMessage);
        this.limit = limit;
        return this;
    }
}

