/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.debugger.agent;

import com.intellij.rt.debugger.agent.CaptureAgent;
import com.intellij.rt.debugger.agent.ClassTransformer;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import org.jetbrains.capture.org.objectweb.asm.ClassVisitor;
import org.jetbrains.capture.org.objectweb.asm.MethodVisitor;

class ThrowableTransformer
implements ClassFileTransformer {
    static final String THROWABLE_NAME = CaptureAgent.getInternalClsName(Throwable.class);

    ThrowableTransformer() {
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        if (THROWABLE_NAME.equals(className)) {
            try {
                ClassTransformer transformer = new ClassTransformer(className, classfileBuffer, 2, loader);
                return transformer.accept(new ClassVisitor(589824, transformer.writer){

                    @Override
                    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                        MethodVisitor superMethodVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
                        switch (name) {
                            case "<init>": {
                                return new MethodVisitor(this.api, superMethodVisitor){

                                    @Override
                                    public void visitInsn(int opcode) {
                                        if (opcode == 177) {
                                            this.mv.visitVarInsn(25, 0);
                                            CaptureAgent.invokeStorageMethod(this.mv, "captureThrowable");
                                        }
                                        super.visitInsn(opcode);
                                    }
                                };
                            }
                            case "printStackTrace": 
                            case "lockedPrintStackTrace": 
                            case "printEnclosedStackTrace": {
                                return new MethodVisitor(this.api, superMethodVisitor){

                                    @Override
                                    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                                        if (name.equals("getOurStackTrace")) {
                                            CaptureAgent.invokeStorageMethod(this.mv, "getAsyncStackTrace");
                                        } else {
                                            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
                                        }
                                    }
                                };
                            }
                        }
                        return superMethodVisitor;
                    }
                }, 0, true);
            }
            catch (Exception e) {
                System.out.println("Capture agent: failed to instrument " + className);
                e.printStackTrace();
            }
        }
        return null;
    }
}

