/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.redis;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanEffectiveTypeProvider;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class SpringDataRedisEffectiveTypeProvider
extends SpringBeanEffectiveTypeProvider {
    private static final String[] redisTemplateMethods = new String[]{"opsForValue", "opsForList", "opsForHash", "opsForSet", "opsForCluster", "opsForGeo", "opsForZSet", "opsForHyperLogLog"};

    public boolean processEffectiveTypes(@NotNull CommonSpringBean bean, @NotNull Processor<PsiType> processor) {
        PsiClass psiClass;
        PsiType beanType;
        if (bean == null) {
            SpringDataRedisEffectiveTypeProvider.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            SpringDataRedisEffectiveTypeProvider.$$$reportNull$$$0(1);
        }
        if ((beanType = bean.getBeanType()) instanceof PsiClassType && (psiClass = ((PsiClassType)beanType).resolve()) != null && (SpringDataRedisEffectiveTypeProvider.isRedisTemplateClass(psiClass.getQualifiedName()) || SpringDataRedisEffectiveTypeProvider.isReactiveRedisTemplateClass(psiClass.getQualifiedName()))) {
            for (String method : redisTemplateMethods) {
                PsiMethod[] byName = psiClass.findMethodsByName(method, false);
                if (byName.length <= 0 || processor.process((Object)byName[0].getReturnType())) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isRedisTemplateClass(String qualifiedName) {
        return "org.springframework.data.redis.core.RedisTemplate".equals(qualifiedName) || "org.springframework.data.redis.core.StringRedisTemplate".equals(qualifiedName);
    }

    private static boolean isReactiveRedisTemplateClass(String qualifiedName) {
        return "org.springframework.data.redis.core.ReactiveRedisTemplate".equals(qualifiedName) || "org.springframework.data.redis.core.ReactiveStringRedisTemplate".equals(qualifiedName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "bean";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "processor";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/data/redis/SpringDataRedisEffectiveTypeProvider";
        objectArray[2] = "processEffectiveTypes";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

