/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.api;

import com.intellij.kubernetes.api.ClusterLogPublisher;
import com.intellij.kubernetes.api.Context;
import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.api.KubernetesApiProvider;
import com.intellij.kubernetes.api.LogHandlerPublisher;
import com.intellij.kubernetes.api.execution.ExecutionFlowParametersBuilder;
import com.intellij.kubernetes.api.execution.ExecutionFlowParametersBuilderKt;
import com.intellij.kubernetes.api.settings.KubernetesApiGlobalSettings;
import com.intellij.kubernetes.api.settings.KubernetesApiProjectSettings;
import com.intellij.kubernetes.wsl.WslOrNativePathKt;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u001a\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007\u001a \u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e\u001a\f\u0010\u0013\u001a\u00020\u0004*\u00020\u0004H\u0002\u001a\f\u0010\u0014\u001a\u00020\u0004*\u00020\u0004H\u0002\u001a\f\u0010\u0015\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\u001c\u0010\u0016\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\u0019\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0004H\u0002\u001a\u001c\u0010\u001a\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000eH\u0007\u001a\u0014\u0010\u001d\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u001a\u000e\u0010 \u001a\u0004\u0018\u00010\u0004*\u00020\u0004H\u0002\"\u0015\u0010\u000f\u001a\u00020\u00108\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006!"}, d2={"fillSpecifyingContextParameters", "", "Lcom/intellij/kubernetes/api/execution/ExecutionFlowParametersBuilder;", "kubeconfigPath", "", "contextName", "getDefaultShellBinPath", "project", "Lcom/intellij/openapi/project/Project;", "logPublisher", "Lcom/intellij/kubernetes/api/ClusterLogPublisher;", "context", "Lcom/intellij/kubernetes/api/Context;", "interceptFoxus", "", "apiGlobalSettings", "Lcom/intellij/kubernetes/api/settings/KubernetesApiGlobalSettings;", "getApiGlobalSettings", "()Lcom/intellij/kubernetes/api/settings/KubernetesApiGlobalSettings;", "toNamespaceParameter", "toOutputParameter", "addFollowParameter", "addPodContainerParameters", "name", "container", "addDeploymentParameters", "addConsoleParameters", "stdin", "tty", "addFilenameParameter", "path", "Ljava/nio/file/Path;", "nullIfAllNamespaces", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubectlExecutorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubectlExecutorImpl.kt\ncom/intellij/kubernetes/api/KubectlExecutorImplKt\n*L\n1#1,637:1\n602#1:638\n602#1:639\n*S KotlinDebug\n*F\n+ 1 KubectlExecutorImpl.kt\ncom/intellij/kubernetes/api/KubectlExecutorImplKt\n*L\n592#1:638\n629#1:639\n*E\n"})
public final class KubectlExecutorImplKt {
    @ApiStatus.Internal
    public static final void fillSpecifyingContextParameters(@NotNull ExecutionFlowParametersBuilder $this$fillSpecifyingContextParameters, @NotNull String kubeconfigPath, @NotNull String contextName) {
        Intrinsics.checkNotNullParameter((Object)$this$fillSpecifyingContextParameters, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)kubeconfigPath, (String)"kubeconfigPath");
        Intrinsics.checkNotNullParameter((Object)contextName, (String)"contextName");
        String[] stringArray = new String[]{"--kubeconfig", kubeconfigPath};
        ExecutionFlowParametersBuilderKt.addParameters($this$fillSpecifyingContextParameters, stringArray);
        stringArray = new String[]{"--context", contextName};
        ExecutionFlowParametersBuilderKt.addParameters($this$fillSpecifyingContextParameters, stringArray);
    }

    @ApiStatus.Internal
    @NotNull
    public static final String getDefaultShellBinPath(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = KubernetesApiProjectSettings.Companion.getInstance(project).getShellCommand();
        if (string == null) {
            boolean $i$f$getApiGlobalSettings = false;
            string = KubernetesApiGlobalSettings.Companion.getInstance().getShellCommand();
            if (string == null) {
                string = "/bin/sh";
            }
        }
        return string;
    }

    @NotNull
    public static final ClusterLogPublisher logPublisher(@NotNull Project project, @NotNull Context context, boolean interceptFoxus) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        KubernetesApiModelInterface kubernetesApiModelInterface = KubernetesApiProvider.Companion.getInstance(project).findModel(context);
        if (kubernetesApiModelInterface == null) {
            return new ClusterLogPublisher();
        }
        KubernetesApiModelInterface apiModel2 = kubernetesApiModelInterface;
        return new LogHandlerPublisher(apiModel2, interceptFoxus);
    }

    public static /* synthetic */ ClusterLogPublisher logPublisher$default(Project project, Context context, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return KubectlExecutorImplKt.logPublisher(project, context, bl);
    }

    private static final KubernetesApiGlobalSettings getApiGlobalSettings() {
        boolean $i$f$getApiGlobalSettings = false;
        return KubernetesApiGlobalSettings.Companion.getInstance();
    }

    private static final String toNamespaceParameter(String $this$toNamespaceParameter) {
        return Intrinsics.areEqual((Object)$this$toNamespaceParameter, (Object)"Kubernetes.All.Namespaces.Label") ? "--all-namespaces" : "--namespace=" + $this$toNamespaceParameter;
    }

    private static final String toOutputParameter(String $this$toOutputParameter) {
        return "--output=" + $this$toOutputParameter;
    }

    private static final void addFollowParameter(ExecutionFlowParametersBuilder $this$addFollowParameter) {
        ExecutionFlowParametersBuilderKt.addParameter($this$addFollowParameter, "--follow=true");
    }

    private static final void addPodContainerParameters(ExecutionFlowParametersBuilder $this$addPodContainerParameters, String name, String container) {
        String[] stringArray = new String[]{name, "--container=" + container};
        ExecutionFlowParametersBuilderKt.addParameters($this$addPodContainerParameters, stringArray);
    }

    private static final void addDeploymentParameters(ExecutionFlowParametersBuilder $this$addDeploymentParameters, String name) {
        String[] stringArray = new String[]{"deployments/" + name};
        ExecutionFlowParametersBuilderKt.addParameters($this$addDeploymentParameters, stringArray);
    }

    @ApiStatus.Internal
    public static final void addConsoleParameters(@NotNull ExecutionFlowParametersBuilder $this$addConsoleParameters, boolean stdin, boolean tty) {
        Intrinsics.checkNotNullParameter((Object)$this$addConsoleParameters, (String)"<this>");
        String[] stringArray = new String[]{"--stdin=" + stdin, "--tty=" + tty};
        ExecutionFlowParametersBuilderKt.addParameters($this$addConsoleParameters, stringArray);
    }

    private static final void addFilenameParameter(ExecutionFlowParametersBuilder $this$addFilenameParameter, Path path) {
        String[] stringArray = new String[2];
        stringArray[0] = "--filename";
        boolean $i$f$getApiGlobalSettings = false;
        stringArray[1] = WslOrNativePathKt.getPathForFile(KubernetesApiGlobalSettings.Companion.getInstance().getKubectlPath(), path);
        ExecutionFlowParametersBuilderKt.addParameters($this$addFilenameParameter, stringArray);
    }

    private static final String nullIfAllNamespaces(String $this$nullIfAllNamespaces) {
        return Intrinsics.areEqual((Object)$this$nullIfAllNamespaces, (Object)"Kubernetes.All.Namespaces.Label") ? null : $this$nullIfAllNamespaces;
    }

    public static final /* synthetic */ String access$nullIfAllNamespaces(String $receiver) {
        return KubectlExecutorImplKt.nullIfAllNamespaces($receiver);
    }

    public static final /* synthetic */ String access$toOutputParameter(String $receiver) {
        return KubectlExecutorImplKt.toOutputParameter($receiver);
    }

    public static final /* synthetic */ String access$toNamespaceParameter(String $receiver) {
        return KubectlExecutorImplKt.toNamespaceParameter($receiver);
    }

    public static final /* synthetic */ void access$addPodContainerParameters(ExecutionFlowParametersBuilder $receiver, String name, String container) {
        KubectlExecutorImplKt.addPodContainerParameters($receiver, name, container);
    }

    public static final /* synthetic */ void access$addFollowParameter(ExecutionFlowParametersBuilder $receiver) {
        KubectlExecutorImplKt.addFollowParameter($receiver);
    }

    public static final /* synthetic */ void access$addDeploymentParameters(ExecutionFlowParametersBuilder $receiver, String name) {
        KubectlExecutorImplKt.addDeploymentParameters($receiver, name);
    }

    public static final /* synthetic */ void access$addFilenameParameter(ExecutionFlowParametersBuilder $receiver, Path path) {
        KubectlExecutorImplKt.addFilenameParameter($receiver, path);
    }
}

