/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.mvc.actions;

import com.intellij.codeInsight.navigation.impl.PsiTargetPresentationRenderer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.spring.model.utils.SpringFunctionalSearchersUtils;
import com.intellij.spring.security.SpringSecurityIcons;
import com.intellij.spring.security.references.SpringSecurityPatterns;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

class SpringSecurityMatcherCellRenderer
extends PsiTargetPresentationRenderer<PsiElement> {
    SpringSecurityMatcherCellRenderer() {
    }

    protected Icon getIcon(@NotNull PsiElement element) {
        if (element == null) {
            SpringSecurityMatcherCellRenderer.$$$reportNull$$$0(0);
        }
        return SpringSecurityIcons.SpringSecurity;
    }

    @NotNull
    public String getElementText(@NotNull PsiElement element) {
        UCallExpression uCallExpression;
        UElement uElement;
        if (element == null) {
            SpringSecurityMatcherCellRenderer.$$$reportNull$$$0(1);
        }
        if ((uElement = UastContextKt.toUElement((PsiElement)element)) != null && (uCallExpression = (UCallExpression)UastUtils.getParentOfType((UElement)uElement, UCallExpression.class)) != null) {
            return SpringSecurityMatcherCellRenderer.trimElementText(uCallExpression.asRenderString());
        }
        if (element instanceof XmlAttribute) {
            return SpringSecurityMatcherCellRenderer.trimElementText(element.getText());
        }
        return SpringSecurityMatcherCellRenderer.trimElementText(super.getElementText(element));
    }

    public String getContainerText(@NotNull PsiElement element) {
        UCallExpression uCallExpression;
        UElement uElement;
        if (element == null) {
            SpringSecurityMatcherCellRenderer.$$$reportNull$$$0(2);
        }
        if ((uElement = UastContextKt.toUElement((PsiElement)element)) != null && (uCallExpression = (UCallExpression)UastUtils.getParentOfType((UElement)uElement, UCallExpression.class)) != null) {
            if (SpringSecurityPatterns.MVC_REQUEST_MATCHER_BUILDER_EXPRESSION.accepts((Object)uCallExpression) || SpringSecurityPatterns.ANT_PATH_REQUEST_MATCHER_EXPRESSION.accepts((Object)uCallExpression) || SpringSecurityPatterns.REGEX_PATH_REQUEST_MATCHER_EXPRESSION.accepts((Object)uCallExpression)) {
                UCallExpression requestExpression = (UCallExpression)UastUtils.getParentOfType((UElement)uCallExpression, UCallExpression.class);
                if (requestExpression != null && SpringSecurityPatterns.REQUEST_MATCHERS_EXPRESSION.accepts((Object)requestExpression)) {
                    return SpringSecurityMatcherCellRenderer.getNextCallInChainAsText(requestExpression);
                }
            } else {
                return SpringSecurityMatcherCellRenderer.getNextCallInChainAsText(uCallExpression);
            }
        }
        return null;
    }

    @NlsSafe
    @Nullable
    private static String getNextCallInChainAsText(UCallExpression uCallExpression) {
        UCallExpression nextCallInChain = SpringFunctionalSearchersUtils.getNextCallInChain((UExpression)uCallExpression);
        if (nextCallInChain != null) {
            return SpringSecurityMatcherCellRenderer.trimContainerText(nextCallInChain.asRenderString()) + " ";
        }
        return null;
    }

    @NlsSafe
    @NotNull
    private static String trimElementText(@NotNull String text) {
        if (text == null) {
            SpringSecurityMatcherCellRenderer.$$$reportNull$$$0(3);
        }
        return SpringSecurityMatcherCellRenderer.trimText(text, 50);
    }

    @NotNull
    private static String trimContainerText(@NotNull String text) {
        if (text == null) {
            SpringSecurityMatcherCellRenderer.$$$reportNull$$$0(4);
        }
        return SpringSecurityMatcherCellRenderer.trimText(text, 40);
    }

    @NotNull
    private static String trimText(@NotNull String text, int maxLength) {
        int length;
        if (text == null) {
            SpringSecurityMatcherCellRenderer.$$$reportNull$$$0(5);
        }
        if (maxLength > (length = text.length()) || maxLength < 5) {
            String string = text;
            if (string == null) {
                SpringSecurityMatcherCellRenderer.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = text.substring(0, maxLength - 4) + " ..)";
        if (string == null) {
            SpringSecurityMatcherCellRenderer.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/security/mvc/actions/SpringSecurityMatcherCellRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/security/mvc/actions/SpringSecurityMatcherCellRenderer";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "trimText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getElementText";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getContainerText";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "trimElementText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "trimContainerText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "trimText";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }
}

