/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions.createproject;

import com.intellij.DynamicBundle;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.wizard.AbstractWizardStepEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HoverHyperlinkLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.createproject.BaseStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.ChooseRemotePathStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.ChooseServerStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.CreateProjectModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseWebPathStep
extends BaseStep {
    public static final Object ID = ChooseWebPathStep.class;
    private JTextField myUrlField;
    private JPanel myContentPane;
    private HoverHyperlinkLabel myCompleteUrlLabel;
    private JLabel myWebPathLabel;
    private JPanel myExtensionPanel;

    public ChooseWebPathStep(CreateProjectModel model) {
        super(WDBundle.message("create.web.project.choose.web.path.step.title", new Object[0]), model);
        this.$$$setupUI$$$();
        this.myUrlField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ChooseWebPathStep.this.updateCompleteUrl();
                ChooseWebPathStep.this.fireStateChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/webDeployment/actions/createproject/ChooseWebPathStep$1", "textChanged"));
            }
        });
        this.myCompleteUrlLabel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                BrowserUtil.browse((String)ChooseWebPathStep.this.myCompleteUrlLabel.getOriginalText());
            }
        });
    }

    private void updateCompleteUrl() {
        this.myCompleteUrlLabel.setText(DeploymentPathUtils.join(this.myModel.getServer().getUrl(), this.myUrlField.getText()));
    }

    @NotNull
    public Object getStepId() {
        Object object = ID;
        if (object == null) {
            ChooseWebPathStep.$$$reportNull$$$0(0);
        }
        return object;
    }

    public Object getNextStepId() {
        return null;
    }

    public Object getPreviousStepId() {
        if (this.myModel.scenario == CreateProjectModel.Scenario.LocalServer) {
            return ChooseServerStep.ID;
        }
        return ChooseRemotePathStep.ID;
    }

    public boolean isComplete() {
        return true;
    }

    @Override
    public void doInit() {
        String path = this.myModel.scenario == CreateProjectModel.Scenario.LocalServer ? this.myModel.localPath : this.myModel.getServer().getPresentablePath(this.myModel.getServerPath());
        this.myWebPathLabel.setText(WDBundle.message("web.path.label.text", path));
        String webPath = this.myModel.webPath;
        if (StringUtil.isEmpty((String)webPath)) {
            webPath = ChooseWebPathStep.guessWebPath(path, this.myModel.getServer().getUrl());
        }
        this.myUrlField.setText(webPath);
        this.myUrlField.selectAll();
        this.updateCompleteUrl();
    }

    @Nullable
    private static String guessWebPath(String path, String serverUrl) {
        Object[] pathTokens = FileUtil.toSystemIndependentName((String)path).split("/");
        if (pathTokens.length == 1) {
            return null;
        }
        int index = ArrayUtil.indexOf((Object[])pathTokens, (Object)"htdocs");
        if (index == -1) {
            return null;
        }
        String trimmedUrl = StringUtil.trimStart((String)serverUrl, (String)"http://");
        trimmedUrl = StringUtil.trimStart((String)trimmedUrl, (String)"https://");
        String[] serverUrlTokens = trimmedUrl.split("/");
        for (int j = 1; index + j < pathTokens.length && j < serverUrlTokens.length && ((String)pathTokens[index + j]).equals(serverUrlTokens[serverUrlTokens.length - j]); ++j) {
        }
        StringBuilder result = new StringBuilder();
        for (int i = index + j; i < pathTokens.length; ++i) {
            if (i > index + 1) {
                result.append('/');
            }
            result.append((String)pathTokens[i]);
        }
        return result.toString();
    }

    public void commit(AbstractWizardStepEx.CommitType commitType) {
        if (commitType == AbstractWizardStepEx.CommitType.Prev) {
            return;
        }
        this.myModel.webPath = this.myUrlField.getText();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myUrlField;
    }

    @Override
    public JComponent getInnerComponent() {
        return this.myContentPane;
    }

    private void createUIComponents() {
        this.myCompleteUrlLabel = new HoverHyperlinkLabel(null);
    }

    public JPanel getExtensionPanel() {
        return this.myExtensionPanel;
    }

    public String getHelpId() {
        return this.myModel.scenario == CreateProjectModel.Scenario.LocalServer ? "reference.dialogs.new.project.from.existing.files.specify.web.path.local" : "reference.dialogs.new.project.from.existing.files.specify.web.path.remote";
    }

    @Override
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getSummaryText() {
        String string = WDBundle.message("create.web.project.choose.web.path.step.summary", new Object[0]);
        if (string == null) {
            ChooseWebPathStep.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/plugins/webDeployment/actions/createproject/ChooseWebPathStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStepId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSummaryText";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JTextField jTextField;
        JLabel jLabel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myContentPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), 0, -1, false, false));
        this.myWebPathLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/WDBundle", ChooseWebPathStep.class).getString("choose.web.path.step.web.path"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUrlField = jTextField = new JTextField();
        jTextField.setText("");
        jPanel2.add((Component)jTextField, new GridConstraints(1, 0, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(5, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/WDBundle", ChooseWebPathStep.class).getString("shoose.web.path.step.project.url"));
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        HoverHyperlinkLabel hoverHyperlinkLabel = this.myCompleteUrlLabel;
        this.$$$loadLabelText$$$((JLabel)hoverHyperlinkLabel, DynamicBundle.getBundle((String)"messages/WDBundle", ChooseWebPathStep.class).getString("choose.web.path.step.url.preview"));
        jPanel3.add((Component)hoverHyperlinkLabel, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 3, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel3.add((Component)spacer4, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 1, null, new Dimension(5, -1), null));
        this.myExtensionPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel2.add((Component)spacer5, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

