/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.thinclient.terminal;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.concurrency.Semaphore;
import com.jetbrains.codeWithMe.model.RdTerminalSession;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/thinclient/terminal/ThinClientTerminalInputStream;", "Ljava/io/InputStream;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "model", "Lcom/jetbrains/codeWithMe/model/RdTerminalSession;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/codeWithMe/model/RdTerminalSession;)V", "buffer", "Ljava/util/ArrayDeque;", "", "semaphore", "Lcom/intellij/util/concurrency/Semaphore;", "read", "", "b", "", "off", "len", "waitData", "", "intellij.terminal.frontend.split"})
public final class ThinClientTerminalInputStream
extends InputStream {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final ArrayDeque<Byte> buffer;
    @NotNull
    private final Semaphore semaphore;

    public ThinClientTerminalInputStream(@NotNull Lifetime lifetime, @NotNull RdTerminalSession model) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.lifetime = lifetime;
        this.buffer = new ArrayDeque(1000);
        this.semaphore = new Semaphore();
        model.getOutput().advise(this.lifetime, arg_0 -> ThinClientTerminalInputStream._init_$lambda$0(this, arg_0));
        model.getOutputConnected().set((Object)true);
        this.lifetime.onTermination(() -> ThinClientTerminalInputStream._init_$lambda$1(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() {
        this.waitData();
        ArrayDeque<Byte> arrayDeque = this.buffer;
        synchronized (arrayDeque) {
            boolean bl = false;
            byte by = ((Number)this.buffer.removeFirst()).byteValue();
            return by;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.waitData();
        ArrayDeque<Byte> arrayDeque = this.buffer;
        synchronized (arrayDeque) {
            int index;
            boolean bl = false;
            for (index = 0; this.buffer.size() > 0 && index < len; ++index) {
                byte bb;
                Byte by = this.buffer.removeFirst();
                if (by == null) {
                    break;
                }
                b[off + index] = bb = by.byteValue();
            }
            int n = index > 0 ? index : -1;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void waitData() {
        ArrayDeque<Byte> arrayDeque;
        if (RLifetimeKt.isNotAlive((Lifetime)this.lifetime)) {
            return;
        }
        ArrayDeque<Byte> arrayDeque2 = arrayDeque = this.buffer;
        synchronized (arrayDeque2) {
            boolean bl = false;
            if (this.buffer.size() > 0) {
                return;
            }
            Unit unit = Unit.INSTANCE;
        }
        try {
            this.semaphore.down();
            this.semaphore.waitFor();
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit _init_$lambda$0(ThinClientTerminalInputStream this$0, List bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        if (bytes.isEmpty()) {
            return Unit.INSTANCE;
        }
        ArrayDeque<Byte> arrayDeque = this$0.buffer;
        synchronized (arrayDeque) {
            boolean bl = false;
            Iterator iterator = bytes.iterator();
            while (iterator.hasNext()) {
                byte b = ((Number)iterator.next()).byteValue();
                this$0.buffer.addLast(b);
            }
            Unit unit = Unit.INSTANCE;
        }
        this$0.semaphore.up();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(ThinClientTerminalInputStream this$0) {
        this$0.semaphore.up();
        return Unit.INSTANCE;
    }
}

