/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.java;

import org.jetbrains.jps.dependency.Node;
import org.jetbrains.jps.dependency.java.JvmClass;
import org.jetbrains.jps.dependency.java.JvmNodeReferenceID;
import org.jetbrains.jps.dependency.java.PackageConstraint;
import org.jetbrains.jps.dependency.java.Utils;

public final class InheritanceConstraint
extends PackageConstraint {
    private final Utils myUtils;
    private final JvmNodeReferenceID myRootClass;

    public InheritanceConstraint(Utils utils, JvmClass rootClass) {
        super(rootClass.getPackageName());
        this.myRootClass = rootClass.getReferenceID();
        this.myUtils = utils;
    }

    @Override
    public boolean test(Node<?, ?> node) {
        if (!super.test(node)) {
            return false;
        }
        if (node instanceof JvmClass) {
            for (JvmNodeReferenceID s : this.myUtils.allSupertypes(((JvmClass)node).getReferenceID())) {
                if (!this.myRootClass.equals(s)) continue;
                return false;
            }
        }
        return true;
    }
}

