/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.validations;

import com.intellij.json.JsonBundle;
import com.jetbrains.jsonSchema.extension.JsonAnnotationsCollectionMode;
import com.jetbrains.jsonSchema.extension.JsonErrorPriority;
import com.jetbrains.jsonSchema.extension.JsonSchemaValidation;
import com.jetbrains.jsonSchema.extension.JsonValidationHost;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.fus.JsonSchemaFusCountedFeature;
import com.jetbrains.jsonSchema.fus.JsonSchemaHighlightingSessionStatisticsCollector;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.MatchResult;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NotValidation
implements JsonSchemaValidation {
    public static final NotValidation INSTANCE = new NotValidation();

    @Override
    public boolean validate(@NotNull JsonValueAdapter propValue, @NotNull JsonSchemaObject schema, @Nullable JsonSchemaType schemaType, @NotNull JsonValidationHost consumer, @NotNull JsonComplianceCheckerOptions options) {
        if (propValue == null) {
            NotValidation.$$$reportNull$$$0(0);
        }
        if (schema == null) {
            NotValidation.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            NotValidation.$$$reportNull$$$0(2);
        }
        if (options == null) {
            NotValidation.$$$reportNull$$$0(3);
        }
        JsonSchemaHighlightingSessionStatisticsCollector.getInstance().reportSchemaUsageFeature(JsonSchemaFusCountedFeature.NotValidation);
        MatchResult result = consumer.resolve(schema.getNot(), propValue);
        if (result.mySchemas.isEmpty() && result.myExcludingSchemas.isEmpty()) {
            return true;
        }
        if (result.mySchemas.stream().anyMatch(s -> schema.equals(s)) || result.myExcludingSchemas.stream().flatMap(Collection::stream).anyMatch(s -> schema.equals(s))) {
            return true;
        }
        JsonValidationHost checker = consumer.checkByMatchResult(propValue, result, new JsonComplianceCheckerOptions(options.isCaseInsensitiveEnumCheck(), true, false, JsonAnnotationsCollectionMode.FIND_FIRST));
        if (checker == null || checker.isValid()) {
            consumer.error(JsonBundle.message((String)"schema.validation.against.not", (Object[])new Object[0]), propValue.getDelegate(), JsonErrorPriority.NOT_SCHEMA);
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "propValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "schema";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "options";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/jsonSchema/impl/validations/NotValidation";
        objectArray[2] = "validate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

