/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.database.config.impl.urlParser;

import com.intellij.persistence.database.ConfigDataSourcePropertyValueSearcherKt;
import com.intellij.persistence.database.config.impl.urlParser.DatabaseUrl;
import com.intellij.persistence.database.config.impl.urlParser.DatabaseUrlParserKt;
import com.intellij.persistence.database.config.impl.urlParser.H2InFileDatabaseUrl;
import com.intellij.persistence.database.config.impl.urlParser.H2InMemoryDatabaseUrl;
import com.intellij.persistence.database.config.impl.urlParser.H2TcpDatabaseUrl;
import com.intellij.persistence.database.config.impl.urlParser.PathAndDatabaseName;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a5\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00012\b\u0010\f\u001a\u0004\u0018\u00010\u00012\b\u0010\r\u001a\u0004\u0018\u00010\u00012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0000\u00a2\u0006\u0002\u0010\u0010\u001a5\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000b\u001a\u00020\u00012\b\u0010\f\u001a\u0004\u0018\u00010\u00012\b\u0010\r\u001a\u0004\u0018\u00010\u00012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010\u0013\u001a\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000b\u001a\u00020\u00012\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000b\u001a\u00020\u00012\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"PATH_TO_DB", "", "MEM_DATABASE_NAME", "h2TcpUrlPattern", "Lkotlin/text/Regex;", "h2MemUrlPattern", "h2FileUrlPattern", "H2_TCP", "H2_MEM", "parseH2Url", "Lcom/intellij/persistence/database/config/impl/urlParser/DatabaseUrl;", "url", "databaseNameFromProperties", "host", "port", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)Lcom/intellij/persistence/database/config/impl/urlParser/DatabaseUrl;", "parseH2TcpUrl", "Lcom/intellij/persistence/database/config/impl/urlParser/H2TcpDatabaseUrl;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)Lcom/intellij/persistence/database/config/impl/urlParser/H2TcpDatabaseUrl;", "parseH2MemUrl", "Lcom/intellij/persistence/database/config/impl/urlParser/H2InMemoryDatabaseUrl;", "parseH2FileUrl", "Lcom/intellij/persistence/database/config/impl/urlParser/H2InFileDatabaseUrl;", "intellij.javaee.persistence.impl"})
public final class H2UrlParserKt {
    @NotNull
    public static final String PATH_TO_DB = "?<pathToDb>[A-Za-z0-9-/:\\-~\\._]+";
    @NotNull
    private static final String MEM_DATABASE_NAME = "?<databaseName>(///)?[A-Za-z0-9-_]+";
    @NotNull
    private static final Regex h2TcpUrlPattern = new Regex("(r2dbc|jdbc):h2:tcp://(?<host>[A-Za-z0-9-.\\\\]+)(?<port>:[0-9]+)?(?<pathToDb>[A-Za-z0-9-/:\\-~\\._]+)?(?<parameters>[A-Za-z0-9-\\?=:&\\-;?_/\\.\\\\]+)?");
    @NotNull
    private static final Regex h2MemUrlPattern = new Regex("(r2dbc|jdbc):h2:mem:(?<databaseName>(///)?[A-Za-z0-9-_]+)?(?<parameters>[A-Za-z0-9-\\?=:&\\-;?_/\\.\\\\]+)?");
    @NotNull
    private static final Regex h2FileUrlPattern = new Regex("(r2dbc|jdbc):h2(:file)?:(//)?(?<pathToDb>[A-Za-z0-9-/:\\-~\\._]+)?(?<parameters>[A-Za-z0-9-\\?=:&\\-;?_/\\.\\\\]+)?");
    @NotNull
    public static final String H2_TCP = ":h2:tcp";
    @NotNull
    public static final String H2_MEM = ":h2:mem";

    @Nullable
    public static final DatabaseUrl parseH2Url(@NotNull String url, @Nullable String databaseNameFromProperties, @Nullable String host, @Nullable Integer port) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (ConfigDataSourcePropertyValueSearcherKt.containsPlaceholders(url)) {
            return null;
        }
        return StringsKt.contains$default((CharSequence)url, (CharSequence)H2_TCP, (boolean)false, (int)2, null) ? (DatabaseUrl)H2UrlParserKt.parseH2TcpUrl(url, databaseNameFromProperties, host, port) : (StringsKt.contains$default((CharSequence)url, (CharSequence)H2_MEM, (boolean)false, (int)2, null) ? (DatabaseUrl)H2UrlParserKt.parseH2MemUrl(url, databaseNameFromProperties) : (DatabaseUrl)H2UrlParserKt.parseH2FileUrl(url, databaseNameFromProperties));
    }

    private static final H2TcpDatabaseUrl parseH2TcpUrl(String url, String databaseNameFromProperties, String host, Integer port) {
        MatchResult matchResult = Regex.find$default((Regex)h2TcpUrlPattern, (CharSequence)url, (int)0, (int)2, null);
        if (matchResult == null || (matchResult = matchResult.getGroups()) == null) {
            return null;
        }
        MatchResult groups = matchResult;
        String string = host;
        if (string == null && (string = DatabaseUrlParserKt.getHost((MatchGroupCollection)groups)) == null) {
            return null;
        }
        String specifiedHost = string;
        Integer n = port;
        if (n == null) {
            n = DatabaseUrlParserKt.getPort((MatchGroupCollection)groups);
        }
        Integer specifiedPort = n;
        String string2 = DatabaseUrlParserKt.getValue((MatchGroupCollection)groups, "pathToDb");
        if (string2 == null) {
            return null;
        }
        String pathToDb = string2;
        PathAndDatabaseName pathAndDatabaseName = DatabaseUrlParserKt.splitToPathAndDatabaseName(pathToDb);
        String path = pathAndDatabaseName.component1();
        String databaseName = pathAndDatabaseName.component2();
        String parameters = DatabaseUrlParserKt.getParameters((MatchGroupCollection)groups);
        String string3 = databaseName;
        if (string3 == null) {
            string3 = databaseNameFromProperties;
        }
        String string4 = string3;
        return new H2TcpDatabaseUrl(specifiedHost, specifiedPort, path, parameters, string4);
    }

    private static final H2InMemoryDatabaseUrl parseH2MemUrl(String url, String databaseNameFromProperties) {
        MatchResult matchResult = Regex.find$default((Regex)h2MemUrlPattern, (CharSequence)url, (int)0, (int)2, null);
        if (matchResult == null || (matchResult = matchResult.getGroups()) == null) {
            return null;
        }
        MatchResult groups = matchResult;
        String string = DatabaseUrlParserKt.getDatabase((MatchGroupCollection)groups);
        if (string == null || (string = DatabaseUrlParserKt.removePrefixSlashes(string)) == null) {
            string = databaseNameFromProperties;
        }
        String databaseName = string;
        String parameters = DatabaseUrlParserKt.getParameters((MatchGroupCollection)groups);
        return new H2InMemoryDatabaseUrl(databaseName, parameters);
    }

    private static final H2InFileDatabaseUrl parseH2FileUrl(String url, String databaseNameFromProperties) {
        String string;
        String string2;
        MatchResult matchResult = Regex.find$default((Regex)h2FileUrlPattern, (CharSequence)url, (int)0, (int)2, null);
        if (matchResult == null || (matchResult = matchResult.getGroups()) == null) {
            return null;
        }
        MatchResult groups = matchResult;
        String string3 = DatabaseUrlParserKt.getValue((MatchGroupCollection)groups, "pathToDb");
        if (string3 == null) {
            return null;
        }
        String pathToDb = string3;
        String parameters = DatabaseUrlParserKt.getParameters((MatchGroupCollection)groups);
        PathAndDatabaseName pathAndDatabaseName = DatabaseUrlParserKt.splitToPathAndDatabaseName(pathToDb);
        String path = pathAndDatabaseName.component1();
        String databaseName = pathAndDatabaseName.component2();
        String string4 = path;
        if (string4 == null) {
            string4 = string2 = "";
        }
        if ((string = databaseName) == null) {
            string = databaseNameFromProperties;
        }
        String string5 = string;
        return new H2InFileDatabaseUrl(string2, string5, parameters);
    }
}

