/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nullable;

public enum JavaContainerType {
    MAP,
    SET,
    LIST,
    COLLECTION,
    ARRAY;


    public String getJavaBaseClassName() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 4 -> "java.lang.reflect.Array";
            case 3 -> "java.util.Collection";
            case 2 -> "java.util.List";
            case 0 -> "java.util.Map";
            case 1 -> "java.util.Set";
        };
    }

    public static boolean isCollection(@Nullable JavaContainerType containerType) {
        return containerType == LIST || containerType == SET || containerType == COLLECTION;
    }

    public static boolean isCollectionOrMap(@Nullable JavaContainerType containerType) {
        return containerType == LIST || containerType == SET || containerType == COLLECTION || containerType == MAP;
    }

    public PsiType createCollectionType(PsiElement context, PsiType elementType, @Nullable PsiType mapKeyType) throws IncorrectOperationException {
        return JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory().createTypeFromText(this.getCollectionTypeText(PsiUtil.isLanguageLevel5OrHigher((PsiElement)context), elementType == null ? null : elementType.getCanonicalText(), mapKeyType == null ? null : mapKeyType.getCanonicalText()), context);
    }

    public String getCollectionTypeText(boolean generics, String elementTypeName, String mapKeyType) {
        boolean useGenerics = generics && StringUtil.isNotEmpty((String)elementTypeName);
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 4 -> elementTypeName + "[]";
            case 3 -> "java.util.Collection" + (String)(!useGenerics ? "" : "<" + elementTypeName + ">");
            case 2 -> "java.util.List" + (String)(!useGenerics ? "" : "<" + elementTypeName + ">");
            case 0 -> "java.util.Map" + (String)(!useGenerics ? "" : "<" + (mapKeyType == null ? "java.lang.Object" : mapKeyType) + ", " + elementTypeName + ">");
            case 1 -> "java.util.Set" + (String)(!useGenerics ? "" : "<" + elementTypeName + ">");
        };
    }
}

