/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.javaee.web.el.impl.references;

import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodQuickFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.XmlQuickFixFactory;
import com.intellij.javaee.el.ELCallExpression;
import com.intellij.javaee.el.providers.ElReferenceQuickFixProvider;
import com.intellij.javaee.el.psi.ELExpression;
import com.intellij.javaee.el.psi.ELFunctionCallExpression;
import com.intellij.javaee.el.psi.ELParameterList;
import com.intellij.javaee.el.psi.ELVariable;
import com.intellij.javaee.el.references.ELReference;
import com.intellij.javaee.el.util.ELResolveUtil;
import com.intellij.jsp.impl.FunctionDescriptor;
import com.intellij.jsp.impl.MethodSignatureAwareAttributeDescriptor;
import com.intellij.jsp.impl.TypeAwareAttributeDescriptor;
import com.intellij.jsp.javaee.web.el.impl.ELMethodSignature;
import com.intellij.jsp.javaee.web.el.impl.JspELResolveUtil;
import com.intellij.jsp.javaee.web.inspections.fixes.DeclareELVarViaCommentAnnotationFix;
import com.intellij.jsp.javaee.web.inspections.fixes.DeclareELVarViaUseBeanFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.beanProperties.CreateBeanPropertyFixes;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public final class JspElReferenceQuickFixProvider
extends ElReferenceQuickFixProvider {
    public Set<LocalQuickFix> getQuickFixes(ELReference elReference) {
        String text = elReference.getCanonicalText();
        if (StringUtil.isNotEmpty((String)text)) {
            PsiClass psiClass;
            PsiType contextType;
            ELExpression context = elReference.getContext();
            PsiType psiType = null;
            if (context != null && (contextType = ELResolveUtil.resolveContextAsType((ELExpression)context)) instanceof PsiClassType && (psiClass = ((PsiClassType)contextType).resolve()) != null) {
                XmlAttribute attr = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)context, XmlAttribute.class);
                if (attr != null) {
                    MethodSignatureAwareAttributeDescriptor attributeDescriptor;
                    String methodSignature;
                    XmlAttributeDescriptor descriptor = attr.getDescriptor();
                    if (descriptor instanceof MethodSignatureAwareAttributeDescriptor && (methodSignature = (attributeDescriptor = (MethodSignatureAwareAttributeDescriptor)descriptor).getMethodSignature()) != null) {
                        ELMethodSignature signature = new ELMethodSignature(methodSignature);
                        CreateMethodQuickFix fix = CreateMethodQuickFix.createFix((PsiClass)psiClass, (String)signature.getSignatureForMethodName(text), (String)"");
                        return fix == null ? Collections.emptySet() : Collections.singleton(fix);
                    }
                    if (descriptor instanceof TypeAwareAttributeDescriptor) {
                        String type = ((TypeAwareAttributeDescriptor)descriptor).getType();
                        psiType = JspElReferenceQuickFixProvider.getPsiType((PsiElement)attr, type);
                    }
                } else {
                    ELCallExpression callExpression = (ELCallExpression)PsiTreeUtil.getParentOfType((PsiElement)context, ELCallExpression.class);
                    if (callExpression != null) {
                        FunctionDescriptor descriptor = JspELResolveUtil.getFunctionDescriptor(callExpression);
                        ELExpression parameter = (ELExpression)PsiTreeUtil.getParentOfType((PsiElement)context, ELExpression.class);
                        ELParameterList parameterList = callExpression.getParameterList();
                        if (descriptor != null && parameter != null && parameterList != null) {
                            List parameters = descriptor.getFunctionParameters();
                            int i = ArrayUtil.indexOf((Object[])parameterList.getParameters(), (Object)parameter);
                            if (i >= 0 && i < parameters.size()) {
                                psiType = JspElReferenceQuickFixProvider.getPsiType((PsiElement)context, (String)parameters.get(i));
                            }
                        }
                    }
                }
                return Arrays.stream(CreateBeanPropertyFixes.createFixes((String)text, (PsiClass)psiClass, psiType, (boolean)false)).collect(Collectors.toSet());
            }
            ELExpression element = elReference.getElement();
            if (element instanceof ELVariable) {
                ELVariable variable = (ELVariable)element;
                PsiElement parentElement = variable.getParent();
                if (parentElement instanceof ELFunctionCallExpression) {
                    ELVariable function;
                    XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)variable, XmlTag.class);
                    if (tag != null && (function = ((ELFunctionCallExpression)parentElement).getMethod()) != null) {
                        String s = function.getText();
                        ELVariable ns = ((ELFunctionCallExpression)parentElement).getNamespace();
                        if (!"}".equals(s)) {
                            LocalQuickFix fix = ns.getContainingFile() instanceof XmlFile ? XmlQuickFixFactory.getInstance().createNSDeclarationIntentionFix((PsiElement)ns, ns.getText(), null) : null;
                            return fix == null ? Collections.emptySet() : Collections.singleton(fix);
                        }
                    }
                } else {
                    HashSet<LocalQuickFix> fixes = new HashSet<LocalQuickFix>();
                    fixes.add(new DeclareELVarViaUseBeanFix(elReference.getCanonicalText()));
                    fixes.add(new DeclareELVarViaCommentAnnotationFix(elReference.getCanonicalText()));
                    return fixes;
                }
            }
        }
        return Collections.emptySet();
    }

    @Nullable
    private static PsiType getPsiType(PsiElement context, String type) {
        if (type != null) {
            try {
                return JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory().createTypeFromText(type, context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

