/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.psi;

import com.intellij.javaee.el.ELExpressionHolder;
import com.intellij.jsp.psi.JspTokenType;
import com.intellij.jsp.psi.impl.jspXml.JspXmlText;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.jsp.jspXml.JspDirective;
import com.intellij.psi.impl.source.jsp.jspXml.JspXmlTagBase;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.jsp.JspDirectiveKind;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.CharTable;
import com.intellij.util.Processor;
import java.net.URL;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseJspUtil {
    @NonNls
    private static final String PAGE_DIRECTIVE = "page";
    @NonNls
    private static final String TAG_DIRECTIVE = "tag";
    @NonNls
    private static final String INCLUDE = "include";
    @NonNls
    private static final String TAGLIB = "taglib";
    @NonNls
    private static final String ATTRIBUTE = "attribute";
    @NonNls
    private static final String VARIABLE = "variable";
    @NonNls
    private static final String DIRECTIVE_PREFIX = "directive.";
    public static final Logger LOG = Logger.getInstance(BaseJspUtil.class);
    @NonNls
    public static final String PATH_TO_STANDARD_SCHEMAS = "/standardSchemas/";

    @Nullable
    public static JspDirectiveKind getDirectiveKindByTag(XmlTag tag) {
        String name = tag.getLocalName();
        if (!(tag instanceof JspDirective || name.startsWith(DIRECTIVE_PREFIX) && "http://java.sun.com/JSP/Page".equals(tag.getNamespace()))) {
            return null;
        }
        return BaseJspUtil.getDirectiveKindByName(name);
    }

    @Nullable
    public static JspDirectiveKind getDirectiveKindByName(String name) {
        if (PAGE_DIRECTIVE.equals(name = StringUtil.trimStart((String)name, (String)DIRECTIVE_PREFIX)) || TAG_DIRECTIVE.equals(name)) {
            return JspDirectiveKind.PAGE;
        }
        if (INCLUDE.equals(name)) {
            return JspDirectiveKind.INCLUDE;
        }
        if (TAGLIB.equals(name)) {
            return JspDirectiveKind.TAGLIB;
        }
        if (ATTRIBUTE.equals(name)) {
            return JspDirectiveKind.ATTRIBUTE;
        }
        if (VARIABLE.equals(name)) {
            return JspDirectiveKind.VARIABLE;
        }
        return null;
    }

    public static String getDirectiveAttributeName(JspDirectiveKind directiveKind, BaseJspFile file) {
        if (directiveKind == JspDirectiveKind.PAGE) {
            return file.isTagPage() ? "directive.tag" : "directive.page";
        }
        return DIRECTIVE_PREFIX + StringUtil.toLowerCase((String)directiveKind.name());
    }

    public static ASTNode parseSimpleJspBlock(@NotNull IElementType rootType, CharSequence text, CharTable table, @NotNull IElementType start, @NotNull IElementType end, int startLength) {
        if (rootType == null) {
            BaseJspUtil.$$$reportNull$$$0(0);
        }
        if (start == null) {
            BaseJspUtil.$$$reportNull$$$0(1);
        }
        if (end == null) {
            BaseJspUtil.$$$reportNull$$$0(2);
        }
        CompositeElement treeElement = ASTFactory.composite((IElementType)rootType);
        treeElement.rawAddChildren((TreeElement)ASTFactory.leaf((IElementType)start, (CharSequence)table.intern(text, 0, Math.min(startLength, text.length()))));
        if (text.length() > startLength + 1 && text.charAt(text.length() - 1) == '>' && text.charAt(text.length() - 2) == '%') {
            JspXmlText jspXmlText = new JspXmlText();
            treeElement.rawAddChildren((TreeElement)jspXmlText);
            if (text.length() > startLength + 2) {
                jspXmlText.rawAddChildren((TreeElement)ASTFactory.leaf((IElementType)JspTokenType.JAVA_CODE, (CharSequence)table.intern(text, startLength, text.length() - 2)));
            }
            treeElement.rawAddChildren((TreeElement)ASTFactory.leaf((IElementType)end, (CharSequence)table.intern(text, text.length() - 2, text.length())));
        } else if (text.length() > 2) {
            JspXmlText jspXmlText = new JspXmlText();
            treeElement.rawAddChildren((TreeElement)jspXmlText);
            jspXmlText.rawAddChildren((TreeElement)ASTFactory.leaf((IElementType)JspTokenType.JAVA_CODE, (CharSequence)table.intern(text, startLength, text.length())));
        }
        return treeElement;
    }

    @NotNull
    public static XmlFile getResource(@NonNls String resourceName, @NotNull Project project, @NotNull Class<?> baseClass) {
        VirtualFile fileByURL;
        URL resource;
        if (project == null) {
            BaseJspUtil.$$$reportNull$$$0(3);
        }
        if (baseClass == null) {
            BaseJspUtil.$$$reportNull$$$0(4);
        }
        if ((resource = baseClass.getResource(PATH_TO_STANDARD_SCHEMAS + resourceName)) == null) {
            LOG.error("Can't load resource: " + resourceName);
        }
        if ((fileByURL = VfsUtil.findFileByURL((URL)resource)) == null) {
            LOG.error("Can't find file by resource: " + String.valueOf(resource));
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(fileByURL);
        assert (psiFile instanceof XmlFile) : "Can't load resource: " + resourceName;
        XmlFile xmlFile = (XmlFile)psiFile;
        if (xmlFile == null) {
            BaseJspUtil.$$$reportNull$$$0(5);
        }
        return xmlFile;
    }

    public static <T extends BaseJspFile> void visitAllIncludedFilesRecursively(T baseJspFile, Processor<? super T> processor) {
        processor.process(baseJspFile);
    }

    @Nullable
    public static BaseJspFile getJspFile(@NotNull PsiElement element) {
        PsiFile containingFile;
        if (element == null) {
            BaseJspUtil.$$$reportNull$$$0(6);
        }
        if ((containingFile = element.getContainingFile()) == null) {
            return null;
        }
        FileViewProvider fileViewProvider = containingFile.getViewProvider();
        PsiFile psi = fileViewProvider.getPsi(fileViewProvider.getBaseLanguage());
        if (psi instanceof BaseJspFile) {
            return (BaseJspFile)psi;
        }
        return null;
    }

    public static boolean isInJspFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            BaseJspUtil.$$$reportNull$$$0(7);
        }
        return BaseJspUtil.getJspFile((PsiElement)psiFile) != null;
    }

    public static PsiReference[] getReferencesByElement(PsiElement element, boolean _soft, boolean endingSlashNotAllowed, boolean relativePathsAllowed) {
        boolean soft = _soft || PsiTreeUtil.getChildOfType((PsiElement)element, ELExpressionHolder.class) != null || PsiTreeUtil.getChildOfType((PsiElement)element, JspXmlTagBase.class) != null;
        return PathReferenceManager.getInstance().createReferences(element, soft, endingSlashNotAllowed, relativePathsAllowed, new PathReferenceProvider[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsp/psi/BaseJspUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsp/psi/BaseJspUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getResource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseSimpleJspBlock";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getResource";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getJspFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isInJspFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

