/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.transport;

import com.intellij.javaee.transport.TransportHost;
import com.intellij.javaee.transport.TransportHostTargetEditor;
import com.intellij.javaee.transport.TransportService;
import com.intellij.javaee.transport.TransportType;
import com.intellij.javaee.transport.TransportTypeImpl;
import com.intellij.openapi.project.Project;
import com.intellij.ssh.ui.unified.SshUiData;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.transport.WebDeploymentTransportHost;
import com.jetbrains.plugins.webDeployment.transport.WebDeploymentTransportHostTargetEditor;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

final class WebDeploymentTransportService
implements TransportService {
    public static final TransportType FTP_TYPE = new WebDeploymentTransportTypeImpl(WDBundle.message((String)"WebDeploymentTransportService.type.name.ftp", (Object[])new Object[0]));
    public static final TransportType SFTP_TYPE = new WebDeploymentTransportTypeImpl(WDBundle.message((String)"WebDeploymentTransportService.type.name.sftp", (Object[])new Object[0]));
    public static final TransportType FTPS_TYPE = new WebDeploymentTransportTypeImpl(WDBundle.message((String)"WebDeploymentTransportService.type.name.ftps", (Object[])new Object[0]));
    public static final TransportType MOUNT_TYPE = new WebDeploymentTransportTypeImpl(WDBundle.message((String)"WebDeploymentTransportService.type.name.mounted.folder", (Object[])new Object[0]));

    WebDeploymentTransportService() {
    }

    public List<TransportType> getTypes() {
        return Arrays.asList(FTP_TYPE, FTPS_TYPE, SFTP_TYPE, MOUNT_TYPE);
    }

    private static WebDeploymentTransportHost createHost(TransportType type, WebServerConfig server, @Nullable SshUiData sshUiData) {
        return new WebDeploymentTransportHost(type, server, sshUiData);
    }

    public List<TransportHost> getHosts(@Nullable Project project) {
        ArrayList<TransportHost> result = new ArrayList<TransportHost>();
        for (WebServerConfig server : GroupedServersConfigManager.getInstance((Project)project).getFlattenedServers()) {
            switch (server.getFileTransferConfig().getAccessType()) {
                case FTP: {
                    result.add(WebDeploymentTransportService.createHost(FTP_TYPE, server, null));
                    break;
                }
                case MOUNT: {
                    result.add(WebDeploymentTransportService.createHost(MOUNT_TYPE, server, null));
                    break;
                }
                case SFTP: {
                    SshUiData data = server.getOrCreateSshUiData(project);
                    result.add(WebDeploymentTransportService.createHost(SFTP_TYPE, server, data));
                    break;
                }
                case FTPS: {
                    result.add(WebDeploymentTransportService.createHost(FTPS_TYPE, server, null));
                    break;
                }
            }
        }
        return result;
    }

    @Nullable
    public TransportHost editHostsOfType(TransportType type, TransportHost selectedHost, Project project) {
        WebDeploymentTransportHost asWebDeploymentHost = (WebDeploymentTransportHost)selectedHost;
        DeploymentConfigurable.show((WebServerConfig)(asWebDeploymentHost == null ? null : asWebDeploymentHost.getServer()), (boolean)false, (Project)project, (int)-1);
        return null;
    }

    private static final class WebDeploymentTransportTypeImpl
    extends TransportTypeImpl {
        private WebDeploymentTransportTypeImpl(@Nls String name) {
            super(name);
        }

        public TransportHostTargetEditor createTargetEditor() {
            return new WebDeploymentTransportHostTargetEditor();
        }
    }
}

