/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.action;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.terminal.frontend.action.TerminalEscapeActionKt;
import com.intellij.terminal.frontend.action.TerminalEscapeHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.BlockTerminalController;
import org.jetbrains.plugins.terminal.block.TerminalPromotedDumbAwareAction;
import org.jetbrains.plugins.terminal.block.history.CommandHistoryPresenter;
import org.jetbrains.plugins.terminal.block.output.TerminalSelectionController;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptController;
import org.jetbrains.plugins.terminal.block.session.BlockTerminalSession;
import org.jetbrains.plugins.terminal.block.session.TerminalModel;
import org.jetbrains.plugins.terminal.block.util.TerminalDataContextUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0005\u0014\u0015\u0016\u0017\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J$\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/terminal/frontend/action/TerminalEscapeAction;", "Lorg/jetbrains/plugins/terminal/block/TerminalPromotedDumbAwareAction;", "<init>", "()V", "handlers", "", "Lcom/intellij/terminal/frontend/action/TerminalEscapeAction$Handler;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "Lcom/intellij/terminal/frontend/action/TerminalEscapeHandler;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "promote", "Lcom/intellij/openapi/actionSystem/AnAction;", "actions", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "Handler", "CloseHistoryHandler", "SelectPromptHandler", "CloseSearchHandler", "SelectEditorHandler", "intellij.terminal.frontend"})
@SourceDebugExtension(value={"SMAP\nTerminalEscapeAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalEscapeAction.kt\ncom/intellij/terminal/frontend/action/TerminalEscapeAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,176:1\n1#2:177\n1761#3,3:178\n1056#3:181\n1563#3:182\n1634#3,3:183\n808#3,11:186\n*S KotlinDebug\n*F\n+ 1 TerminalEscapeAction.kt\ncom/intellij/terminal/frontend/action/TerminalEscapeAction\n*L\n91#1:178,3\n96#1:181\n99#1:182\n99#1:183,3\n115#1:186,11\n*E\n"})
public final class TerminalEscapeAction
extends TerminalPromotedDumbAwareAction {
    @NotNull
    private final List<Handler> handlers;

    public TerminalEscapeAction() {
        Object[] objectArray = new Handler[]{new CloseHistoryHandler(), new SelectPromptHandler(), new CloseSearchHandler(), new SelectEditorHandler()};
        this.handlers = CollectionsKt.listOf((Object[])objectArray);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Iterable iterable = this.handlers(e);
            for (Object t : iterable) {
                TerminalEscapeHandler it = (TerminalEscapeHandler)t;
                boolean bl = false;
                if (!it.isEnabled(e)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        TerminalEscapeHandler terminalEscapeHandler = v0;
        if (terminalEscapeHandler == null) {
            return;
        }
        TerminalEscapeHandler handler = terminalEscapeHandler;
        handler.execute(e);
    }

    /*
     * WARNING - void declaration
     */
    public void update(@NotNull AnActionEvent e) {
        boolean bl;
        Presentation presentation;
        block6: {
            void $this$any$iv;
            Editor editor;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Editor editor2 = editor = TerminalDataContextUtils.INSTANCE.getTerminalEditor(e);
            if (!(editor2 != null ? TerminalDataContextUtils.INSTANCE.isPromptEditor(editor2) : false)) {
                Editor editor3 = editor;
                if (!(editor3 != null ? TerminalDataContextUtils.INSTANCE.isOutputEditor(editor3) : false)) {
                    Editor editor4 = editor;
                    if (!(editor4 != null ? TerminalDataContextUtils.INSTANCE.isReworkedTerminalEditor(editor4) : false)) {
                        e.getPresentation().setEnabledAndVisible(false);
                        return;
                    }
                }
            }
            Iterable iterable = this.handlers(e);
            presentation = e.getPresentation();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TerminalEscapeHandler it = (TerminalEscapeHandler)element$iv;
                    boolean bl2 = false;
                    if (!it.isEnabled(e)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        boolean bl3 = bl;
        presentation.setEnabledAndVisible(bl3);
    }

    /*
     * WARNING - void declaration
     */
    private final List<TerminalEscapeHandler> handlers(AnActionEvent e) {
        List list;
        Editor editor = TerminalDataContextUtils.INSTANCE.getTerminalEditor(e);
        boolean bl = editor != null ? TerminalDataContextUtils.INSTANCE.isReworkedTerminalEditor(editor) : false;
        if (bl) {
            Iterable $this$sortedBy$iv = TerminalEscapeActionKt.getTERMINAL_ESCAPE_HANDLER_EP().getExtensionList();
            boolean $i$f$sortedBy = false;
            list = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    TerminalEscapeHandler it = (TerminalEscapeHandler)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getOrder());
                    it = (TerminalEscapeHandler)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getOrder()));
                }
            });
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.handlers;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void legacyHandler;
                Handler handler = (Handler)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new TerminalEscapeHandler((Handler)legacyHandler){
                    private final int order;
                    final /* synthetic */ Handler $legacyHandler;
                    {
                        this.$legacyHandler = $legacyHandler;
                    }

                    public int getOrder() {
                        return this.order;
                    }

                    public boolean isEnabled(AnActionEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        return this.$legacyHandler.isEnabled(e);
                    }

                    public void execute(AnActionEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        this.$legacyHandler.execute(e);
                    }
                });
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AnAction> promote(@NotNull List<? extends AnAction> actions, @NotNull DataContext context) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Iterable $this$filterIsInstance$iv = actions;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TerminalEscapeAction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/terminal/frontend/action/TerminalEscapeAction$CloseHistoryHandler;", "Lcom/intellij/terminal/frontend/action/TerminalEscapeAction$Handler;", "<init>", "()V", "execute", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isEnabled", "", "intellij.terminal.frontend"})
    private static final class CloseHistoryHandler
    implements Handler {
        @Override
        public void execute(@NotNull AnActionEvent e) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TerminalPromptController terminalPromptController = TerminalDataContextUtils.INSTANCE.getPromptController(e);
                if (terminalPromptController == null) break block0;
                terminalPromptController.onCommandHistoryClosed();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isEnabled(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Editor editor = TerminalDataContextUtils.INSTANCE.getTerminalEditor(e);
            if (editor == null) return false;
            if (!TerminalDataContextUtils.INSTANCE.isPromptEditor(editor)) return false;
            boolean bl = true;
            if (!bl) return false;
            LookupEx lookupEx = LookupManager.getActiveLookup((Editor)TerminalDataContextUtils.INSTANCE.getTerminalEditor(e));
            if (lookupEx == null) return false;
            if (!CommandHistoryPresenter.Companion.isTerminalCommandHistory((Lookup)lookupEx)) return false;
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/terminal/frontend/action/TerminalEscapeAction$CloseSearchHandler;", "Lcom/intellij/terminal/frontend/action/TerminalEscapeAction$Handler;", "<init>", "()V", "execute", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isEnabled", "", "intellij.terminal.frontend"})
    private static final class CloseSearchHandler
    implements Handler {
        @Override
        public void execute(@NotNull AnActionEvent e) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                BlockTerminalController blockTerminalController = TerminalDataContextUtils.INSTANCE.getBlockTerminalController(e);
                if (blockTerminalController == null) break block0;
                blockTerminalController.finishSearchSession();
            }
        }

        @Override
        public boolean isEnabled(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            BlockTerminalController blockTerminalController = TerminalDataContextUtils.INSTANCE.getBlockTerminalController(e);
            return (blockTerminalController != null ? blockTerminalController.getSearchSession() : null) != null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\bb\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/terminal/frontend/action/TerminalEscapeAction$Handler;", "", "execute", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isEnabled", "", "intellij.terminal.frontend"})
    private static interface Handler {
        public void execute(@NotNull AnActionEvent var1);

        public boolean isEnabled(@NotNull AnActionEvent var1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/terminal/frontend/action/TerminalEscapeAction$SelectEditorHandler;", "Lcom/intellij/terminal/frontend/action/TerminalEscapeAction$Handler;", "<init>", "()V", "execute", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isEnabled", "", "intellij.terminal.frontend"})
    private static final class SelectEditorHandler
    implements Handler {
        @Override
        public void execute(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            Intrinsics.checkNotNull((Object)project);
            ToolWindowManager.Companion.getInstance(project).activateEditorComponent();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isEnabled(@NotNull AnActionEvent e) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            BlockTerminalSession blockTerminalSession = TerminalDataContextUtils.INSTANCE.getTerminalSession(e);
            Object object = blockTerminalSession;
            if (blockTerminalSession == null) return false;
            if ((object = ((BlockTerminalSession)object).getModel()) == null) {
                return false;
            }
            Object terminalModel = object;
            if (e.getProject() == null) return false;
            if (LookupManager.getActiveLookup((Editor)TerminalDataContextUtils.INSTANCE.getTerminalEditor(e)) != null) return false;
            if (e.getData(PlatformDataKeys.TOOL_WINDOW) == null) return false;
            if (!AdvancedSettings.Companion.getBoolean("terminal.escape.moves.focus.to.editor")) return false;
            Editor editor = TerminalDataContextUtils.INSTANCE.getTerminalEditor(e);
            if (editor != null) {
                if (TerminalDataContextUtils.INSTANCE.isPromptEditor(editor)) {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
            if (!((TerminalModel)terminalModel).isCommandRunning()) return false;
            if (((TerminalModel)terminalModel).getUseAlternateBuffer()) return false;
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/terminal/frontend/action/TerminalEscapeAction$SelectPromptHandler;", "Lcom/intellij/terminal/frontend/action/TerminalEscapeAction$Handler;", "<init>", "()V", "execute", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isEnabled", "", "intellij.terminal.frontend"})
    private static final class SelectPromptHandler
    implements Handler {
        @Override
        public void execute(@NotNull AnActionEvent e) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TerminalSelectionController terminalSelectionController = TerminalDataContextUtils.INSTANCE.getSelectionController(e);
                if (terminalSelectionController == null) break block0;
                terminalSelectionController.clearSelection();
            }
        }

        @Override
        public boolean isEnabled(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Editor editor = TerminalDataContextUtils.INSTANCE.getTerminalEditor(e);
            if (editor == null) {
                return false;
            }
            Editor editor2 = editor;
            TerminalSelectionController terminalSelectionController = TerminalDataContextUtils.INSTANCE.getSelectionController(e);
            if (terminalSelectionController == null) {
                return false;
            }
            TerminalSelectionController selectionController = terminalSelectionController;
            return TerminalDataContextUtils.INSTANCE.isOutputEditor(editor2) && (selectionController.getPrimarySelection() != null || editor2.getSelectionModel().hasSelection());
        }
    }
}

