/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.dev.storage;

import com.intellij.code.provenance.core.events.storage.mvstore.KeyType;
import com.intellij.code.provenance.core.events.storage.mvstore.ProvenanceMapName;
import com.intellij.code.provenance.core.events.storage.mvstore.ProvenanceMvStoreDatabase;
import com.intellij.code.provenance.core.events.storage.mvstore.UtilKt;
import com.intellij.openapi.project.Project;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ<\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u0011J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\rJ\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0017\u001a\u00020\u0018\u00a8\u0006\u001a"}, d2={"Lcom/intellij/code/provenance/dev/storage/InspectableProvenanceMvStoreDatabase;", "Lcom/intellij/code/provenance/core/events/storage/mvstore/ProvenanceMvStoreDatabase;", "store", "Lorg/h2/mvstore/MVStore;", "project", "Lcom/intellij/openapi/project/Project;", "batchSize", "", "<init>", "(Lorg/h2/mvstore/MVStore;Lcom/intellij/openapi/project/Project;I)V", "scanMap", "", "Lkotlin/Pair;", "", "mapName", "Lcom/intellij/code/provenance/core/events/storage/mvstore/ProvenanceMapName;", "prefix", "", "limit", "afterKey", "getMapValue", "key", "getFilePath", "hash", "", "Companion", "intellij.code.provenance.dev"})
public final class InspectableProvenanceMvStoreDatabase
extends ProvenanceMvStoreDatabase {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private InspectableProvenanceMvStoreDatabase(MVStore store, Project project, int batchSize) {
        super(store, project, batchSize);
    }

    /* synthetic */ InspectableProvenanceMvStoreDatabase(MVStore mVStore, Project project, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            project = null;
        }
        if ((n2 & 4) != 0) {
            n = 1000;
        }
        this(mVStore, project, n);
    }

    @NotNull
    public final List<Pair<Object, Object>> scanMap(@NotNull ProvenanceMapName mapName, @Nullable String prefix, int limit, @Nullable String afterKey) {
        Intrinsics.checkNotNullParameter((Object)mapName, (String)"mapName");
        List results = new ArrayList();
        switch (WhenMappings.$EnumSwitchMapping$1[mapName.getKeyType().ordinal()]) {
            case 1: {
                MVMap mVMap;
                switch (WhenMappings.$EnumSwitchMapping$0[mapName.ordinal()]) {
                    case 1: {
                        mVMap = this.getEntriesById();
                        break;
                    }
                    case 2: {
                        mVMap = this.getMetadataEntriesById();
                        break;
                    }
                    case 3: {
                        mVMap = this.getFileNameById();
                        break;
                    }
                    default: {
                        return CollectionsKt.emptyList();
                    }
                }
                MVMap mvMap = mVMap;
                Object object = afterKey;
                long startKey = object != null && (object = StringsKt.toLongOrNull((String)object)) != null ? (Long)object : 0L;
                Long key = (Long)mvMap.ceilingKey((Object)startKey);
                int count = 0;
                while (key != null && count < limit) {
                    Object value = mvMap.get((Object)key);
                    if (value != null) {
                        results.add(TuplesKt.to((Object)key, (Object)value));
                        ++count;
                    }
                    key = (Long)mvMap.higherKey((Object)key);
                }
                break;
            }
            case 2: {
                MVMap mVMap;
                switch (WhenMappings.$EnumSwitchMapping$0[mapName.ordinal()]) {
                    case 4: {
                        mVMap = this.getEntriesByFile();
                        break;
                    }
                    case 5: {
                        mVMap = this.getEntriesByTimestampAsc();
                        break;
                    }
                    case 6: {
                        mVMap = this.getEntriesByTimestampDesc();
                        break;
                    }
                    case 7: {
                        mVMap = this.getMetadataEntriesByLookup();
                        break;
                    }
                    default: {
                        return CollectionsKt.emptyList();
                    }
                }
                MVMap mvMap = mVMap;
                String string = afterKey;
                if (string == null && (string = prefix) == null) {
                    string = "";
                }
                String startKey = string;
                String key = (String)mvMap.ceilingKey((Object)startKey);
                int count = 0;
                while (key != null && count < limit && (prefix == null || StringsKt.startsWith$default((String)key, (String)prefix, (boolean)false, (int)2, null))) {
                    Long value = (Long)mvMap.get((Object)key);
                    if (value != null) {
                        results.add(TuplesKt.to((Object)key, (Object)value));
                        ++count;
                    }
                    key = (String)mvMap.higherKey((Object)key);
                }
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return results;
    }

    @Nullable
    public final Object getMapValue(@NotNull ProvenanceMapName mapName, @NotNull Object key) {
        Serializable serializable;
        Intrinsics.checkNotNullParameter((Object)mapName, (String)"mapName");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        block0 : switch (WhenMappings.$EnumSwitchMapping$1[mapName.getKeyType().ordinal()]) {
            case 1: {
                Long l = key instanceof Long ? (Long)key : null;
                if (l == null) {
                    return null;
                }
                long longKey = l;
                switch (WhenMappings.$EnumSwitchMapping$0[mapName.ordinal()]) {
                    case 1: {
                        serializable = (Serializable)this.getEntriesById().get((Object)longKey);
                        break block0;
                    }
                    case 2: {
                        serializable = (Serializable)this.getMetadataEntriesById().get((Object)longKey);
                        break block0;
                    }
                    case 3: {
                        serializable = (Serializable)this.getFileNameById().get((Object)longKey);
                        break block0;
                    }
                }
                serializable = null;
                break;
            }
            case 2: {
                String string = key instanceof String ? (String)key : null;
                if (string == null) {
                    return null;
                }
                String stringKey = string;
                serializable = switch (WhenMappings.$EnumSwitchMapping$0[mapName.ordinal()]) {
                    case 4 -> (Long)this.getEntriesByFile().get((Object)stringKey);
                    case 5 -> (Long)this.getEntriesByTimestampAsc().get((Object)stringKey);
                    case 6 -> (Long)this.getEntriesByTimestampDesc().get((Object)stringKey);
                    case 7 -> (Long)this.getMetadataEntriesByLookup().get((Object)stringKey);
                    default -> null;
                };
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return serializable;
    }

    @Nullable
    public final String getFilePath(long hash) {
        return (String)this.getFileNameById().get((Object)hash);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u001a\u0010\n\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a8\u0006\u000b"}, d2={"Lcom/intellij/code/provenance/dev/storage/InspectableProvenanceMvStoreDatabase$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/code/provenance/dev/storage/InspectableProvenanceMvStoreDatabase;", "path", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "open", "intellij.code.provenance.dev"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final InspectableProvenanceMvStoreDatabase create(@Nullable Path path, @Nullable Project project) {
            if (path != null) {
                UtilKt.cleanupMvStoreArtifacts((Path)path);
            }
            return this.open(path, project);
        }

        @NotNull
        public final InspectableProvenanceMvStoreDatabase open(@Nullable Path path, @Nullable Project project) {
            MVStore store = UtilKt.openStore((Path)path);
            return new InspectableProvenanceMvStoreDatabase(store, project, 0, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ProvenanceMapName.values().length];
            try {
                nArray[ProvenanceMapName.ENTRIES_BY_ID.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProvenanceMapName.METADATA_ENTRIES_BY_ID.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProvenanceMapName.FILE_NAME_BY_ID.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProvenanceMapName.ENTRIES_BY_FILE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProvenanceMapName.ENTRIES_BY_TIMESTAMP_ASC.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProvenanceMapName.ENTRIES_BY_TIMESTAMP_DESC.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProvenanceMapName.METADATA_ENTRIES_BY_LOOKUP.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[KeyType.values().length];
            try {
                nArray[KeyType.LONG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KeyType.STRING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

