/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.dev.view.dblookup;

import com.intellij.code.provenance.core.ProvenanceEntry;
import com.intellij.code.provenance.core.events.storage.dto.ProvenanceEntryDTO;
import com.intellij.code.provenance.core.events.storage.dto.ProvenanceEntryDTOKt;
import com.intellij.code.provenance.core.events.storage.mvstore.MetadataEntryData;
import com.intellij.code.provenance.core.events.storage.mvstore.ProvenanceKeyUtilKt;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.encoding.Base64;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0018\b\u0002\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u000bJ*\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0018\b\u0002\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u000bH\u0002J\u0016\u0010\u0010\u001a\u00020\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J*\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0018\b\u0002\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u000bH\u0002J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/code/provenance/dev/view/dblookup/DecodedValueView;", "", "<init>", "()V", "base64", "Lkotlin/io/encoding/Base64$Default;", "toJSON", "", "result", "Lcom/intellij/code/provenance/dev/view/dblookup/DecodedValueView$DecodeResult;", "filePathResolver", "Lkotlin/Function1;", "", "formatEntryJSON", "dto", "Lcom/intellij/code/provenance/core/events/storage/dto/ProvenanceEntryDTO;", "formatDiffChanges", "changes", "", "Lcom/intellij/code/provenance/core/ProvenanceEntry$SingleDocumentChange;", "formatMetadataJSON", "data", "Lcom/intellij/code/provenance/core/events/storage/mvstore/MetadataEntryData;", "formatError", "message", "escapeString", "s", "formatTimestamp", "timestamp", "DecodeResult", "intellij.code.provenance.dev"})
@SourceDebugExtension(value={"SMAP\nDecodedValueView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DecodedValueView.kt\ncom/intellij/code/provenance/dev/view/dblookup/DecodedValueView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,157:1\n1#2:158\n1878#3,3:159\n*S KotlinDebug\n*F\n+ 1 DecodedValueView.kt\ncom/intellij/code/provenance/dev/view/dblookup/DecodedValueView\n*L\n102#1:159,3\n*E\n"})
public final class DecodedValueView {
    @NotNull
    public static final DecodedValueView INSTANCE = new DecodedValueView();
    @NotNull
    private static final Base64.Default base64 = Base64.Default;

    private DecodedValueView() {
    }

    @NotNull
    public final String toJSON(@NotNull DecodeResult result, @Nullable Function1<? super Long, String> filePathResolver2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        DecodeResult decodeResult = result;
        if (decodeResult instanceof DecodeResult.Entry) {
            string = this.formatEntryJSON(((DecodeResult.Entry)result).getDto(), filePathResolver2);
        } else if (decodeResult instanceof DecodeResult.MetadataEntry) {
            string = this.formatMetadataJSON(((DecodeResult.MetadataEntry)result).getData(), filePathResolver2);
        } else if (decodeResult instanceof DecodeResult.Error) {
            string = this.formatError(((DecodeResult.Error)result).getMessage());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    public static /* synthetic */ String toJSON$default(DecodedValueView decodedValueView, DecodeResult decodeResult, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        return decodedValueView.toJSON(decodeResult, (Function1<? super Long, String>)function1);
    }

    private final String formatEntryJSON(ProvenanceEntryDTO dto, Function1<? super Long, String> filePathResolver2) {
        String string;
        Object object;
        Object $this$formatEntryJSON_u24lambda_u240;
        Object object2;
        block17: {
            block16: {
                Object object3;
                if (dto.getFileId() == -1L) {
                    object3 = "N/A";
                } else {
                    Function1<? super Long, String> function1 = filePathResolver2;
                    String resolvedPath = function1 != null ? (String)function1.invoke((Object)dto.getFileId()) : null;
                    object3 = resolvedPath;
                    if (object3 == null) {
                        object3 = "FileHash: " + dto.getFileId();
                    }
                }
                String caption = object3;
                try {
                    Object object4;
                    byte[] payloadBytes = Base64.decode$default((Base64)((Base64)base64), (CharSequence)dto.getPayloadBase64(), (int)0, (int)0, (int)6, null);
                    String string2 = dto.getType();
                    if (Intrinsics.areEqual((Object)string2, (Object)Reflection.getOrCreateKotlinClass(ProvenanceEntry.DocumentChange.class).getSimpleName())) {
                        List changes = ProvenanceEntryDTOKt.deserialize((byte[])payloadBytes);
                        object4 = this.formatDiffChanges(changes);
                    } else {
                        object4 = Intrinsics.areEqual((Object)string2, (Object)Reflection.getOrCreateKotlinClass(ProvenanceEntry.ContentChangeByLocalHistory.class).getSimpleName()) ? new String(payloadBytes, Charsets.UTF_8) : "Raw bytes (" + payloadBytes.length + " bytes)";
                    }
                    object2 = object4;
                }
                catch (Exception e) {
                    object2 = "Error decoding payload: " + e.getMessage();
                }
                String payloadDecoded = object2;
                $this$formatEntryJSON_u24lambda_u240 = object2 = new StringBuilder();
                boolean bl = false;
                ((StringBuilder)$this$formatEntryJSON_u24lambda_u240).append("{").append('\n');
                ((StringBuilder)$this$formatEntryJSON_u24lambda_u240).append("  \"timestamp\": " + dto.getTimestamp() + ",").append('\n');
                ((StringBuilder)$this$formatEntryJSON_u24lambda_u240).append("  \"timestampFormatted\": \"" + INSTANCE.formatTimestamp(dto.getTimestamp()) + "\",").append('\n');
                ((StringBuilder)$this$formatEntryJSON_u24lambda_u240).append("  \"type\": " + INSTANCE.escapeString(dto.getType()) + ",").append('\n');
                ((StringBuilder)$this$formatEntryJSON_u24lambda_u240).append("  \"documentPath\": " + INSTANCE.escapeString(caption) + ",").append('\n');
                object = dto.getType();
                if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(ProvenanceEntry.DocumentChange.class).getSimpleName())) {
                    ((StringBuilder)$this$formatEntryJSON_u24lambda_u240).append("  \"diff\": " + payloadDecoded + ",").append('\n');
                    v3 = ((StringBuilder)$this$formatEntryJSON_u24lambda_u240).append("  \"durationMs\": " + INSTANCE.escapeString(dto.getExtra()) + ",").append('\n');
                } else if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(ProvenanceEntry.ContentChangeByLocalHistory.class).getSimpleName())) {
                    ((StringBuilder)$this$formatEntryJSON_u24lambda_u240).append("  \"changeSetName\": " + INSTANCE.escapeString(payloadDecoded) + ",").append('\n');
                    v3 = ((StringBuilder)$this$formatEntryJSON_u24lambda_u240).append("  \"contentId\": " + INSTANCE.escapeString(dto.getExtra()) + ",").append('\n');
                } else {
                    v3 = ((StringBuilder)$this$formatEntryJSON_u24lambda_u240).append("  \"extra\": " + INSTANCE.escapeString(dto.getExtra()) + ",").append('\n');
                }
                object = $this$formatEntryJSON_u24lambda_u240;
                string = dto.getKind();
                if (string == null) break block16;
                String it = string;
                boolean bl2 = false;
                String string3 = INSTANCE.escapeString(it);
                string = string3;
                if (string3 != null) break block17;
            }
            string = "null";
        }
        ((StringBuilder)object).append("  \"kind\": " + string + ",").append('\n');
        object = $this$formatEntryJSON_u24lambda_u240;
        String string4 = ProvenanceKeyUtilKt.hashToString((Long)dto.getOldContentHash());
        if (string4 == null) {
            string4 = "null";
        }
        ((StringBuilder)object).append("  \"oldContentHash\": " + string4 + ",").append('\n');
        String string5 = ProvenanceKeyUtilKt.hashToString((Long)dto.getNewContentHash());
        if (string5 == null) {
            string5 = "null";
        }
        ((StringBuilder)$this$formatEntryJSON_u24lambda_u240).append("  \"newContentHash\": " + string5);
        ((StringBuilder)$this$formatEntryJSON_u24lambda_u240).append('\n');
        ((StringBuilder)$this$formatEntryJSON_u24lambda_u240).append("}");
        return ((StringBuilder)object2).toString();
    }

    static /* synthetic */ String formatEntryJSON$default(DecodedValueView decodedValueView, ProvenanceEntryDTO provenanceEntryDTO, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        return decodedValueView.formatEntryJSON(provenanceEntryDTO, (Function1<? super Long, String>)function1);
    }

    /*
     * WARNING - void declaration
     */
    private final String formatDiffChanges(List<ProvenanceEntry.SingleDocumentChange> changes) {
        StringBuilder stringBuilder;
        StringBuilder $this$formatDiffChanges_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$formatDiffChanges_u24lambda_u240.append("[").append('\n');
        Iterable $this$forEachIndexed$iv = changes;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void change;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ProvenanceEntry.SingleDocumentChange singleDocumentChange = (ProvenanceEntry.SingleDocumentChange)item$iv;
            int index = n;
            boolean bl2 = false;
            $this$formatDiffChanges_u24lambda_u240.append("    {").append('\n');
            $this$formatDiffChanges_u24lambda_u240.append("      \"offset\": " + change.getOffset() + ",").append('\n');
            $this$formatDiffChanges_u24lambda_u240.append("      \"oldLength\": " + change.getOldLength() + ",").append('\n');
            $this$formatDiffChanges_u24lambda_u240.append("      \"newFragment\": " + INSTANCE.escapeString(((Object)change.getNewFragment()).toString())).append('\n');
            $this$formatDiffChanges_u24lambda_u240.append("    }");
            StringBuilder stringBuilder2 = index < changes.size() - 1 ? $this$formatDiffChanges_u24lambda_u240.append(",").append('\n') : $this$formatDiffChanges_u24lambda_u240.append('\n');
        }
        $this$formatDiffChanges_u24lambda_u240.append("  ]");
        return stringBuilder.toString();
    }

    private final String formatMetadataJSON(MetadataEntryData data, Function1<? super Long, String> filePathResolver2) {
        String string;
        StringBuilder stringBuilder;
        StringBuilder $this$formatMetadataJSON_u24lambda_u241;
        StringBuilder stringBuilder2;
        block7: {
            block6: {
                long hash = data.getFileId();
                boolean bl = false;
                Object object = filePathResolver2;
                if (object == null || (object = (String)object.invoke((Object)hash)) == null) {
                    object = "FileHash: " + hash;
                }
                Object filePath = object;
                $this$formatMetadataJSON_u24lambda_u241 = stringBuilder2 = new StringBuilder();
                boolean bl2 = false;
                $this$formatMetadataJSON_u24lambda_u241.append("{").append('\n');
                $this$formatMetadataJSON_u24lambda_u241.append("  \"timestamp\": " + data.getTimestamp() + ",").append('\n');
                $this$formatMetadataJSON_u24lambda_u241.append("  \"timestampFormatted\": \"" + INSTANCE.formatTimestamp(data.getTimestamp()) + "\",").append('\n');
                $this$formatMetadataJSON_u24lambda_u241.append("  \"type\": " + INSTANCE.escapeString(data.getType()) + ",").append('\n');
                $this$formatMetadataJSON_u24lambda_u241.append("  \"fileHash\": " + data.getFileId() + ",").append('\n');
                stringBuilder = $this$formatMetadataJSON_u24lambda_u241;
                Object it = filePath;
                boolean bl3 = false;
                String string2 = "  \"filePath\": " + INSTANCE.escapeString((String)it) + ",";
                stringBuilder.append(string2).append('\n');
                stringBuilder = $this$formatMetadataJSON_u24lambda_u241;
                string = data.getKind();
                if (string == null) break block6;
                String it2 = string;
                boolean bl4 = false;
                String string3 = INSTANCE.escapeString(it2);
                string = string3;
                if (string3 != null) break block7;
            }
            string = "null";
        }
        stringBuilder.append("  \"kind\": " + string + ",").append('\n');
        stringBuilder = $this$formatMetadataJSON_u24lambda_u241;
        String string4 = ProvenanceKeyUtilKt.hashToString((Long)data.getOldContentHash());
        if (string4 == null) {
            string4 = "null";
        }
        stringBuilder.append("  \"oldContentHash\": " + string4 + ",").append('\n');
        String string5 = ProvenanceKeyUtilKt.hashToString((Long)data.getNewContentHash());
        if (string5 == null) {
            string5 = "null";
        }
        $this$formatMetadataJSON_u24lambda_u241.append("  \"newContentHash\": " + string5);
        $this$formatMetadataJSON_u24lambda_u241.append('\n');
        $this$formatMetadataJSON_u24lambda_u241.append("}");
        return stringBuilder2.toString();
    }

    static /* synthetic */ String formatMetadataJSON$default(DecodedValueView decodedValueView, MetadataEntryData metadataEntryData, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        return decodedValueView.formatMetadataJSON(metadataEntryData, (Function1<? super Long, String>)function1);
    }

    private final String formatError(String message) {
        StringBuilder stringBuilder;
        StringBuilder $this$formatError_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$formatError_u24lambda_u240.append("{").append('\n');
        $this$formatError_u24lambda_u240.append("  \"error\": " + INSTANCE.escapeString(message) + ",").append('\n');
        $this$formatError_u24lambda_u240.append("  \"note\": \"This may be due to a version mismatch in the serializer.\"").append('\n');
        $this$formatError_u24lambda_u240.append("}");
        return stringBuilder.toString();
    }

    private final String escapeString(String s) {
        String escaped = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)s, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null), (String)"\"", (String)"\\\"", (boolean)false, (int)4, null), (String)"\n", (String)"\\n", (boolean)false, (int)4, null), (String)"\r", (String)"\\r", (boolean)false, (int)4, null), (String)"\t", (String)"\\t", (boolean)false, (int)4, null);
        return "\"" + escaped + "\"";
    }

    private final String formatTimestamp(long timestamp) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
        String string = sdf.format(new Date(timestamp));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n"}, d2={"Lcom/intellij/code/provenance/dev/view/dblookup/DecodedValueView$DecodeResult;", "", "<init>", "()V", "Entry", "MetadataEntry", "Error", "Lcom/intellij/code/provenance/dev/view/dblookup/DecodedValueView$DecodeResult$Entry;", "Lcom/intellij/code/provenance/dev/view/dblookup/DecodedValueView$DecodeResult$Error;", "Lcom/intellij/code/provenance/dev/view/dblookup/DecodedValueView$DecodeResult$MetadataEntry;", "intellij.code.provenance.dev"})
    public static abstract sealed class DecodeResult {
        private DecodeResult() {
        }

        public /* synthetic */ DecodeResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/code/provenance/dev/view/dblookup/DecodedValueView$DecodeResult$Entry;", "Lcom/intellij/code/provenance/dev/view/dblookup/DecodedValueView$DecodeResult;", "dto", "Lcom/intellij/code/provenance/core/events/storage/dto/ProvenanceEntryDTO;", "<init>", "(Lcom/intellij/code/provenance/core/events/storage/dto/ProvenanceEntryDTO;)V", "getDto", "()Lcom/intellij/code/provenance/core/events/storage/dto/ProvenanceEntryDTO;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.code.provenance.dev"})
        public static final class Entry
        extends DecodeResult {
            @NotNull
            private final ProvenanceEntryDTO dto;

            public Entry(@NotNull ProvenanceEntryDTO dto) {
                Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
                super(null);
                this.dto = dto;
            }

            @NotNull
            public final ProvenanceEntryDTO getDto() {
                return this.dto;
            }

            @NotNull
            public final ProvenanceEntryDTO component1() {
                return this.dto;
            }

            @NotNull
            public final Entry copy(@NotNull ProvenanceEntryDTO dto) {
                Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
                return new Entry(dto);
            }

            public static /* synthetic */ Entry copy$default(Entry entry, ProvenanceEntryDTO provenanceEntryDTO, int n, Object object) {
                if ((n & 1) != 0) {
                    provenanceEntryDTO = entry.dto;
                }
                return entry.copy(provenanceEntryDTO);
            }

            @NotNull
            public String toString() {
                return "Entry(dto=" + this.dto + ")";
            }

            public int hashCode() {
                return this.dto.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Entry)) {
                    return false;
                }
                Entry entry = (Entry)other;
                return Intrinsics.areEqual((Object)this.dto, (Object)entry.dto);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/code/provenance/dev/view/dblookup/DecodedValueView$DecodeResult$Error;", "Lcom/intellij/code/provenance/dev/view/dblookup/DecodedValueView$DecodeResult;", "message", "", "bytes", "", "<init>", "(Ljava/lang/String;[B)V", "getMessage", "()Ljava/lang/String;", "getBytes", "()[B", "equals", "", "other", "", "hashCode", "", "component1", "component2", "copy", "toString", "intellij.code.provenance.dev"})
        public static final class Error
        extends DecodeResult {
            @NotNull
            private final String message;
            @NotNull
            private final byte[] bytes;

            public Error(@NotNull String message, @NotNull byte[] bytes) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                super(null);
                this.message = message;
                this.bytes = bytes;
            }

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            @NotNull
            public final byte[] getBytes() {
                return this.bytes;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Error)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.message, (Object)((Error)other).message)) {
                    return false;
                }
                return Arrays.equals(this.bytes, ((Error)other).bytes);
            }

            public int hashCode() {
                int result = this.message.hashCode();
                result = 31 * result + Arrays.hashCode(this.bytes);
                return result;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @NotNull
            public final byte[] component2() {
                return this.bytes;
            }

            @NotNull
            public final Error copy(@NotNull String message, @NotNull byte[] bytes) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                return new Error(message, bytes);
            }

            public static /* synthetic */ Error copy$default(Error error, String string, byte[] byArray, int n, Object object) {
                if ((n & 1) != 0) {
                    string = error.message;
                }
                if ((n & 2) != 0) {
                    byArray = error.bytes;
                }
                return error.copy(string, byArray);
            }

            @NotNull
            public String toString() {
                return "Error(message=" + this.message + ", bytes=" + Arrays.toString(this.bytes) + ")";
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/code/provenance/dev/view/dblookup/DecodedValueView$DecodeResult$MetadataEntry;", "Lcom/intellij/code/provenance/dev/view/dblookup/DecodedValueView$DecodeResult;", "data", "Lcom/intellij/code/provenance/core/events/storage/mvstore/MetadataEntryData;", "<init>", "(Lcom/intellij/code/provenance/core/events/storage/mvstore/MetadataEntryData;)V", "getData", "()Lcom/intellij/code/provenance/core/events/storage/mvstore/MetadataEntryData;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.code.provenance.dev"})
        public static final class MetadataEntry
        extends DecodeResult {
            @NotNull
            private final MetadataEntryData data;

            public MetadataEntry(@NotNull MetadataEntryData data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                super(null);
                this.data = data;
            }

            @NotNull
            public final MetadataEntryData getData() {
                return this.data;
            }

            @NotNull
            public final MetadataEntryData component1() {
                return this.data;
            }

            @NotNull
            public final MetadataEntry copy(@NotNull MetadataEntryData data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                return new MetadataEntry(data);
            }

            public static /* synthetic */ MetadataEntry copy$default(MetadataEntry metadataEntry, MetadataEntryData metadataEntryData, int n, Object object) {
                if ((n & 1) != 0) {
                    metadataEntryData = metadataEntry.data;
                }
                return metadataEntry.copy(metadataEntryData);
            }

            @NotNull
            public String toString() {
                return "MetadataEntry(data=" + this.data + ")";
            }

            public int hashCode() {
                return this.data.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MetadataEntry)) {
                    return false;
                }
                MetadataEntry metadataEntry = (MetadataEntry)other;
                return Intrinsics.areEqual((Object)this.data, (Object)metadataEntry.data);
            }
        }
    }
}

