/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.MemberImplementorExplorer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class OverrideImplementExploreUtil {
    private static final NullableLazyValue<MemberImplementorExplorersProvider> ourExplorerProvider = NullableLazyValue.volatileLazyNullable(() -> (MemberImplementorExplorersProvider)ApplicationManager.getApplication().getService(MemberImplementorExplorersProvider.class));

    @NotNull
    public static Collection<CandidateInfo> getMethodsToOverrideImplement(@NotNull PsiClass aClass, boolean toImplement) {
        if (aClass == null) {
            OverrideImplementExploreUtil.$$$reportNull$$$0(0);
        }
        Collection<CandidateInfo> collection = OverrideImplementExploreUtil.getMapToOverrideImplement(aClass, toImplement).values();
        if (collection == null) {
            OverrideImplementExploreUtil.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    public static Collection<MethodSignature> getMethodSignaturesToImplement(@NotNull PsiClass aClass) {
        if (aClass == null) {
            OverrideImplementExploreUtil.$$$reportNull$$$0(2);
        }
        Set<MethodSignature> set = OverrideImplementExploreUtil.getMapToOverrideImplement(aClass, true).keySet();
        if (set == null) {
            OverrideImplementExploreUtil.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public static Collection<MethodSignature> getMethodSignaturesToOverride(@NotNull PsiClass aClass) {
        if (aClass == null) {
            OverrideImplementExploreUtil.$$$reportNull$$$0(4);
        }
        if (aClass.isAnnotationType()) {
            Set<MethodSignature> set = Collections.emptySet();
            if (set == null) {
                OverrideImplementExploreUtil.$$$reportNull$$$0(5);
            }
            return set;
        }
        Set<MethodSignature> set = OverrideImplementExploreUtil.getMapToOverrideImplement(aClass, false).keySet();
        if (set == null) {
            OverrideImplementExploreUtil.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    public static Map<MethodSignature, CandidateInfo> getMapToOverrideImplement(@NotNull PsiClass aClass, boolean toImplement) {
        if (aClass == null) {
            OverrideImplementExploreUtil.$$$reportNull$$$0(7);
        }
        return OverrideImplementExploreUtil.getMapToOverrideImplement(aClass, toImplement, true);
    }

    @NotNull
    public static Map<MethodSignature, CandidateInfo> getMapToOverrideImplement(@NotNull PsiClass aClass, boolean toImplement, boolean skipImplemented) {
        if (aClass == null) {
            OverrideImplementExploreUtil.$$$reportNull$$$0(8);
        }
        if (aClass.isAnnotationType() || aClass instanceof PsiTypeParameter) {
            Map<MethodSignature, CandidateInfo> map2 = Collections.emptyMap();
            if (map2 == null) {
                OverrideImplementExploreUtil.$$$reportNull$$$0(9);
            }
            return map2;
        }
        PsiUtilCore.ensureValid((PsiElement)aClass);
        Collection<HierarchicalMethodSignature> allMethodSigs = aClass.getVisibleSignatures();
        allMethodSigs = OverrideImplementExploreUtil.deleteShadowed(allMethodSigs);
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance(aClass.getProject()).getResolveHelper();
        LinkedHashMap<MethodSignature, PsiMethod> abstracts = new LinkedHashMap<MethodSignature, PsiMethod>();
        LinkedHashMap<MethodSignature, PsiMethod> finals = new LinkedHashMap<MethodSignature, PsiMethod>();
        LinkedHashMap<MethodSignature, PsiMethod> concretes = new LinkedHashMap<MethodSignature, PsiMethod>();
        for (HierarchicalMethodSignature signature : allMethodSigs) {
            PsiClass hisClass;
            PsiMethod method = signature.getMethod();
            PsiUtilCore.ensureValid((PsiElement)method);
            if (method.hasModifierProperty("static") || !resolveHelper.isAccessible(method, aClass, aClass) || method.isConstructor() && method.hasModifierProperty("abstract")) continue;
            for (HierarchicalMethodSignature superMethodSignature : signature.getSuperSignatures()) {
                PsiMethod superMethod = superMethodSignature.getMethod();
                if (PsiUtil.getAccessLevel(superMethod.getModifierList()) <= PsiUtil.getAccessLevel(method.getModifierList())) continue;
                method = superMethod;
                break;
            }
            if ((hisClass = method.getContainingClass()) == null || method.isConstructor() && (!aClass.isInheritor(hisClass, false) || aClass instanceof PsiAnonymousClass || aClass.isEnum() || aClass instanceof PsiImplicitClass) || skipImplemented && MethodSignatureUtil.findMethodBySignature(aClass, signature, false) != null) continue;
            if (method.hasModifierProperty("final")) {
                finals.put(signature, method);
                continue;
            }
            LinkedHashMap<MethodSignature, PsiMethod> map3 = hisClass.isInterface() || method.hasModifierProperty("abstract") ? abstracts : concretes;
            OverrideImplementExploreUtil.fillMap(signature, method, map3);
            if (!OverrideImplementExploreUtil.shouldAppearInOverrideList(aClass, method)) continue;
            OverrideImplementExploreUtil.fillMap(signature, method, concretes);
        }
        TreeMap<MethodSignature, CandidateInfo> result = new TreeMap<MethodSignature, CandidateInfo>(new MethodSignatureComparator());
        if (toImplement || aClass.isInterface()) {
            OverrideImplementExploreUtil.collectMethodsToImplement(aClass, abstracts, finals, concretes, result);
        } else {
            for (Map.Entry entry : concretes.entrySet()) {
                PsiMethod abstractOne;
                MethodSignature signature = (MethodSignature)entry.getKey();
                PsiMethod concrete = (PsiMethod)entry.getValue();
                if (finals.get(signature) != null || (abstractOne = (PsiMethod)abstracts.get(signature)) != null && abstractOne.getContainingClass().isInheritor(concrete.getContainingClass(), true) && !"java.lang.Object".equals(concrete.getContainingClass().getQualifiedName())) continue;
                PsiSubstitutor subst = OverrideImplementExploreUtil.correctSubstitutor(concrete, signature.getSubstitutor());
                CandidateInfo info = new CandidateInfo(concrete, subst);
                result.put(signature, info);
            }
        }
        TreeMap<MethodSignature, CandidateInfo> treeMap = result;
        if (treeMap == null) {
            OverrideImplementExploreUtil.$$$reportNull$$$0(10);
        }
        return treeMap;
    }

    @NotNull
    private static Collection<HierarchicalMethodSignature> deleteShadowed(@NotNull Collection<HierarchicalMethodSignature> sigs) {
        if (sigs == null) {
            OverrideImplementExploreUtil.$$$reportNull$$$0(11);
        }
        ArrayList<HierarchicalMethodSignature> signatures = new ArrayList<HierarchicalMethodSignature>();
        HashMap<String, List> nameToSignature = new HashMap<String, List>();
        for (HierarchicalMethodSignature signature : sigs) {
            String name = signature.getMethod().getName();
            List previousSignatures = nameToSignature.computeIfAbsent(name, n -> new ArrayList());
            boolean addToList = true;
            for (HierarchicalMethodSignature previousSignature : previousSignatures) {
                if (!MethodSignatureUtil.areSignaturesErasureEqual(signature, previousSignature)) continue;
                PsiClass containingClass = signature.getMethod().getContainingClass();
                PsiClass previousContainingClass = previousSignature.getMethod().getContainingClass();
                if (containingClass == null || previousContainingClass == null || containingClass.getManager().areElementsEquivalent((PsiElement)containingClass, (PsiElement)previousContainingClass)) continue;
                if (containingClass.isInheritor(previousContainingClass, true)) {
                    signatures.remove(previousSignature);
                    continue;
                }
                if (!previousContainingClass.isInheritor(containingClass, true)) continue;
                addToList = false;
                break;
            }
            previousSignatures.add(signature);
            if (!addToList) continue;
            signatures.add(signature);
        }
        ArrayList<HierarchicalMethodSignature> arrayList = signatures;
        if (arrayList == null) {
            OverrideImplementExploreUtil.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private static boolean isDefaultMethod(@NotNull PsiClass aClass, @NotNull PsiMethod method) {
        if (aClass == null) {
            OverrideImplementExploreUtil.$$$reportNull$$$0(13);
        }
        if (method == null) {
            OverrideImplementExploreUtil.$$$reportNull$$$0(14);
        }
        return method.hasModifierProperty("default") && PsiUtil.isAvailable(JavaFeature.EXTENSION_METHODS, aClass);
    }

    private static void fillMap(@NotNull HierarchicalMethodSignature signature, @NotNull PsiMethod method, @NotNull Map<MethodSignature, PsiMethod> map2) {
        PsiMethod other;
        if (signature == null) {
            OverrideImplementExploreUtil.$$$reportNull$$$0(15);
        }
        if (method == null) {
            OverrideImplementExploreUtil.$$$reportNull$$$0(16);
        }
        if (map2 == null) {
            OverrideImplementExploreUtil.$$$reportNull$$$0(17);
        }
        if ((other = map2.get(signature)) == null || OverrideImplementExploreUtil.preferLeftForImplement(method, other)) {
            map2.put(signature, method);
        }
    }

    private static void collectMethodsToImplement(@NotNull PsiClass aClass, @NotNull Map<MethodSignature, PsiMethod> abstracts, @NotNull Map<MethodSignature, PsiMethod> finals, @NotNull Map<MethodSignature, PsiMethod> concretes, @NotNull Map<MethodSignature, CandidateInfo> result) {
        if (aClass == null) {
            OverrideImplementExploreUtil.$$$reportNull$$$0(18);
        }
        if (abstracts == null) {
            OverrideImplementExploreUtil.$$$reportNull$$$0(19);
        }
        if (finals == null) {
            OverrideImplementExploreUtil.$$$reportNull$$$0(20);
        }
        if (concretes == null) {
            OverrideImplementExploreUtil.$$$reportNull$$$0(21);
        }
        if (result == null) {
            OverrideImplementExploreUtil.$$$reportNull$$$0(22);
        }
        for (Map.Entry<MethodSignature, PsiMethod> entry : abstracts.entrySet()) {
            MethodSignature methodSignature = entry.getKey();
            PsiMethod abstractOne = entry.getValue();
            PsiMethod concrete = concretes.get(methodSignature);
            if (concrete != null && PsiUtil.getAccessLevel(concrete.getModifierList()) >= PsiUtil.getAccessLevel(abstractOne.getModifierList()) && (abstractOne.getContainingClass().isInterface() || !abstractOne.getContainingClass().isInheritor(concrete.getContainingClass(), true)) && !OverrideImplementExploreUtil.shouldAppearInOverrideList(aClass, abstractOne) || finals.get(methodSignature) != null) continue;
            PsiSubstitutor subst = OverrideImplementExploreUtil.correctSubstitutor(abstractOne, methodSignature.getSubstitutor());
            CandidateInfo info = new CandidateInfo(abstractOne, subst);
            result.put(methodSignature, info);
        }
        MemberImplementorExplorersProvider explorersProvider = (MemberImplementorExplorersProvider)ourExplorerProvider.getValue();
        if (explorersProvider != null) {
            for (MemberImplementorExplorer memberImplementorExplorer : explorersProvider.getExplorers()) {
                for (PsiMethod method : memberImplementorExplorer.getMethodsToImplement(aClass)) {
                    MethodSignatureBackedByPsiMethod signature = MethodSignatureBackedByPsiMethod.create(method, PsiSubstitutor.EMPTY);
                    CandidateInfo info = new CandidateInfo(method, PsiSubstitutor.EMPTY);
                    result.put(signature, info);
                }
            }
        }
    }

    private static boolean shouldAppearInOverrideList(@NotNull PsiClass aClass, PsiMethod abstractOne) {
        if (aClass == null) {
            OverrideImplementExploreUtil.$$$reportNull$$$0(23);
        }
        return OverrideImplementExploreUtil.isDefaultMethod(aClass, abstractOne) || OverrideImplementExploreUtil.belongsToRecord(abstractOne);
    }

    @ApiStatus.Internal
    public static boolean belongsToRecord(@NotNull PsiMethod method) {
        if (method == null) {
            OverrideImplementExploreUtil.$$$reportNull$$$0(24);
        }
        return "java.lang.Record".equals(Objects.requireNonNull(method.getContainingClass()).getQualifiedName());
    }

    private static boolean preferLeftForImplement(@NotNull PsiMethod left, @NotNull PsiMethod right) {
        PsiAnnotation[] rightAnnotations;
        if (left == null) {
            OverrideImplementExploreUtil.$$$reportNull$$$0(25);
        }
        if (right == null) {
            OverrideImplementExploreUtil.$$$reportNull$$$0(26);
        }
        if (PsiUtil.getAccessLevel(left.getModifierList()) > PsiUtil.getAccessLevel(right.getModifierList())) {
            return true;
        }
        if (!left.getContainingClass().isInterface()) {
            return true;
        }
        if (!right.getContainingClass().isInterface()) {
            return false;
        }
        PsiAnnotation[] leftAnnotations = left.getModifierList().getAnnotations();
        return leftAnnotations.length > (rightAnnotations = right.getModifierList().getAnnotations()).length;
    }

    @NotNull
    public static PsiSubstitutor correctSubstitutor(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor) {
        if (method == null) {
            OverrideImplementExploreUtil.$$$reportNull$$$0(27);
        }
        if (substitutor == null) {
            OverrideImplementExploreUtil.$$$reportNull$$$0(28);
        }
        PsiClass hisClass = method.getContainingClass();
        PsiTypeParameter[] typeParameters = method.getTypeParameters();
        if (typeParameters.length > 0 && PsiUtil.isRawSubstitutor(hisClass, substitutor)) {
            substitutor = JavaPsiFacade.getElementFactory(method.getProject()).createRawSubstitutor(substitutor, typeParameters);
        }
        PsiSubstitutor psiSubstitutor = substitutor;
        if (psiSubstitutor == null) {
            OverrideImplementExploreUtil.$$$reportNull$$$0(29);
        }
        return psiSubstitutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/generation/OverrideImplementExploreUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sigs";
                break;
            }
            case 14: 
            case 16: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "abstracts";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finals";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "concretes";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/generation/OverrideImplementExploreUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodsToOverrideImplement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodSignaturesToImplement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodSignaturesToOverride";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMapToOverrideImplement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "deleteShadowed";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "correctSubstitutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMethodsToOverrideImplement";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 29: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMethodSignaturesToImplement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMethodSignaturesToOverride";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMapToOverrideImplement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "deleteShadowed";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultMethod";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "fillMap";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "collectMethodsToImplement";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "shouldAppearInOverrideList";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "belongsToRecord";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "preferLeftForImplement";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "correctSubstitutor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MethodSignatureComparator
    implements Comparator<MethodSignature> {
        @Override
        public int compare(MethodSignature o1, MethodSignature o2) {
            if (o1 instanceof MethodSignatureBackedByPsiMethod && o2 instanceof MethodSignatureBackedByPsiMethod) {
                PsiMethod m1 = ((MethodSignatureBackedByPsiMethod)o1).getMethod();
                PsiMethod m2 = ((MethodSignatureBackedByPsiMethod)o2).getMethod();
                PsiClass c1 = m1.getContainingClass();
                PsiClass c2 = m2.getContainingClass();
                if (c1 != null && c2 != null) {
                    if (c1 == c2) {
                        List<PsiMethod> methods = Arrays.asList(c1.getMethods());
                        return methods.indexOf(m1) - methods.indexOf(m2);
                    }
                    if (c1.isInheritor(c2, true)) {
                        return -1;
                    }
                    if (c2.isInheritor(c1, true)) {
                        return 1;
                    }
                    return StringUtil.notNullize((String)c1.getQualifiedName()).compareTo(StringUtil.notNullize((String)c2.getQualifiedName()));
                }
                return m1.getTextOffset() - m2.getTextOffset();
            }
            return 0;
        }
    }

    @FunctionalInterface
    public static interface MemberImplementorExplorersProvider {
        @NotNull
        public List<? extends MemberImplementorExplorer> getExplorers();
    }
}

