/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.core.JavaPsiBundle;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiReceiverParameter;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiRecordHeader;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.javadoc.PsiSnippetDocTagBody;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public enum JavaElementKind {
    ABSTRACT_METHOD("element.abstract_method"),
    ANNOTATION("element.annotation"),
    ANONYMOUS_CLASS("element.anonymous_class"),
    CATCH_PARAMETER("element.catch_parameter"),
    CLASS("element.class"),
    CONSTANT("element.constant"),
    CONSTRUCTOR("element.constructor"),
    ENUM("element.enum"),
    ENUM_CONSTANT("element.enum_constant"),
    EXPRESSION("element.expression"),
    EXTENDS_LIST("element.extends.list"),
    FIELD("element.field"),
    FOR_PARAMETER("element.for_parameter"),
    INITIALIZER("element.initializer"),
    INTERFACE("element.interface"),
    LABEL("element.label"),
    LAMBDA_PARAMETER("element.lambda_parameter"),
    LOCAL_VARIABLE("element.local_variable"),
    METHOD("element.method"),
    METHOD_CALL("element.method.call"),
    MODULE("element.module"),
    PACKAGE("element.package"),
    PACKAGE_STATEMENT("element.package.statement"),
    PARAMETER("element.parameter"),
    PATTERN_VARIABLE("element.pattern_variable"),
    PERMITS_LIST("element.permits.list"),
    RECEIVER_PARAMETER("element.receiver.parameter"),
    RECORD("element.record"),
    RECORD_COMPONENT("element.record_component"),
    RECORD_HEADER("element.record_header"),
    SEMICOLON("element.type.semicolon"),
    SNIPPET_BODY("element.snippet_body"),
    STATEMENT("element.statement"),
    THROWS_LIST("element.throws.list"),
    TYPE_ARGUMENTS("element.type.arguments"),
    TYPE_PARAMETER("element.type.parameter"),
    TYPE_PARAMETERS("element.type.parameters"),
    UNKNOWN("element.unknown"),
    VARIABLE("element.variable");

    @PropertyKey(resourceBundle="messages.JavaPsiBundle")
    private final @PropertyKey(resourceBundle="messages.JavaPsiBundle") String propertyKey;

    private JavaElementKind(String key) {
        this.propertyKey = key;
    }

    @Nls
    @NotNull
    public String subject() {
        String string = JavaPsiBundle.message(this.propertyKey, 0);
        if (string == null) {
            JavaElementKind.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String object() {
        String string = JavaPsiBundle.message(this.propertyKey, 1);
        if (string == null) {
            JavaElementKind.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public JavaElementKind lessDescriptive() {
        switch (this.ordinal()) {
            case 0: {
                JavaElementKind javaElementKind = METHOD;
                if (javaElementKind == null) {
                    JavaElementKind.$$$reportNull$$$0(2);
                }
                return javaElementKind;
            }
            case 17: 
            case 24: {
                JavaElementKind javaElementKind = VARIABLE;
                if (javaElementKind == null) {
                    JavaElementKind.$$$reportNull$$$0(3);
                }
                return javaElementKind;
            }
            case 5: {
                JavaElementKind javaElementKind = FIELD;
                if (javaElementKind == null) {
                    JavaElementKind.$$$reportNull$$$0(4);
                }
                return javaElementKind;
            }
            case 2: 
            case 35: {
                JavaElementKind javaElementKind = CLASS;
                if (javaElementKind == null) {
                    JavaElementKind.$$$reportNull$$$0(5);
                }
                return javaElementKind;
            }
            case 3: 
            case 12: 
            case 16: {
                JavaElementKind javaElementKind = PARAMETER;
                if (javaElementKind == null) {
                    JavaElementKind.$$$reportNull$$$0(6);
                }
                return javaElementKind;
            }
        }
        JavaElementKind javaElementKind = this;
        if (javaElementKind == null) {
            JavaElementKind.$$$reportNull$$$0(7);
        }
        return javaElementKind;
    }

    public static JavaElementKind fromElement(@NotNull PsiElement element) {
        if (element == null) {
            JavaElementKind.$$$reportNull$$$0(8);
        }
        if (element instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)element;
            if (psiClass instanceof PsiAnonymousClass) {
                return ANONYMOUS_CLASS;
            }
            if (psiClass.isEnum()) {
                return ENUM;
            }
            if (psiClass.isRecord()) {
                return RECORD;
            }
            if (psiClass.isAnnotationType()) {
                return ANNOTATION;
            }
            if (psiClass.isInterface()) {
                return INTERFACE;
            }
            if (psiClass instanceof PsiTypeParameter) {
                return TYPE_PARAMETER;
            }
            return CLASS;
        }
        if (element instanceof PsiMethod) {
            if (((PsiMethod)element).isConstructor()) {
                return CONSTRUCTOR;
            }
            if (((PsiMethod)element).hasModifierProperty("abstract")) {
                return ABSTRACT_METHOD;
            }
            return METHOD;
        }
        if (element instanceof PsiField) {
            PsiField field = (PsiField)element;
            if (field instanceof PsiEnumConstant) {
                return ENUM_CONSTANT;
            }
            if (field.hasModifierProperty("static") && field.hasModifierProperty("final")) {
                return CONSTANT;
            }
            return FIELD;
        }
        if (element instanceof PsiTypeParameterList) {
            return TYPE_PARAMETERS;
        }
        if (element instanceof PsiReferenceParameterList) {
            return TYPE_ARGUMENTS;
        }
        if (element instanceof PsiReferenceList) {
            PsiReferenceList.Role role = ((PsiReferenceList)element).getRole();
            if (role == PsiReferenceList.Role.THROWS_LIST) {
                return THROWS_LIST;
            }
            if (role == PsiReferenceList.Role.EXTENDS_LIST) {
                return EXTENDS_LIST;
            }
            if (role == PsiReferenceList.Role.PERMITS_LIST) {
                return PERMITS_LIST;
            }
        }
        if (element instanceof PsiAnnotation) {
            return ANNOTATION;
        }
        if (element instanceof PsiRecordComponent) {
            return RECORD_COMPONENT;
        }
        if (element instanceof PsiRecordHeader) {
            return RECORD_HEADER;
        }
        if (element instanceof PsiLocalVariable) {
            return LOCAL_VARIABLE;
        }
        if (element instanceof PsiPatternVariable) {
            return PATTERN_VARIABLE;
        }
        if (element instanceof PsiParameter) {
            PsiElement scope = ((PsiParameter)element).getDeclarationScope();
            if (scope instanceof PsiForeachStatement) {
                return FOR_PARAMETER;
            }
            if (scope instanceof PsiLambdaExpression) {
                return LAMBDA_PARAMETER;
            }
            if (scope instanceof PsiCatchSection) {
                return CATCH_PARAMETER;
            }
            return PARAMETER;
        }
        if (element instanceof PsiReceiverParameter) {
            return RECEIVER_PARAMETER;
        }
        if (element instanceof PsiVariable) {
            return VARIABLE;
        }
        if (element instanceof PsiPackage) {
            return PACKAGE;
        }
        if (element instanceof PsiPackageStatement) {
            return PACKAGE_STATEMENT;
        }
        if (element instanceof PsiJavaModule) {
            return MODULE;
        }
        if (element instanceof PsiClassInitializer) {
            return INITIALIZER;
        }
        if (element instanceof PsiLabeledStatement) {
            return LABEL;
        }
        if (element instanceof PsiStatement) {
            return STATEMENT;
        }
        if (element instanceof PsiMethodCallExpression) {
            return METHOD_CALL;
        }
        if (element instanceof PsiExpression) {
            return EXPRESSION;
        }
        if (element instanceof PsiSnippetDocTagBody) {
            return SNIPPET_BODY;
        }
        if (PsiUtil.isJavaToken(element, JavaTokenType.SEMICOLON)) {
            return SEMICOLON;
        }
        return UNKNOWN;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/JavaElementKind";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "subject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "object";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "lessDescriptive";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/JavaElementKind";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fromElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

