/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.tagtoattribute;

import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBBox;
import com.sixrr.xrp.base.BaseRefactoringDialog;
import com.sixrr.xrp.ui.ScopePanel;
import com.sixrr.xrp.utils.RefactorXBundle;
import com.sixrr.xrp.utils.XMLRefactoringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;

class TagToAttributeDialog
extends BaseRefactoringDialog {
    private final JLabel attributeNameLabel = new JLabel();
    private final JTextField attributeNameField;
    private final XmlTag tag;

    TagToAttributeDialog(XmlTag tag) {
        super(tag.getProject(), true);
        String tagName = tag.getName();
        this.tag = tag;
        XmlTag parentTag = tag.getParentTag();
        XmlFile containingFile = (XmlFile)tag.getContainingFile();
        this.scopePanel = new ScopePanel(containingFile, this);
        this.setTitle(RefactorXBundle.message("dialog.title.replace.tag.with.attribute", new Object[0]));
        this.attributeNameLabel.setText(RefactorXBundle.message("label.text.name.for.new.attribute", new Object[0]));
        XmlAttribute[] attributes = parentTag.getAttributes();
        String attributeName = null;
        for (XmlAttribute attribute : attributes) {
            if (attribute == null) continue;
            attributeName = attribute.getLocalName();
            break;
        }
        String newAttributeName = XMLRefactoringUtil.attributeNameFromTag(tagName, attributeName);
        this.attributeNameField = new JTextField(newAttributeName);
        Document document = this.attributeNameField.getDocument();
        document.addDocumentListener(this.docListener);
        this.init();
        this.validateButtons();
    }

    @Override
    protected String getDimensionServiceKey() {
        return "RefactorX.TagToAttribute";
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.attributeNameField;
    }

    public String getAttributeName() {
        return this.attributeNameField.getText().trim();
    }

    protected JComponent createNorthPanel() {
        String tagName = this.tag.getName();
        JPanel panel = new JPanel(new BorderLayout());
        TitledBorder border = IdeBorderFactory.createTitledBorder((String)RefactorXBundle.message("border.text.replace.tag.0.with.attribute", tagName));
        panel.add((Component)this.attributeNameLabel, "North");
        JBBox box = JBBox.createVerticalBox();
        panel.setBorder(border);
        this.attributeNameField.setEditable(true);
        box.add((Component)this.attributeNameField);
        panel.add((Component)box, "Center");
        return panel;
    }

    @Override
    protected boolean isValid() {
        String attributeName = this.getAttributeName();
        boolean attributeNameEntered = XMLRefactoringUtil.attributeNameIsValid(attributeName);
        boolean scopeIsValid = this.scopePanel.isScopeValid();
        return attributeNameEntered && scopeIsValid;
    }

    @Override
    protected String calculateXSLT() {
        String parentTagName = this.tag.getParentTag().getName();
        String tagName = this.tag.getName();
        String attributeName = this.getAttributeName();
        return " <xsl:template match=\"" + parentTagName + "\">\n\t<xsl:copy> \n\t\t<xsl:for-each select =\"child::" + tagName + "\">\n\t\t\t<xsl:attribute name = \"" + attributeName + "\">\n\t\t\t\t<xsl:value-of select=\".\"/>\n\t\t\t</xsl:attribute>\n\t\t</xsl:for-each>\n\t\t<xsl:apply-templates select=\"@*|node()\"/>\n\t</xsl:copy>\n</xsl:template>\n<xsl:template match=\"" + parentTagName + "/" + tagName + "\"/>";
    }

    @Override
    @NotNull
    protected String getHelpId() {
        return "refactoring.tagToAttribute";
    }
}

