/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.trace.consent.actions;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.platform.trace.consent.TraceConsentBundle;
import com.intellij.platform.trace.consent.storage.serialization.TraceStateEventSerializer;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/trace/consent/actions/ShowTraceMachineIdAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "Companion", "intellij.platform.trace.consent"})
final class ShowTraceMachineIdAction
extends AnAction
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TRACE_MACHINE_ID_VM_OPTION = "idea.trace.machineId.action";
    @NotNull
    private static final String NOTIFICATION_GROUP_ID = "TRACE.MachineId";

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        boolean enabled = Boolean.getBoolean(TRACE_MACHINE_ID_VM_OPTION);
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        String string;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        String machineId = TraceStateEventSerializer.INSTANCE.getMachineId();
        if (machineId == null) {
            string = TraceConsentBundle.message("notification.content.trace.machine.id.unavailable.see.idea.log.for.details", new Object[0]);
        } else {
            Object[] objectArray = new Object[]{machineId};
            string = TraceConsentBundle.message("notification.content.trace.machine.id.value", objectArray);
        }
        String message = string;
        Notification notification = new Notification(NOTIFICATION_GROUP_ID, TraceConsentBundle.message("notification.on.tool.window.title.trace.machine.id", new Object[0]), message, machineId == null ? NotificationType.WARNING : NotificationType.INFORMATION);
        if (machineId != null) {
            notification.addAction((AnAction)NotificationAction.createSimple((String)TraceConsentBundle.message("notification.action.copy.to.clipboard", new Object[0]), () -> ShowTraceMachineIdAction.actionPerformed$lambda$0(machineId)));
        }
        Notifications.Bus.notify((Notification)notification, (Project)project);
    }

    private static final void actionPerformed$lambda$0(String $machineId) {
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection($machineId));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/platform/trace/consent/actions/ShowTraceMachineIdAction$Companion;", "", "<init>", "()V", "TRACE_MACHINE_ID_VM_OPTION", "", "NOTIFICATION_GROUP_ID", "intellij.platform.trace.consent"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

