/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.FtlBuiltInDescriptor;
import com.intellij.freemarker.inspections.FtlSuppressableInspection;
import com.intellij.freemarker.psi.AbstractFtlExpression;
import com.intellij.freemarker.psi.FtlBinaryExpression;
import com.intellij.freemarker.psi.FtlDateType;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlExpression;
import com.intellij.freemarker.psi.FtlHashLiteral;
import com.intellij.freemarker.psi.FtlInterpolation;
import com.intellij.freemarker.psi.FtlMarkupOutputType;
import com.intellij.freemarker.psi.FtlNodeType;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlTokenType;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.FtlUnaryExpression;
import com.intellij.freemarker.psi.directives.FtlAssignDirective;
import com.intellij.freemarker.psi.directives.FtlDirective;
import com.intellij.freemarker.psi.directives.FtlIfDirective;
import com.intellij.freemarker.psi.directives.FtlListDirective;
import com.intellij.freemarker.psi.directives.FtlLoopVariable;
import com.intellij.freemarker.psi.directives.FtlMacro;
import com.intellij.freemarker.psi.directives.FtlVisitDirective;
import com.intellij.freemarker.psi.variables.FtlCallableType;
import com.intellij.freemarker.psi.variables.FtlNamespaceType;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiTypes;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.annotations.VisibleForTesting;

public final class FtlTypesInspection
extends FtlSuppressableInspection {
    @VisibleForTesting
    public static final String SHORT_NAME = "FtlTypesInspection";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            FtlTypesInspection.$$$reportNull$$$0(0);
        }
        return new PsiElementVisitor(this){

            public void visitElement(@NotNull PsiElement element) {
                FtlType type;
                FtlExpression condition;
                FtlDirective directive;
                FtlType type2;
                AbstractFtlExpression expression;
                FtlExpression expression2;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof FtlInterpolation) {
                    FtlInterpolation interpolation = (FtlInterpolation)element;
                    expression2 = interpolation.getExpression();
                    if (expression2 == null) {
                        return;
                    }
                    FtlType expressionType = expression2.getType();
                    if (expressionType == null) {
                        return;
                    }
                    if (interpolation.isNumeric()) {
                        FtlTypesInspection.checkNumericType(interpolation.getFirstChild(), holder, expressionType);
                    } else if (!FtlTypesInspection.isScalarType(expression2, expressionType)) {
                        holder.registerProblem(interpolation.getFirstChild(), FreeMarkerBundle.message("expression.should.have.scalar.type", expressionType.getPresentableText()), new LocalQuickFix[0]);
                    }
                }
                if (element instanceof FtlBinaryExpression) {
                    expression = (FtlBinaryExpression)element;
                    FtlExpression left = ((FtlBinaryExpression)expression).getLeftOperand();
                    FtlExpression right = ((FtlBinaryExpression)expression).getRightOperand();
                    if (left == null || right == null) {
                        return;
                    }
                    FtlType leftType = left.getType();
                    FtlType rightType = right.getType();
                    if (((FtlBinaryExpression)expression).getOperationSign() == FtlElementTypes.ASTERISK && FtlTypesInspection.checkNumericType(left, holder, leftType) | FtlTypesInspection.checkNumericType(right, holder, rightType)) {
                        return;
                    }
                    FtlTypesInspection.checkNonCallableType(left, holder, leftType);
                    FtlTypesInspection.checkNonCallableType(right, holder, rightType);
                    return;
                }
                if (element instanceof FtlUnaryExpression) {
                    expression = (FtlUnaryExpression)element;
                    FtlExpression operand = ((FtlUnaryExpression)expression).getOperand();
                    if (operand == null) {
                        return;
                    }
                    type2 = operand.getType();
                    if (type2 == null) {
                        return;
                    }
                    FtlTokenType operation = ((FtlUnaryExpression)expression).getOperation();
                    if (operation == FtlElementTypes.EXCLAM) {
                        FtlTypesInspection.checkBooleanType(operand, type2, holder);
                    } else {
                        FtlTypesInspection.checkNumericType(operand, holder, type2);
                    }
                }
                if (element instanceof FtlListDirective) {
                    directive = (FtlListDirective)element;
                    expression2 = ((FtlListDirective)directive).getListExpression();
                    if (expression2 == null) {
                        return;
                    }
                    type2 = expression2.getType();
                    if (type2 == null) {
                        return;
                    }
                    List<FtlLoopVariable> loopVariables = ((FtlListDirective)directive).getMainLoopVariables();
                    if (loopVariables.size() == 1 && !FtlListDirective.isCollectionType(type2)) {
                        holder.registerProblem((PsiElement)expression2, FreeMarkerBundle.message("expression.should.have.array.or.collection.type", type2.getPresentableText()), new LocalQuickFix[0]);
                    } else if (loopVariables.size() == 2 && !FtlBuiltInDescriptor.HashBuiltIn.isHash(type2)) {
                        holder.registerProblem((PsiElement)expression2, FreeMarkerBundle.message("expression.should.have.hash.type", type2.getPresentableText()), new LocalQuickFix[0]);
                    }
                }
                if (element instanceof FtlAssignDirective) {
                    FtlTypesInspection.checkTypeClass(((FtlAssignDirective)element).getNamespaceExpression(), holder, FtlNamespaceType.class, "expression.should.have.namespace.type");
                }
                if (element instanceof FtlVisitDirective) {
                    directive = (FtlVisitDirective)element;
                    FtlTypesInspection.checkTypeClass(((FtlVisitDirective)directive).getNodeExpression(), holder, FtlNodeType.class, "expression.should.have.node.type");
                    FtlTypesInspection.checkTypeClass(((FtlVisitDirective)directive).getNamespaceExpression(), holder, FtlNamespaceType.class, "expression.should.have.namespace.type");
                }
                if (element instanceof FtlIfDirective && (condition = ((FtlIfDirective)element).getCondition()) != null && (type = condition.getType()) != null) {
                    FtlTypesInspection.checkBooleanType(condition, type, holder);
                }
                if (element instanceof FtlMacro) {
                    FtlExpression[] references;
                    for (FtlExpression reference : references = ((FtlMacro)element).getAllMacroReferences()) {
                        FtlCallableType callableType;
                        FtlType type3 = reference.getType();
                        if (type3 == null || (callableType = FtlPsiUtil.asInstanceOf(type3, FtlCallableType.class)) != null && callableType.isMacro()) continue;
                        holder.registerProblem((PsiElement)reference, FreeMarkerBundle.message("expression.should.have.macro.type", type3.getPresentableText()), new LocalQuickFix[0]);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/inspections/FtlTypesInspection$1", "visitElement"));
            }
        };
    }

    private static boolean isScalarType(FtlExpression expression, FtlType expressionType) {
        if (FtlPsiUtil.asInstanceOf(expressionType, FtlDateType.class) != null) {
            return true;
        }
        if (FtlPsiUtil.asInstanceOf(expressionType, FtlMarkupOutputType.class) != null) {
            return true;
        }
        FtlPsiType type = FtlPsiUtil.asInstanceOf(expressionType, FtlPsiType.class);
        return type != null && !(expression instanceof FtlHashLiteral) && !PsiTypes.booleanType().equals((Object)type.getPsiType());
    }

    private static void checkBooleanType(FtlExpression expression, FtlType type, ProblemsHolder holder) {
        FtlPsiType fpType = type.asInstanceOf(FtlPsiType.class);
        if (fpType == null || !PsiTypes.booleanType().isAssignableFrom(fpType.getPsiType())) {
            holder.registerProblem((PsiElement)expression, FreeMarkerBundle.message("expression.should.have.boolean.type", fpType == null ? "null" : fpType.getPresentableText()), new LocalQuickFix[0]);
        }
    }

    private static boolean checkNumericType(@NotNull PsiElement element, ProblemsHolder holder, FtlType type) {
        if (element == null) {
            FtlTypesInspection.$$$reportNull$$$0(1);
        }
        if (type != null && !FtlPsiUtil.isNumeric(type, element)) {
            holder.registerProblem(element, FreeMarkerBundle.message("expression.should.have.numeric.type", type.getPresentableText()), new LocalQuickFix[0]);
            return true;
        }
        return false;
    }

    private static void checkNonCallableType(@NotNull PsiElement element, ProblemsHolder holder, FtlType type) {
        if (element == null) {
            FtlTypesInspection.$$$reportNull$$$0(2);
        }
        if (type instanceof FtlCallableType) {
            holder.registerProblem(element, FreeMarkerBundle.message("expression.unexpected.type", type.getPresentableText()), new LocalQuickFix[0]);
        }
    }

    private static void checkTypeClass(FtlExpression expression, ProblemsHolder holder, Class<? extends FtlType> aClass, @PropertyKey(resourceBundle="messages.FreeMarkerBundle") @PropertyKey(resourceBundle="messages.FreeMarkerBundle") String key) {
        FtlType type;
        if (expression != null && (type = expression.getType()) != null && type.asInstanceOf(aClass) == null) {
            holder.registerProblem((PsiElement)expression, FreeMarkerBundle.message(key, type.getPresentableText()), new LocalQuickFix[0]);
        }
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = FreeMarkerBundle.message("freemarker.inspections.group", new Object[0]);
        if (string == null) {
            FtlTypesInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/inspections/FtlTypesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/inspections/FtlTypesInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkNumericType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkNonCallableType";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

