/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.cloud.stream.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.semantic.SemService;
import com.intellij.spring.boot.cloud.stream.SpringCloudStreamBundle;
import com.intellij.spring.boot.cloud.stream.inspections.SpringCloudStreamInspectionBase;
import com.intellij.spring.boot.cloud.stream.model.jam.MessageChannel;
import com.intellij.spring.boot.cloud.stream.model.jam.ReactiveMessageChannelParameter;
import com.intellij.spring.boot.cloud.stream.model.jam.SpringCloudStreamChannelOwner;
import com.intellij.spring.integration.util.SpringIntegrationUtil;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringCommonUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UastContextKt;

public class SpringCloudStreamMessageChannelInspection
extends SpringCloudStreamInspectionBase {
    @Override
    protected ProblemDescriptor @Nullable [] doCheckClass(@NotNull UClass aClass, @NotNull Module module, @NotNull ProblemsHolder holder) {
        if (aClass == null) {
            SpringCloudStreamMessageChannelInspection.$$$reportNull$$$0(0);
        }
        if (module == null) {
            SpringCloudStreamMessageChannelInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            SpringCloudStreamMessageChannelInspection.$$$reportNull$$$0(2);
        }
        if (!SpringCommonUtils.isSpringConfigured((Module)module)) {
            return null;
        }
        SemService semService = SemService.getSemService((Project)module.getProject());
        for (UMethod uMethod : aClass.getMethods()) {
            List channelOwners = semService.getSemElements(SpringCloudStreamChannelOwner.STREAM_CHANNEL_OWNER_JAM_KEY, (PsiElement)uMethod.getJavaPsi());
            for (SpringCloudStreamChannelOwner channelOwner : channelOwners) {
                SpringCloudStreamMessageChannelInspection.checkChannelOwner(channelOwner, module, holder);
            }
            if (channelOwners.isEmpty()) continue;
            for (UParameter parameter : uMethod.getUastParameters()) {
                ReactiveMessageChannelParameter channelParameter;
                PsiElement psiElement = parameter.getJavaPsi();
                if (psiElement == null || (channelParameter = (ReactiveMessageChannelParameter)semService.getSemElement(ReactiveMessageChannelParameter.PARAM_JAM_KEY, psiElement)) == null) continue;
                SpringCloudStreamMessageChannelInspection.checkChannelAttribute(holder, channelParameter.getValueAttr(), module);
            }
        }
        return holder.getResultsArray();
    }

    private static void checkChannelOwner(SpringCloudStreamChannelOwner channelOwner, Module module, ProblemsHolder holder) {
        for (JamStringAttributeElement attributeElement : channelOwner.getChannelAttributes()) {
            SpringCloudStreamMessageChannelInspection.checkChannelAttribute(holder, attributeElement, module);
        }
    }

    private static void checkChannelAttribute(ProblemsHolder holder, JamStringAttributeElement<SpringBeanPointer<?>> attributeElement, Module module) {
        UElement uElement = UastContextKt.toUElement((PsiElement)attributeElement.getPsiElement());
        if (uElement == null) {
            return;
        }
        PsiElement psiElement = uElement.getSourcePsi();
        if (psiElement == null) {
            return;
        }
        SpringBeanPointer springBeanPointer = (SpringBeanPointer)attributeElement.getValue();
        if (springBeanPointer == null) {
            holder.registerProblem(psiElement, SpringCloudStreamBundle.message("spring.cloud.stream.message.channel.inspection.cannot.find.channel", new Object[0]), new LocalQuickFix[0]);
        } else if (!(springBeanPointer.getSpringBean() instanceof MessageChannel) && !SpringIntegrationUtil.isMessageChannel((Module)module, (SpringBeanPointer)springBeanPointer)) {
            holder.registerProblem(psiElement, SpringCloudStreamBundle.message("spring.cloud.stream.message.channel.inspection.bean.must.be.message.channel", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "aClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/boot/cloud/stream/inspections/SpringCloudStreamMessageChannelInspection";
        objectArray[2] = "doCheckClass";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

