/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common.gui.settings.db;

import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.ui.component.SListModelEditor;
import com.intellij.jpa.jpb.model.util.JpaUiUtil;
import com.intellij.liquibase.common.config.DatabaseInfo;
import com.intellij.liquibase.common.config.DatabaseMigrationConfig;
import com.intellij.liquibase.common.config.DatabaseMigrationState;
import com.intellij.liquibase.common.gui.settings.db.DatabaseInfoPanel;
import com.intellij.liquibase.common.gui.settings.db.LiquibasePanel;
import com.intellij.liquibase.common.msg.LiquibaseResourceBundle;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListItemEditor;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/liquibase/common/gui/settings/db/DatabaseMigrationPanel;", "Lcom/intellij/liquibase/common/gui/settings/db/LiquibasePanel;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "state", "Lcom/intellij/liquibase/common/config/DatabaseMigrationState;", "itemEditor", "Lcom/intellij/util/ui/ListItemEditor;", "Lcom/intellij/liquibase/common/config/DatabaseInfo;", "editor", "Lcom/intellij/jpa/jpb/model/ui/component/SListModelEditor;", "itemPanel", "Lcom/intellij/liquibase/common/gui/settings/db/DatabaseInfoPanel;", "itemPanelWrapper", "Ljavax/swing/JPanel;", "loadFromState", "", "isModified", "", "saveToState", "Companion", "MyListModelEditor", "intellij.liquibase.common"})
@SourceDebugExtension(value={"SMAP\nDatabaseMigrationPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseMigrationPanel.kt\ncom/intellij/liquibase/common/gui/settings/db/DatabaseMigrationPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n1869#2:143\n1870#2:145\n774#2:146\n865#2,2:147\n1#3:144\n*S KotlinDebug\n*F\n+ 1 DatabaseMigrationPanel.kt\ncom/intellij/liquibase/common/gui/settings/db/DatabaseMigrationPanel\n*L\n98#1:143\n98#1:145\n125#1:146\n125#1:147,2\n*E\n"})
public final class DatabaseMigrationPanel
extends LiquibasePanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseMigrationState state;
    @NotNull
    private final ListItemEditor<DatabaseInfo> itemEditor;
    @NotNull
    private final SListModelEditor<DatabaseInfo> editor;
    @NotNull
    private final DatabaseInfoPanel itemPanel;
    @NotNull
    private final JPanel itemPanelWrapper;
    @NotNull
    public static final String EMPTY = "empty";
    @NotNull
    public static final String PANEL = "panel";

    public DatabaseMigrationPanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.state = DatabaseMigrationConfig.Companion.getInstance(project).getState();
        this.itemEditor = (ListItemEditor)new ListItemEditor<DatabaseInfo>(){

            public Class<? extends DatabaseInfo> getItemClass() {
                return DatabaseInfo.class;
            }

            public DatabaseInfo clone(DatabaseInfo item, boolean forInPlaceEditing) {
                DatabaseInfo databaseInfo;
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                DatabaseInfo it = databaseInfo = new DatabaseInfo();
                boolean bl = false;
                it.setDbmsId(item.getDbmsId());
                it.setEnabled(item.isEnabled());
                it.setMappingTypes(CollectionsKt.toMutableList((Collection)item.getMappingTypes()));
                return databaseInfo;
            }

            public boolean isEmpty(DatabaseInfo item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return false;
            }

            public String getName(DatabaseInfo item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                String string = item.getDbmsId();
                if (string == null) {
                    String string2 = LiquibaseResourceBundle.message("database.migration.unsedDbId", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                    return string2;
                }
                String dbmsId = string;
                DbType dbType = DbType.Companion.parse(dbmsId, null);
                if (dbType == null) {
                    String string3 = LiquibaseResourceBundle.message("database.migration.unsedDbId", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                    return string3;
                }
                DbType dbType2 = dbType;
                return dbType2.getLiquibaseDbms();
            }
        };
        this.editor = new MyListModelEditor(this.itemEditor);
        CardLayout cardLayout = new CardLayout();
        this.itemPanelWrapper = new JPanel(cardLayout);
        Object object = ReadAction.compute(() -> DatabaseMigrationPanel._init_$lambda$0(project));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        this.itemPanel = (DatabaseInfoPanel)object;
        this.editor.disableUpDownActions();
        this.editor.getToolbarDecorator().disableRemoveAction();
        this.editor.getToolbarDecorator().disableAddAction();
        this.editor.getList().addListSelectionListener(arg_0 -> DatabaseMigrationPanel._init_$lambda$1(this, cardLayout, arg_0));
        JLabel descLabel = new JLabel(LiquibaseResourceBundle.message("database.migration.description", new Object[0]));
        descLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)25));
        this.itemPanelWrapper.add((Component)descLabel, EMPTY);
        this.itemPanelWrapper.add((Component)this.itemPanel.getPanel(), PANEL);
        Splitter splitter2 = new Splitter(false, 0.3f);
        JComponent jComponent = this.editor.createComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"createComponent(...)");
        JComponent editorComponent = jComponent;
        editorComponent.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)1, (int)1, (int)1, (int)0));
        splitter2.setFirstComponent(editorComponent);
        splitter2.setSecondComponent((JComponent)this.itemPanelWrapper);
        this.setLayout(new BorderLayout());
        this.add((Component)splitter2, "Center");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void loadFromState() {
        List databaseInfos = new ArrayList();
        Iterable $this$forEach$iv = DbType.Companion.getUniqueMainTypes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            Object v0;
            Object object;
            DbType dbType;
            block3: {
                dbType = (DbType)element$iv;
                boolean bl2 = false;
                object = this.state.getDatabaseInfos();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    DatabaseInfo it = (DatabaseInfo)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getDbmsId(), (Object)dbType.getId())) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            DatabaseInfo foundDbInfo = v0;
            if (foundDbInfo == null) {
                void it;
                DatabaseInfo databaseInfo = new DatabaseInfo();
                object = databaseInfo;
                List list = databaseInfos;
                boolean bl4 = false;
                it.setDbmsId(dbType.getId());
                bl = list.add(databaseInfo);
                continue;
            }
            bl = databaseInfos.add(foundDbInfo);
        }
        this.editor.reset(databaseInfos);
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        this.itemPanel.apply();
        return this.editor.isModified();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveToState() {
        this.itemPanel.apply();
        this.editor.ensureNonEmptyNames(LiquibaseResourceBundle.message("database.migration.not.empty.dbms", new Object[0]));
        if (this.isModified()) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            List list = this.editor.apply();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"apply(...)");
            List result = list;
            Iterable iterable = result;
            DatabaseMigrationState databaseMigrationState = this.state;
            boolean $i$f$filter = false;
            void var4_5 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DatabaseInfo it = (DatabaseInfo)element$iv$iv;
                boolean bl = false;
                if (!(!it.isEmpty())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            databaseMigrationState.setDatabaseInfos(CollectionsKt.toMutableList((Collection)((List)destination$iv$iv)));
        }
    }

    private static final DatabaseInfoPanel _init_$lambda$0(Project $project) {
        return new DatabaseInfoPanel($project);
    }

    private static final void _init_$lambda$1(DatabaseMigrationPanel this$0, CardLayout $cardLayout, ListSelectionEvent it) {
        DatabaseInfo item = (DatabaseInfo)this$0.editor.getSelected();
        if (item == null) {
            $cardLayout.show(this$0.itemPanelWrapper, EMPTY);
            this$0.itemPanel.setDatabaseInfo(null);
        } else {
            $cardLayout.show(this$0.itemPanelWrapper, PANEL);
            this$0.itemPanel.setDatabaseInfo((DatabaseInfo)this$0.editor.getMutable((Object)item));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/liquibase/common/gui/settings/db/DatabaseMigrationPanel$Companion;", "", "<init>", "()V", "EMPTY", "", "PANEL", "intellij.liquibase.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0014J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/liquibase/common/gui/settings/db/DatabaseMigrationPanel$MyListModelEditor;", "Lcom/intellij/jpa/jpb/model/ui/component/SListModelEditor;", "Lcom/intellij/liquibase/common/config/DatabaseInfo;", "itemEditor", "Lcom/intellij/util/ui/ListItemEditor;", "<init>", "(Lcom/intellij/liquibase/common/gui/settings/db/DatabaseMigrationPanel;Lcom/intellij/util/ui/ListItemEditor;)V", "getIcon", "Ljavax/swing/Icon;", "value", "addActionPerformed", "", "anActionButton", "Lcom/intellij/ui/AnActionButton;", "intellij.liquibase.common"})
    public final class MyListModelEditor
    extends SListModelEditor<DatabaseInfo> {
        public MyListModelEditor(ListItemEditor<DatabaseInfo> itemEditor2) {
            Intrinsics.checkNotNullParameter(itemEditor2, (String)"itemEditor");
            super(itemEditor2);
        }

        @Nullable
        protected Icon getIcon(@Nullable DatabaseInfo value) {
            Object object = value;
            if (object == null || (object = ((DatabaseInfo)object).getDbmsId()) == null) {
                return null;
            }
            Object dbmsId = object;
            DbType dbType = DbType.Companion.parse((String)dbmsId, null);
            if (dbType == null) {
                return null;
            }
            DbType dbType2 = dbType;
            return JpaUiUtil.getDbTypeIcon((DbType)dbType2);
        }

        protected void addActionPerformed(@NotNull AnActionButton anActionButton) {
            Intrinsics.checkNotNullParameter((Object)anActionButton, (String)"anActionButton");
        }
    }
}

