/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.service;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.packageChecker.model.Severity;
import com.intellij.packageChecker.model.SeverityFactory;
import com.intellij.packageChecker.model.Vulnerability;
import com.intellij.packageChecker.model.VulnerablePackage;
import com.intellij.packageChecker.service.Checked;
import com.intellij.packageChecker.service.PackageStatusKt;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u001a\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u001eJ\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\t\u0010$\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u0010\u001a\u00020\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0016\u001a\u00020\u00178FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0015\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006%"}, d2={"Lcom/intellij/packageChecker/service/Vulnerable;", "Lcom/intellij/packageChecker/service/Checked;", "vulnerablePackage", "Lcom/intellij/packageChecker/model/VulnerablePackage;", "checkTime", "Ljava/util/Date;", "<init>", "(Lcom/intellij/packageChecker/model/VulnerablePackage;Ljava/util/Date;)V", "getVulnerablePackage", "()Lcom/intellij/packageChecker/model/VulnerablePackage;", "getCheckTime", "()Ljava/util/Date;", "equals", "", "other", "", "maxSeverity", "Lcom/intellij/packageChecker/model/Severity;", "getMaxSeverity", "()Lcom/intellij/packageChecker/model/Severity;", "maxSeverity$delegate", "Lkotlin/Lazy;", "problemHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "getProblemHighlightType", "()Lcom/intellij/codeInspection/ProblemHighlightType;", "problemHighlightType$delegate", "hashCode", "", "generateInspectionMessage", "", "property", "safeVersion", "component1", "component2", "copy", "toString", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nPackageStatus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageStatus.kt\ncom/intellij/packageChecker/service/Vulnerable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1#2:106\n*E\n"})
public final class Vulnerable
extends Checked {
    @NotNull
    private final VulnerablePackage vulnerablePackage;
    @NotNull
    private final Date checkTime;
    @NotNull
    private final Lazy maxSeverity$delegate;
    @NotNull
    private final Lazy problemHighlightType$delegate;

    public Vulnerable(@NotNull VulnerablePackage vulnerablePackage, @NotNull Date checkTime) {
        Intrinsics.checkNotNullParameter((Object)vulnerablePackage, (String)"vulnerablePackage");
        Intrinsics.checkNotNullParameter((Object)checkTime, (String)"checkTime");
        super(vulnerablePackage.getPkg(), checkTime, null);
        this.vulnerablePackage = vulnerablePackage;
        this.checkTime = checkTime;
        this.maxSeverity$delegate = LazyKt.lazy(() -> Vulnerable.maxSeverity_delegate$lambda$0(this));
        this.problemHighlightType$delegate = LazyKt.lazy(() -> Vulnerable.problemHighlightType_delegate$lambda$0(this));
    }

    @NotNull
    public final VulnerablePackage getVulnerablePackage() {
        return this.vulnerablePackage;
    }

    @Override
    @NotNull
    public Date getCheckTime() {
        return this.checkTime;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.packageChecker.service.Vulnerable");
        Vulnerable cfr_ignored_0 = (Vulnerable)object2;
        return Intrinsics.areEqual((Object)this.vulnerablePackage, (Object)((Vulnerable)other).vulnerablePackage);
    }

    @NotNull
    public final Severity getMaxSeverity() {
        Lazy lazy = this.maxSeverity$delegate;
        return (Severity)lazy.getValue();
    }

    @NotNull
    public final ProblemHighlightType getProblemHighlightType() {
        Lazy lazy = this.problemHighlightType$delegate;
        return (ProblemHighlightType)lazy.getValue();
    }

    public int hashCode() {
        return this.vulnerablePackage.hashCode();
    }

    @NotNull
    public final String generateInspectionMessage(@NotNull String property, @Nullable String safeVersion) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        return PackageStatusKt.generateInspectionMessage$default(this.vulnerablePackage, property, safeVersion, null, null, 12, null);
    }

    public static /* synthetic */ String generateInspectionMessage$default(Vulnerable vulnerable, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return vulnerable.generateInspectionMessage(string, string2);
    }

    @NotNull
    public final VulnerablePackage component1() {
        return this.vulnerablePackage;
    }

    @NotNull
    public final Date component2() {
        return this.checkTime;
    }

    @NotNull
    public final Vulnerable copy(@NotNull VulnerablePackage vulnerablePackage, @NotNull Date checkTime) {
        Intrinsics.checkNotNullParameter((Object)vulnerablePackage, (String)"vulnerablePackage");
        Intrinsics.checkNotNullParameter((Object)checkTime, (String)"checkTime");
        return new Vulnerable(vulnerablePackage, checkTime);
    }

    public static /* synthetic */ Vulnerable copy$default(Vulnerable vulnerable, VulnerablePackage vulnerablePackage, Date date, int n, Object object) {
        if ((n & 1) != 0) {
            vulnerablePackage = vulnerable.vulnerablePackage;
        }
        if ((n & 2) != 0) {
            date = vulnerable.checkTime;
        }
        return vulnerable.copy(vulnerablePackage, date);
    }

    @NotNull
    public String toString() {
        return "Vulnerable(vulnerablePackage=" + this.vulnerablePackage + ", checkTime=" + this.checkTime + ")";
    }

    private static final Severity maxSeverity_delegate$lambda$0(Vulnerable this$0) {
        Iterator iterator = ((Iterable)this$0.vulnerablePackage.getVulnerabilities()).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        Vulnerability it = (Vulnerability)iterator.next();
        boolean bl = false;
        float f = it.getCvssScore();
        while (iterator.hasNext()) {
            Vulnerability it2 = (Vulnerability)iterator.next();
            $i$a$-maxOf-Vulnerable$maxSeverity$2$maxScore$1 = false;
            float f2 = it2.getCvssScore();
            f = Math.max(f, f2);
        }
        float maxScore = f;
        return SeverityFactory.Companion.fromScore(maxScore);
    }

    private static final ProblemHighlightType problemHighlightType_delegate$lambda$0(Vulnerable this$0) {
        return switch (WhenMappings.$EnumSwitchMapping$0[this$0.getMaxSeverity().getType().ordinal()]) {
            case 1 -> ProblemHighlightType.WEAK_WARNING;
            case 2 -> ProblemHighlightType.WEAK_WARNING;
            case 3 -> ProblemHighlightType.WARNING;
            case 4 -> ProblemHighlightType.ERROR;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Severity.Type.values().length];
            try {
                nArray[Severity.Type.Low.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.Type.Medium.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.Type.High.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.Type.Critical.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

