/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.factories;

import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.factories.FactoriesBean;
import com.intellij.spring.factories.FactoryBeanInfo;
import com.intellij.spring.factories.ObjectTypeResolver;
import com.intellij.spring.factories.SpringFactoryBeansManager;
import com.intellij.spring.factories.resolvers.BeanReferenceFactoryBeanTypeResolver;
import com.intellij.spring.factories.resolvers.FactoryPropertiesDependentTypeResolver;
import com.intellij.spring.factories.resolvers.JndiObjectFactoryBeanTypeResolver;
import com.intellij.spring.factories.resolvers.MethodInvokingFactoryBeanTypeResolver;
import com.intellij.spring.factories.resolvers.MyBatisPlaceMapperTypeResolver;
import com.intellij.spring.factories.resolvers.ProxyFactoryBeanTypeResolver;
import com.intellij.spring.factories.resolvers.ScopedProxyFactoryBeanTypeResolver;
import com.intellij.spring.factories.resolvers.SingleObjectTypeResolver;
import com.intellij.spring.factories.resolvers.SpringEjbTypeResolver;
import com.intellij.spring.factories.resolvers.TransactionProxyFactoryBeanTypeResolver;
import com.intellij.spring.factories.resolvers.UtilConstantTypeResolver;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.utils.PsiTypeUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.uast.UastModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public final class SpringFactoryBeansManagerImpl
extends SpringFactoryBeansManager {
    private static final Key<CachedValue<Set<PsiType>>> CACHED_OBJECT_TYPE = Key.create((String)"CACHED_OBJECT_TYPE");
    private final Map<String, ObjectTypeResolver> mySpringFactories = new HashMap<String, ObjectTypeResolver>();
    private final ObjectTypeResolver[] myCustomResolvers = new ObjectTypeResolver[]{new TransactionProxyFactoryBeanTypeResolver(), new JndiObjectFactoryBeanTypeResolver(), new SpringEjbTypeResolver(), new ProxyFactoryBeanTypeResolver(), new ScopedProxyFactoryBeanTypeResolver(), new BeanReferenceFactoryBeanTypeResolver(), new UtilConstantTypeResolver(), new MethodInvokingFactoryBeanTypeResolver(), new MyBatisPlaceMapperTypeResolver()};
    @NonNls
    private static final String FACTORIES_RESOURCE_XML = "/resources/factories/factories.xml";
    @NonNls
    private static final String PROPERTY_NAME_DELIMITER = ",";
    private static final int BUNDLED_FACTORIES_VERSION = 1;

    public SpringFactoryBeansManagerImpl() {
        FactoriesBean factoriesBean = (FactoriesBean)XmlSerializer.deserialize((URL)SpringFactoryBeansManagerImpl.class.getResource(FACTORIES_RESOURCE_XML), FactoriesBean.class);
        assert (factoriesBean.getFactories() != null);
        for (FactoryBeanInfo factoryBeanInfo : factoriesBean.getFactories()) {
            String factory = factoryBeanInfo.getFactory();
            if (factory == null || factory.trim().isEmpty()) continue;
            this.mySpringFactories.put(factory, this.getObjectTypeResolver(factoryBeanInfo));
        }
    }

    public static int getIndexingVersion() {
        return 1;
    }

    @Nullable
    private ObjectTypeResolver getObjectTypeResolver(FactoryBeanInfo factoryBeanInfo) {
        String type = factoryBeanInfo.getObjectType();
        if (!StringUtil.isEmptyOrSpaces((String)type)) {
            return new SingleObjectTypeResolver(type);
        }
        String delimitedNames = factoryBeanInfo.getPropertyNames();
        if (!StringUtil.isEmptyOrSpaces((String)delimitedNames)) {
            return new FactoryPropertiesDependentTypeResolver(StringUtil.split((String)delimitedNames, (String)PROPERTY_NAME_DELIMITER));
        }
        String factoryClass = factoryBeanInfo.getFactory();
        for (ObjectTypeResolver customResolver : this.myCustomResolvers) {
            if (!customResolver.accept(factoryClass)) continue;
            return customResolver;
        }
        return null;
    }

    public PsiType @NotNull [] getObjectTypes(@NotNull PsiType factoryType, @Nullable CommonSpringBean context) {
        Set objectTypes;
        if (factoryType == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(0);
        }
        HashSet<Object> types = new HashSet<Object>();
        PsiClass factoryClass = factoryType instanceof PsiClassType ? ((PsiClassType)factoryType).resolve() : null;
        Set<Object> set = objectTypes = factoryClass != null ? this.getObjectTypes(factoryClass, context) : Collections.emptySet();
        if (objectTypes.isEmpty()) {
            Set<PsiType> psiTypes = SpringFactoryBeansManagerImpl.guessObjectTypes(factoryClass);
            if (!psiTypes.isEmpty()) {
                ContainerUtil.addAllNotNull(types, psiTypes);
            } else {
                PsiType typeParameter = PsiUtil.substituteTypeParameter((PsiType)factoryType, (String)"org.springframework.beans.factory.FactoryBean", (int)0, (boolean)false);
                if (typeParameter != null && !"java.lang.Object".equals(typeParameter.getCanonicalText())) {
                    types.add(typeParameter);
                }
            }
        } else {
            types.addAll(objectTypes);
        }
        PsiType[] psiTypeArray = types.toArray(PsiType.EMPTY_ARRAY);
        if (psiTypeArray == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(1);
        }
        return psiTypeArray;
    }

    @Nullable
    private static PsiType createTypeByTypeName(@Nullable PsiClass factoryClass, @Nullable String typeName) {
        if (factoryClass == null || StringUtil.isEmptyOrSpaces((String)typeName)) {
            return null;
        }
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)factoryClass.getProject()).findClass(typeName, factoryClass.getResolveScope());
        if (psiClass != null) {
            return PsiTypesUtil.getClassType((PsiClass)psiClass);
        }
        try {
            return JavaPsiFacade.getElementFactory((Project)factoryClass.getProject()).createTypeFromText(typeName, (PsiElement)factoryClass);
        }
        catch (IncorrectOperationException incorrectOperationException) {
            return null;
        }
    }

    public Set<PsiClass> getKnownBeanFactories(@NotNull Project project) {
        if (project == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(2);
        }
        HashSet factories = new HashSet();
        ContainerUtil.addAllNotNull(factories, this.getFactoryBeansFromLibs(project));
        ContainerUtil.addAllNotNull(factories, this.getUserDefinedFactoryBeans(project));
        return Collections.unmodifiableSet(factories);
    }

    @NotNull
    public Set<PsiClass> getFactoryBeansFromLibs(@NotNull Project project) {
        if (project == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(3);
        }
        Set set = (Set)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> CachedValueProvider.Result.create(this.getFactoryBeanInheritors(project, ProjectScope.getLibrariesScope((Project)project)), (Object[])new Object[]{JavaLibraryModificationTracker.getInstance((Project)project)}));
        if (set == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public Set<PsiClass> getFactoryBeanInheritors(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        PsiClass beanFactoryClass;
        if (project == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(6);
        }
        if ((beanFactoryClass = JavaPsiFacade.getInstance((Project)project).findClass("org.springframework.beans.factory.FactoryBean", ProjectScope.getLibrariesScope((Project)project))) != null) {
            Set<PsiClass> set = Set.copyOf(ClassInheritorsSearch.search((PsiClass)beanFactoryClass, (SearchScope)scope, (boolean)true, (boolean)true, (boolean)false).findAll());
            if (set == null) {
                SpringFactoryBeansManagerImpl.$$$reportNull$$$0(7);
            }
            return set;
        }
        Set<PsiClass> set = Collections.emptySet();
        if (set == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    public Set<PsiClass> getUserDefinedFactoryBeans(@NotNull Project project) {
        if (project == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(9);
        }
        Set set = (Set)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            Set<PsiClass> factories = this.getFactoryBeanInheritors(project, ProjectScope.getContentScope((Project)project));
            return CachedValueProvider.Result.create(factories, (Object[])new Object[]{UastModificationTracker.getInstance((Project)project)});
        });
        if (set == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(10);
        }
        return set;
    }

    public boolean isKnownBeanFactory(@Nullable String factoryClass) {
        return this.mySpringFactories.containsKey(factoryClass);
    }

    @NotNull
    private Set<PsiType> getObjectTypes(@NotNull PsiClass factoryClass, @Nullable CommonSpringBean context) {
        ObjectTypeResolver objectTypeResolver;
        if (factoryClass == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(11);
        }
        Set<PsiType> set = (objectTypeResolver = this.getObjectTypeResolver(factoryClass)) != null ? objectTypeResolver.getObjectType(context) : Collections.emptySet();
        if (set == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(12);
        }
        return set;
    }

    @Nullable
    private ObjectTypeResolver getObjectTypeResolver(@NotNull PsiClass factoryClass) {
        if (factoryClass == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(13);
        }
        return (ObjectTypeResolver)CachedValuesManager.getCachedValue((PsiElement)factoryClass, () -> new CachedValueProvider.Result((Object)this.doGetObjectTypeResolver(factoryClass), new Object[]{factoryClass}));
    }

    @Nullable
    private ObjectTypeResolver doGetObjectTypeResolver(@NotNull PsiClass factoryClass) {
        String qualifiedName;
        ObjectTypeResolver typeResolver;
        if (factoryClass == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(14);
        }
        if ((typeResolver = this.mySpringFactories.get(qualifiedName = factoryClass.getQualifiedName())) != null) {
            return typeResolver;
        }
        GlobalSearchScope resolveScope = factoryClass.getResolveScope();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)factoryClass.getProject());
        for (String factoryClassName : this.mySpringFactories.keySet()) {
            ObjectTypeResolver resolver;
            PsiClass psiClass = facade.findClass(factoryClassName, resolveScope);
            if (psiClass == null || !factoryClass.isInheritor(psiClass, false) || (resolver = this.mySpringFactories.get(factoryClassName)) == null) continue;
            return resolver;
        }
        return null;
    }

    private static Set<PsiType> guessObjectTypes(@Nullable PsiClass factoryClass) {
        if (factoryClass == null) {
            return Collections.emptySet();
        }
        return (Set)CachedValuesManager.getManager((Project)factoryClass.getProject()).getCachedValue((UserDataHolder)factoryClass, CACHED_OBJECT_TYPE, () -> {
            Set<PsiType> types = SpringFactoryBeansManagerImpl.doGuessObjectType(factoryClass);
            return new CachedValueProvider.Result(types, SpringFactoryBeansManagerImpl.getDependencies(factoryClass, types));
        }, false);
    }

    private static Object[] getDependencies(@NotNull PsiClass factoryClass, @NotNull Set<PsiType> types) {
        if (factoryClass == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(15);
        }
        if (types == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(16);
        }
        HashSet<PsiClass> deps = new HashSet<PsiClass>();
        deps.add(factoryClass);
        for (PsiType type : types) {
            if (type instanceof PsiClassType) {
                ContainerUtil.addIfNotNull(deps, (Object)((PsiClassType)type).resolve());
                continue;
            }
            return new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
        }
        return ArrayUtil.toObjectArray(deps);
    }

    @Nullable
    private static PsiMethod getProductTypeMethod(PsiClass factoryClass) {
        for (PsiMethod psiMethod : factoryClass.findMethodsByName("getObjectType", true)) {
            if (psiMethod.getParameterList().getParameters().length != 0) continue;
            return psiMethod;
        }
        return null;
    }

    @NotNull
    private static Set<PsiType> doGuessObjectType(PsiClass factoryClass) {
        PsiType factoryBeanGenericType;
        PsiExpression value;
        PsiStatement[] statements;
        VirtualFile file;
        PsiMethod method = SpringFactoryBeansManagerImpl.getProductTypeMethod(factoryClass);
        if (method == null) {
            Set<PsiType> set = Collections.emptySet();
            if (set == null) {
                SpringFactoryBeansManagerImpl.$$$reportNull$$$0(17);
            }
            return set;
        }
        if (method instanceof PsiCompiledElement && (file = method.getContainingFile().getVirtualFile()) != null) {
            FactoryBeanObjectTypeReader reader = new FactoryBeanObjectTypeReader();
            try {
                new ClassReader(file.contentsToByteArray()).accept((ClassVisitor)reader, 2);
            }
            catch (IOException | ArrayIndexOutOfBoundsException exception) {
                // empty catch block
            }
            String qName = reader.getResultQName();
            PsiType psiType = SpringFactoryBeansManagerImpl.createTypeByTypeName(factoryClass, qName);
            Set<Object> set = psiType != null ? Collections.singleton(psiType) : Collections.emptySet();
            if (set == null) {
                SpringFactoryBeansManagerImpl.$$$reportNull$$$0(18);
            }
            return set;
        }
        PsiCodeBlock body = method.getBody();
        if (body != null && (statements = body.getStatements()).length == 1 && statements[0] instanceof PsiReturnStatement && (value = ((PsiReturnStatement)statements[0]).getReturnValue()) != null) {
            if (value instanceof PsiClassObjectAccessExpression) {
                Set<PsiType> set = Collections.singleton(((PsiClassObjectAccessExpression)value).getOperand().getType());
                if (set == null) {
                    SpringFactoryBeansManagerImpl.$$$reportNull$$$0(19);
                }
                return set;
            }
            PsiType psiType = value.getType();
            if (psiType instanceof PsiClassType) {
                PsiType classType = PsiTypeUtil.getInstance((Project)factoryClass.getProject()).findType(Class.class);
                if (classType != null && psiType.isAssignableFrom(classType)) {
                    return SpringFactoryBeansManagerImpl.getClassTypes((PsiClassType)psiType);
                }
            } else if (psiType != null && !psiType.equals(PsiTypes.nullType())) {
                Set<PsiType> set = Collections.singleton(psiType);
                if (set == null) {
                    SpringFactoryBeansManagerImpl.$$$reportNull$$$0(20);
                }
                return set;
            }
        }
        if ((factoryBeanGenericType = PsiUtil.substituteTypeParameter((PsiType)PsiTypesUtil.getClassType((PsiClass)factoryClass), (String)"org.springframework.beans.factory.FactoryBean", (int)0, (boolean)false)) != null) {
            Set<PsiType> set = Collections.singleton(factoryBeanGenericType);
            if (set == null) {
                SpringFactoryBeansManagerImpl.$$$reportNull$$$0(21);
            }
            return set;
        }
        Set<PsiType> set = Collections.emptySet();
        if (set == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(22);
        }
        return set;
    }

    @NotNull
    private static Set<PsiType> getClassTypes(PsiClassType psiType) {
        PsiType type;
        List types = SpringCommonUtils.resolveGenerics((PsiClassType)psiType);
        if (types.size() == 1 && (type = (PsiType)types.get(0)) instanceof PsiClassType) {
            PsiClass aClass = ((PsiClassType)type).resolve();
            if (aClass instanceof PsiTypeParameter) {
                HashSet<PsiType> classNames = new HashSet<PsiType>();
                Collections.addAll(classNames, aClass.getExtendsListTypes());
                HashSet<PsiType> hashSet = classNames;
                if (hashSet == null) {
                    SpringFactoryBeansManagerImpl.$$$reportNull$$$0(23);
                }
                return hashSet;
            }
            Set<PsiType> set = Collections.singleton(type);
            if (set == null) {
                SpringFactoryBeansManagerImpl.$$$reportNull$$$0(24);
            }
            return set;
        }
        Set<PsiType> set = Collections.emptySet();
        if (set == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(25);
        }
        return set;
    }

    @TestOnly
    public void registerFactory(String className, ObjectTypeResolver resolver) {
        this.mySpringFactories.put(className, resolver);
    }

    @TestOnly
    public void unregisterFactory(String className) {
        this.mySpringFactories.remove(className);
    }

    public boolean isFactoryBeanClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(26);
        }
        Project project = psiClass.getProject();
        VirtualFile virtualFile = psiClass.getContainingFile().getVirtualFile();
        boolean libraryClasses = virtualFile != null && ProjectRootManager.getInstance((Project)project).getFileIndex().isInLibraryClasses(virtualFile);
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)project);
        if (libraryClasses) {
            String path;
            Map libraryFactoryBeanClassCache = (Map)cachedValuesManager.getCachedValue((UserDataHolder)project, () -> CachedValueProvider.Result.createSingleDependency(new ConcurrentHashMap(), (Object)JavaLibraryModificationTracker.getInstance((Project)project)));
            Boolean isBeanFactory = (Boolean)libraryFactoryBeanClassCache.get(path = virtualFile.getPath());
            if (isBeanFactory != null) {
                return isBeanFactory;
            }
            isBeanFactory = InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.springframework.beans.factory.FactoryBean");
            libraryFactoryBeanClassCache.put(path, isBeanFactory);
            return isBeanFactory;
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            boolean isBeanFactory = InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.springframework.beans.factory.FactoryBean");
            return CachedValueProvider.Result.createSingleDependency((Object)isBeanFactory, (Object)UastModificationTracker.getInstance((Project)project));
        });
    }

    public boolean isValidFactoryMethod(@NotNull PsiMethod psiMethod, boolean isBeansXmlFactoryBean) {
        if (psiMethod == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(27);
        }
        if (psiMethod.isConstructor() || psiMethod.getReturnType() == null) {
            return false;
        }
        boolean isStatic = psiMethod.hasModifierProperty("static");
        return (isBeansXmlFactoryBean && !isStatic || !isBeansXmlFactoryBean && isStatic) && SpringFactoryBeansManagerImpl.hasFactoryReturnType(psiMethod);
    }

    public static boolean hasFactoryReturnType(@NotNull PsiMethod psiMethod) {
        PsiType returnType;
        if (psiMethod == null) {
            SpringFactoryBeansManagerImpl.$$$reportNull$$$0(28);
        }
        return (returnType = psiMethod.getReturnType()) instanceof PsiPrimitiveType || returnType instanceof PsiClassType || returnType instanceof PsiArrayType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 7, 8, 10, 12, 17, 18, 19, 20, 21, 22, 23, 24, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factoryType";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/factories/SpringFactoryBeansManagerImpl";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factoryClass";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/factories/SpringFactoryBeansManagerImpl";
                break;
            }
            case 1: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectTypes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactoryBeansFromLibs";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactoryBeanInheritors";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserDefinedFactoryBeans";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "doGuessObjectType";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getObjectTypes";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getKnownBeanFactories";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFactoryBeansFromLibs";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFactoryBeanInheritors";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getUserDefinedFactoryBeans";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getObjectTypeResolver";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doGetObjectTypeResolver";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isFactoryBeanClass";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isValidFactoryMethod";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "hasFactoryReturnType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 7, 8, 10, 12, 17, 18, 19, 20, 21, 22, 23, 24, 25 -> new IllegalStateException(string);
        };
    }

    private static class FactoryBeanObjectTypeReader
    extends ClassVisitor {
        private String myResultQName;

        FactoryBeanObjectTypeReader() {
            super(589824);
        }

        public String getResultQName() {
            return this.myResultQName;
        }

        public MethodVisitor visitMethod(int access, @NonNls String name, String desc, String signature, String[] exceptions) {
            if ("getObjectType".equals(name) && (signature == null || signature.startsWith("()"))) {
                return new MethodVisitor(589824){
                    private String qname;
                    private int number;
                    {
                        super(arg0);
                        this.number = 0;
                    }

                    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                        if ((this.number == 0 || this.number == 7) && opcode == 178 || this.number == 5 && opcode == 179) {
                            ++this.number;
                        }
                    }

                    public void visitJumpInsn(int opcode, Label label) {
                        if (this.number == 1 && opcode == 199 || this.number == 6 && opcode == 167) {
                            ++this.number;
                        }
                    }

                    public void visitLdcInsn(Object cst) {
                        if (this.number == 2 && cst instanceof String) {
                            ++this.number;
                            this.qname = (String)cst;
                        } else if (this.number == 0 && cst instanceof Type) {
                            ++this.number;
                            this.qname = ((Type)cst).getClassName();
                        }
                    }

                    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                        if (this.number != 3 || opcode != 184 || !"class$".equals(name)) {
                            return;
                        }
                        ++this.number;
                    }

                    public void visitInsn(int opcode) {
                        if (this.number == 4 && opcode == 89) {
                            ++this.number;
                        }
                        if ((this.number == 8 || this.number == 1) && opcode == 176) {
                            if (myResultQName == null) {
                                myResultQName = this.qname;
                            }
                            ++this.number;
                        }
                    }
                };
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

